/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import net.ssehub.easy.instantiation.core.model.buildlangModel.IEnumeratingLoop;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IRuleElement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleBlock;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Utils;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.ILanguageElement;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public class ForStatement
extends RuleBlock
implements IRuleElement,
IEnumeratingLoop {
    private VariableDeclaration[] variables;
    private Expression expr;
    private TypeDescriptor<?>[] givenTypes;
    private boolean colon;

    public ForStatement(VariableDeclaration[] variables, Expression expr, IRuleElement[] body, TypeDescriptor<?>[] givenTypes, boolean colon) throws VilException {
        super("", body);
        if (null == variables || variables.length < 1) {
            throw new VilException("no iterator variables given", 70001);
        }
        if (null != givenTypes && variables.length != givenTypes.length) {
            throw new VilException("given types length does not match to variables length", 70001);
        }
        this.givenTypes = givenTypes;
        this.variables = variables;
        this.expr = expr;
        this.colon = colon;
        if (null == expr) {
            throw new VilException("no expression given", 70001);
        }
    }

    @Override
    public int getVariablesCount() {
        return this.variables.length;
    }

    @Override
    public VariableDeclaration getVariable(int index) {
        return this.variables[index];
    }

    @Override
    public TypeDescriptor<?> getGivenType(int index) {
        return null == this.givenTypes ? null : this.givenTypes[index];
    }

    @Override
    public Expression getExpression() {
        return this.expr;
    }

    @Override
    public Object accept(IVisitor visitor) throws VilException {
        Object result = null;
        if (visitor instanceof IVisitor) {
            result = visitor.visitForStatement(this);
        }
        return result;
    }

    @Override
    public boolean isColonSeparator() {
        return this.colon;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public IRuleElement determinesResult() {
        return Utils.findLastExpressionStatement(this);
    }

    @Override
    public String getElementName() {
        return "for";
    }

    @Override
    public boolean returnActualValue() {
        return false;
    }

    @Override
    protected void setParent(ILanguageElement parent) {
        super.setParent(parent);
        for (int v = 0; v < this.getVariablesCount(); ++v) {
            this.getVariable(v).setParent(this);
        }
    }
}

