/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import net.ssehub.easy.instantiation.core.model.buildlangModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.JoinVariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class JoinExpression
extends Expression {
    private JoinVariableDeclaration[] joinVariables;
    private JoinVariableDeclaration[] visibleVariables;
    private Expression condition;
    private TypeDescriptor<?> type;

    public JoinExpression(JoinVariableDeclaration[] joinVariables, Expression condition) throws VilException {
        int j;
        if (null == joinVariables || 0 == joinVariables.length) {
            throw new VilException("no join variables given", 70001);
        }
        if (1 == joinVariables.length) {
            throw new VilException("not enough join variables given", 70001);
        }
        this.joinVariables = joinVariables;
        int visibleCount = 0;
        for (j = 0; j < joinVariables.length; ++j) {
            if (joinVariables[j].isExcluded()) continue;
            ++visibleCount;
        }
        if (0 == joinVariables.length) {
            throw new VilException("at least one join variable must be visible (i.e., not all must be excluded)", 70001);
        }
        this.visibleVariables = new JoinVariableDeclaration[visibleCount];
        visibleCount = 0;
        for (j = 0; j < joinVariables.length; ++j) {
            if (joinVariables[j].isExcluded()) continue;
            this.visibleVariables[visibleCount++] = joinVariables[j];
        }
        if (null != condition) {
            this.condition = condition;
            if (!TypeRegistry.booleanType().isAssignableFrom(this.condition.inferType())) {
                throw new VilException("join expression must be boolean", 70001);
            }
        }
    }

    public int getVariablesCount() {
        return this.joinVariables.length;
    }

    public JoinVariableDeclaration getVariable(int index) {
        return this.joinVariables[index];
    }

    public int getVisibleVariablesCount() {
        return this.visibleVariables.length;
    }

    public JoinVariableDeclaration getVisibleVariable(int index) {
        return this.visibleVariables[index];
    }

    public Expression getCondition() {
        return this.condition;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        if (null == this.type) {
            TypeDescriptor<?>[] tmp = TypeDescriptor.createArray(this.visibleVariables.length);
            for (int j = 0; j < this.visibleVariables.length; ++j) {
                tmp[j] = this.visibleVariables[j].getType();
                if (tmp[j].getGenericParameterCount() <= 0) continue;
                tmp[j] = tmp[j].getGenericParameterType(0);
            }
            this.type = TypeRegistry.getSequenceType(tmp);
        }
        return this.type;
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        Object result = visitor instanceof IVisitor ? ((IVisitor)((Object)visitor)).visitJoinExpression(this) : visitor.visitExpression(this);
        return result;
    }
}

