/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import java.util.Map;
import net.ssehub.easy.instantiation.core.model.buildlangModel.AbstractRule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleCallExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleDescriptor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleExecutionResult;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.AbstractRuleMatchExpression;
import net.ssehub.easy.instantiation.core.model.common.ILanguageElement;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class Rule
extends AbstractRule {
    private AbstractRuleMatchExpression[] lhsRuleMatches;
    private RuleCallExpression[] lhsRuleCalls;
    private AbstractRuleMatchExpression[] rhsRuleMatches;
    private RuleCallExpression[] rhsRuleCalls;
    private VariableDeclaration[] parameters;
    private Map<String, VariableDeclaration> namedParam;
    private boolean isProtected = false;
    private Script parent;
    private VariableDeclaration[] lhsVars;
    private VariableDeclaration[] rhsVars;
    private VariableDeclaration[] rhsMatchVars;
    private TypeDescriptor<?> returnType;

    Rule() {
        super(null, null);
    }

    public Rule(String name, boolean isProtected, TypeDescriptor<?> returnType, VariableDeclaration[] parameters, Script parent) {
        super(name, null);
        this.isProtected = isProtected;
        this.parent = parent;
        this.parameters = parameters;
        this.namedParam = VariableDeclaration.mapDefaultedParameters(this.namedParam, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.parameters);
        this.returnType = null != returnType ? returnType : this.getDefaultReturnType();
    }

    public Rule(String name, boolean isProtected, VariableDeclaration[] parameters, RuleDescriptor descriptor, Script parent) {
        this(name, isProtected, null, parameters, parent);
        this.setDescriptorInformation(descriptor);
    }

    public void setDescriptorInformation(RuleDescriptor descriptor) {
        this.lhsRuleMatches = descriptor.getRuleMatches(Side.LHS);
        this.lhsRuleCalls = descriptor.getRuleCalls(Side.LHS);
        this.rhsRuleMatches = descriptor.getRuleMatches(Side.RHS);
        this.rhsRuleCalls = descriptor.getRuleCalls(Side.RHS);
        this.lhsVars = descriptor.getVariables(Side.LHS);
        this.rhsVars = descriptor.getVariables(Side.RHS);
        this.rhsMatchVars = descriptor.getMatchVariables(Side.RHS);
        if (null != descriptor.getReturnType()) {
            this.returnType = descriptor.getReturnType();
        }
    }

    @Override
    public Script getParent() {
        return this.parent;
    }

    @Override
    public int getParameterCount() {
        return null == this.parameters ? 0 : this.parameters.length;
    }

    @Override
    public VariableDeclaration getParameter(int index) {
        if (null == this.parameters) {
            throw new IndexOutOfBoundsException();
        }
        return this.parameters[index];
    }

    @Override
    public int getRequiredParameterCount() {
        return VariableDeclaration.getRequiredParameterCount(this.namedParam, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.parameters);
    }

    @Override
    public VariableDeclaration getParameter(String name) {
        return (VariableDeclaration)VariableDeclaration.getParameter(this.namedParam, (String)name, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.parameters);
    }

    public VariableDeclaration getVariable(Side side, int index) {
        VariableDeclaration[] vars = this.selectVars(side);
        return vars[index];
    }

    public VariableDeclaration getMatchVariable(Side side, int index) {
        VariableDeclaration[] vars = this.selectMatchVars(side);
        VariableDeclaration result = null;
        if (null != vars && index < vars.length) {
            result = vars[index];
        }
        return result;
    }

    public int getVariablesCount(Side side) {
        VariableDeclaration[] vars = this.selectVars(side);
        return null == vars ? 0 : vars.length;
    }

    private VariableDeclaration[] selectVars(Side side) {
        VariableDeclaration[] result = Side.LHS == side ? this.lhsVars : this.rhsVars;
        return result;
    }

    private VariableDeclaration[] selectMatchVars(Side side) {
        VariableDeclaration[] result = Side.LHS == side ? null : this.rhsMatchVars;
        return result;
    }

    private AbstractRuleMatchExpression[] selectConditions(Side side) {
        AbstractRuleMatchExpression[] result = Side.LHS == side ? this.lhsRuleMatches : this.rhsRuleMatches;
        return result;
    }

    private RuleCallExpression[] selectCalls(Side side) {
        RuleCallExpression[] result = Side.LHS == side ? this.lhsRuleCalls : this.rhsRuleCalls;
        return result;
    }

    @Override
    public boolean hasCondition(Side side) {
        return this.getRuleCallCount(side) + this.getRuleConditionCount(side) > 0;
    }

    @Override
    public int getRuleConditionCount(Side side) {
        AbstractRuleMatchExpression[] conditions = this.selectConditions(side);
        return null == conditions ? 0 : conditions.length;
    }

    @Override
    public AbstractRuleMatchExpression getRuleCondition(Side side, int index) {
        AbstractRuleMatchExpression[] conditions = this.selectConditions(side);
        if (null == conditions) {
            throw new IndexOutOfBoundsException();
        }
        return conditions[index];
    }

    @Override
    public int getRuleCallCount(Side side) {
        RuleCallExpression[] conditions = this.selectCalls(side);
        return null == conditions ? 0 : conditions.length;
    }

    @Override
    public RuleCallExpression getRuleCall(Side side, int index) {
        RuleCallExpression[] conditions = this.selectCalls(side);
        if (null == conditions) {
            throw new IndexOutOfBoundsException();
        }
        return conditions[index];
    }

    @Override
    public boolean isProtected() {
        return this.isProtected;
    }

    @Override
    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitRule(this);
    }

    @Override
    public IMetaType getParameterType(int index) {
        return this.parameters[index].getType();
    }

    @Override
    public String getJavaSignature() {
        return this.getSignature();
    }

    @Override
    public String getSignature() {
        StringBuilder signature = new StringBuilder(this.getName());
        signature.append("(");
        if (null != this.parameters) {
            for (int p = 0; p < this.parameters.length; ++p) {
                signature.append(this.parameters[p].getType().getVilName());
                if (p >= this.parameters.length - 1) continue;
                signature.append(",");
            }
        }
        signature.append(")");
        return signature.toString();
    }

    public TypeDescriptor<?> getDefaultReturnType() {
        return RuleExecutionResult.TYPE;
    }

    @Override
    public boolean returnActualValue() {
        return !TypeRegistry.equals(this.getDefaultReturnType(), this.getReturnType());
    }

    @Override
    public TypeDescriptor<?> getReturnType() {
        return this.returnType;
    }

    @Override
    public boolean acceptsNamedParameters() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isFirstParameterOperand() {
        return false;
    }

    @Override
    public IMetaType getDeclaringType() {
        return this.parent;
    }

    @Override
    public void appendCallTo(AbstractRule target, boolean qualifiedCall) throws VilException {
        if (null != target) {
            CallArgument[] args = new CallArgument[this.getParameterCount()];
            for (int p = 0; p < args.length; ++p) {
                args[p] = new CallArgument(new VariableExpression(this.getParameter(p)));
            }
            String name = target.getName();
            if (qualifiedCall) {
                name = target.getParent().getName() + "::" + name;
            }
            RuleCallExpression call = new RuleCallExpression(target.getParent(), false, name, args);
            call.inferType();
            ExpressionStatement stmt = new ExpressionStatement(call);
            stmt.setParent(this);
            this.append(stmt);
        }
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }

    @Override
    public boolean isVirtual() {
        return false;
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getSignature();
    }

    @Override
    protected void setParent(ILanguageElement parent) {
        super.setParent(parent);
        for (int v = 0; v < this.getParameterCount(); ++v) {
            this.getParameter(v).setParent(this);
        }
        this.setParentFor(this.lhsVars);
        this.setParentFor(this.rhsVars);
        this.setParentFor(this.rhsMatchVars);
    }

    protected void setParentFor(VariableDeclaration[] vars) {
        if (null != vars) {
            for (int v = 0; v < vars.length; ++v) {
                this.setParentFor(vars[v]);
            }
        }
    }

    protected void setParentFor(VariableDeclaration var) {
        var.setParent(this);
    }

    @Override
    public IMetaOperation.CompatibilityResult isCompatible(Class<?> retType, Object ... params) {
        return null;
    }

    @Override
    public Object invoke(Object ... args) throws VilException {
        return null;
    }

    public static enum Side {
        LHS,
        RHS;

    }
}

