/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel;

import net.ssehub.easy.instantiation.core.model.buildlangModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.buildlangModel.execOperand.ExecutableOperand;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class StrategyCallExpression
extends CallExpression {
    private Type type;
    private boolean execResolved;
    private VariableDeclaration nameVar;
    private transient TypeRegistry typeRegistry = TypeRegistry.DEFAULT;

    StrategyCallExpression() throws VilException {
    }

    public StrategyCallExpression(Object parent, String name, Expression ... arguments) throws VilException {
        this(parent, name, CallArgument.createUnnamedArguments(arguments));
    }

    public StrategyCallExpression(Object parent, String name, CallArgument ... arguments) throws VilException {
        super(parent, name, arguments);
        this.type = Type.INSTANTIATOR;
    }

    public StrategyCallExpression(VariableDeclaration nameVar, Expression ... arguments) throws VilException {
        this(nameVar, CallArgument.createUnnamedArguments(arguments));
    }

    public StrategyCallExpression(VariableDeclaration nameVar, CallArgument ... arguments) throws VilException {
        super(null, nameVar.getName(), arguments);
        this.type = Type.EXECUTE;
        this.nameVar = nameVar;
    }

    public void setTypeRegistry(TypeRegistry registry) {
        if (null != registry) {
            this.typeRegistry = registry;
        }
    }

    public VariableDeclaration getNameVariable() {
        return this.nameVar;
    }

    @Override
    protected boolean doZeroArgumentTest() {
        return false;
    }

    public Type getType() {
        return this.type;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        TypeDescriptor<?> result;
        switch (this.type) {
            case EXECUTE: {
                result = this.inferTypeExecute();
                break;
            }
            case INSTANTIATOR: {
                result = super.inferType();
                break;
            }
            default: {
                throw new VilException("illegal strategy type " + (Object)((Object)this.type), 70000);
            }
        }
        return result;
    }

    private TypeDescriptor<?> inferTypeExecute() throws VilException {
        if (!this.execResolved) {
            TypeDescriptor<?> arg0Type;
            for (int a = 0; a < this.getArgumentsCount(); ++a) {
                this.getArgument(a).inferType();
            }
            if (this.getArgumentsCount() > 0 && null == ExecutableOperand.getExecutableType(arg0Type = this.getArgument(0).inferType())) {
                throw new VilException("cannot execute system call on " + arg0Type.getName(), 70002);
            }
            this.execResolved = true;
        }
        return TypeRegistry.voidType();
    }

    @Override
    protected TypeDescriptor<?> determineOperand() throws VilException {
        TypeDescriptor<? extends IVilType> instantiator = this.typeRegistry.getInstantiator(this.getName());
        if (null == instantiator) {
            throw new VilException("unknown instantiator " + this.getName(), 70002);
        }
        return instantiator;
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        Object result = visitor instanceof IVisitor ? ((IVisitor)((Object)visitor)).visitStrategyCallExpression(this) : visitor.visitExpression(this);
        return result;
    }

    @Override
    public boolean isPlaceholder() {
        boolean isPlaceholder = Type.EXECUTE == this.type ? false : super.isPlaceholder();
        return isPlaceholder;
    }

    public static enum Type {
        INSTANTIATOR,
        EXECUTE;

    }
}

