/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel.matchLoop;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Rule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.buildlangModel.matchLoop.Applicator;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractListWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public class BuildCollectionApplicator
extends Applicator {
    private List<List<Object>> rhsObjects = new ArrayList<List<Object>>();
    private RuntimeEnvironment environment;

    public BuildCollectionApplicator(RuntimeEnvironment environment) {
        this.environment = environment;
    }

    @Override
    public void apply(Object expectedLhsValue, Object rhsValue, int index) throws VilException {
        if (index < 0 || index >= this.getElementCount()) {
            throw new IndexOutOfBoundsException();
        }
        while (this.rhsObjects.size() <= index) {
            this.rhsObjects.add(null);
        }
        List<Object> coll = this.rhsObjects.get(index);
        if (null == coll) {
            coll = new ArrayList<Object>();
            this.rhsObjects.set(index, coll);
        }
        coll.add(rhsValue);
    }

    @Override
    public void conditionLoopFinished() throws VilException {
        if (null != this.rhsValues) {
            for (int c = 0; c < this.rhsValues.length; ++c) {
                AbstractListWrapper build = null;
                Object rhsValue = this.rhsValues[c];
                TypeDescriptor<?> rhsEntryType = this.rule.getRuleCondition(Rule.Side.RHS, c).getEntryType();
                if (rhsValue instanceof Set) {
                    build = new ListSet<Object>(this.rhsObjects.get(c), rhsEntryType);
                } else if (rhsValue instanceof Sequence) {
                    build = new ListSequence<Object>(this.rhsObjects.get(c), rhsEntryType);
                }
                this.environment.addValue(this.rule.getMatchVariable(Rule.Side.RHS, c), build);
            }
        }
    }
}

