/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel.matchLoop;

import java.util.Iterator;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.PathUtils;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Rule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.matchLoop.Applicator;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.AbstractRuleMatchExpression;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;

public class LhsRhsMatchLoop {
    public static void matchLoop(Rule rule, Object[] rhsValues, Applicator applicator, ITracer tracer) throws VilException {
        if (null != rhsValues) {
            applicator.initialize(rule, rhsValues);
            int lhsCondCount = rule.getRuleConditionCount(Rule.Side.LHS);
            for (int c = 0; !applicator.stopConditionLoop() && c < rhsValues.length; ++c) {
                if (rhsValues[c] instanceof Boolean) {
                    if (Boolean.TRUE != rhsValues[c]) continue;
                    applicator.apply(rhsValues[c], rhsValues[c], c);
                    continue;
                }
                if (rhsValues[c] instanceof Collection) {
                    Collection<?> coll = (Collection<?>)rhsValues[c];
                    coll = tracer.adjustSequenceForMap(coll);
                    Iterator<?> iter = coll.iterator();
                    AbstractRuleMatchExpression rhs = rule.getRuleCondition(Rule.Side.RHS, c);
                    AbstractRuleMatchExpression lhs = c < lhsCondCount ? rule.getRuleCondition(Rule.Side.LHS, c) : null;
                    while (iter.hasNext() && !applicator.stopMatchLoop()) {
                        Object rhsValue;
                        Object expectedLhsValue = null != lhs ? lhs.determineExpected(rhs, rhsValue) : null;
                        if (!LhsRhsMatchLoop.buildNeeded(expectedLhsValue, rhsValue = iter.next())) continue;
                        applicator.apply(expectedLhsValue, rhsValue, c);
                    }
                    applicator.matchLoopFinished();
                    continue;
                }
                if (null == rhsValues[c]) continue;
                EASyLoggerFactory.INSTANCE.getLogger(LhsRhsMatchLoop.class, "net.ssehub.easy.instantiation.core").error("unrecognized LHS/RHS value: " + rhsValues[c]);
            }
            applicator.conditionLoopFinished();
        }
    }

    private static boolean buildNeeded(Object lhsValue, Object rhsValue) {
        boolean needed = true;
        if (rhsValue instanceof IArtifact) {
            IArtifact rArtifact = (IArtifact)rhsValue;
            if (rArtifact.exists()) {
                if (lhsValue instanceof IArtifact) {
                    IArtifact lArtifact = (IArtifact)lhsValue;
                    if (!lArtifact.exists()) {
                        needed = true;
                    } else {
                        long rLast = PathUtils.normalizeTime(rArtifact.lastModification());
                        long lLast = PathUtils.normalizeTime(lArtifact.lastModification());
                        needed = rLast > 0L && lLast > 0L && rLast >= lLast;
                    }
                } else {
                    needed = lhsValue == null;
                }
            } else {
                needed = false;
            }
        }
        return needed;
    }
}

