/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.AbstractRuleMatchExpression;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;

public abstract class AbstractPathRuleMatchExpression
extends AbstractRuleMatchExpression {
    private static final char MULTIPLE_CHAR_MATCH_CHAR = '*';
    private static final char SINGLE_CHAR_MATCH_CHAR = '?';
    private static final char NORMALIZED_FILE_SEPARATOR_CHAR = '/';
    private static final String MULTIPLE_CHAR_MATCH = String.valueOf('*');
    private static final String SINGLE_CHAR_MATCH = String.valueOf('?');
    private static final String NORMALIZED_FILE_SEPARATOR = String.valueOf('/');
    private static final int INDEX_LEFT = 0;
    private static final int INDEX_RIGHT = 1;

    protected abstract Path getResolved();

    @Override
    public Object determineExpected(AbstractRuleMatchExpression rhsExpr, Object rhsValue) throws VilException {
        IFileSystemArtifact result = null;
        if (null != this.getResolved()) {
            Path resultPath = null;
            String lhsPath = this.getResolved().getPath();
            List<String> lhsTokens = AbstractPathRuleMatchExpression.tokenize(lhsPath, false);
            if (AbstractPathRuleMatchExpression.containsWildcards(lhsTokens)) {
                AbstractPathRuleMatchExpression rhsRule;
                if (rhsExpr instanceof AbstractPathRuleMatchExpression && null != (rhsRule = (AbstractPathRuleMatchExpression)rhsExpr).getResolved()) {
                    String rhsPath = rhsRule.getResolved().getPath();
                    String rhsValueText = StringValueHelper.getStringValue(rhsValue, null);
                    List<String> rhsTokens = AbstractPathRuleMatchExpression.tokenize(rhsPath, false);
                    AbstractPathRuleMatchExpression.match(rhsTokens, rhsValueText);
                    String lhs = AbstractPathRuleMatchExpression.replaceWildcards(lhsTokens, rhsTokens);
                    resultPath = Path.createInstance(lhs, this.getResolved().getArtifactModel());
                }
            } else {
                resultPath = this.getResolved();
            }
            if (null != resultPath) {
                result = ArtifactFactory.createArtifact(IFileSystemArtifact.class, resultPath.getAbsolutePath(), resultPath.getArtifactModel());
            }
        }
        return result;
    }

    @Override
    public boolean contributesTo(AbstractRuleMatchExpression expression) {
        boolean result = false;
        if (null != this.getResolved()) {
            AbstractPathRuleMatchExpression rhsRule;
            String lhsPath = this.getResolved().getPath();
            if (expression instanceof AbstractPathRuleMatchExpression && null != (rhsRule = (AbstractPathRuleMatchExpression)expression).getResolved()) {
                String rhsPath = rhsRule.getResolved().getPath();
                result = AbstractPathRuleMatchExpression.overlaps(lhsPath, rhsPath);
            }
        }
        return result;
    }

    public static boolean overlaps(String leftPattern, String rightPattern) {
        boolean result = false;
        if (leftPattern.length() > 0 && rightPattern.length() > 0) {
            leftPattern = AbstractPathRuleMatchExpression.preparePattern(leftPattern);
            rightPattern = AbstractPathRuleMatchExpression.preparePattern(rightPattern);
            result = AbstractPathRuleMatchExpression.overlaps(leftPattern, 0, rightPattern, 0);
        }
        return result;
    }

    public static boolean overlaps(String leftPattern, int lPos, String rightPattern, int rPos) {
        boolean result = false;
        boolean fail = false;
        int[] pos = new int[]{lPos, rPos};
        MatchState lState = AbstractPathRuleMatchExpression.determineState(leftPattern, pos[0]);
        MatchState rState = AbstractPathRuleMatchExpression.determineState(rightPattern, pos[1]);
        while (pos[0] < leftPattern.length() && pos[1] < rightPattern.length() && !fail && !result) {
            int lastP = pos[0];
            int lastR = pos[1];
            char pChar = leftPattern.charAt(pos[0]);
            char rChar = rightPattern.charAt(pos[1]);
            if (MatchState.EXACT_CHAR == rState) {
                if (MatchState.EXACT_CHAR == lState) {
                    if (pChar == rChar) {
                        pos[0] = pos[0] + 1;
                        pos[1] = pos[1] + 1;
                    } else {
                        fail = true;
                    }
                } else {
                    pos[1] = pos[1] + 1;
                    if (lState == MatchState.MATCH_SINGLE_CHAR) {
                        pos[0] = pos[0] + 1;
                    } else {
                        result = AbstractPathRuleMatchExpression.tryAndTrackBack(leftPattern, lState, rightPattern, rState, pos);
                    }
                }
            } else if (MatchState.MATCH_SINGLE_CHAR == rState) {
                pos[1] = pos[1] + 1;
                if (MatchState.EXACT_CHAR == lState || MatchState.MATCH_SINGLE_CHAR == lState) {
                    pos[0] = pos[0] + 1;
                } else {
                    result = AbstractPathRuleMatchExpression.tryAndTrackBack(leftPattern, lState, rightPattern, rState, pos);
                }
            } else if (MatchState.MATCH_MULTI_CHAR == rState) {
                if (MatchState.EXACT_CHAR == lState || MatchState.MATCH_SINGLE_CHAR == lState) {
                    pos[0] = pos[0] + 1;
                    result = AbstractPathRuleMatchExpression.tryAndTrackBack(leftPattern, lState, rightPattern, rState, pos);
                } else {
                    result = AbstractPathRuleMatchExpression.tryAndTrackBack(leftPattern, lState, rightPattern, rState, pos);
                    fail = !result;
                }
            } else if (MatchState.MATCH_DEEP_PATH == rState) {
                if (MatchState.EXACT_CHAR == lState || MatchState.MATCH_SINGLE_CHAR == lState) {
                    pos[0] = pos[0] + 1;
                    result = AbstractPathRuleMatchExpression.tryAndTrackBack(leftPattern, lState, rightPattern, rState, pos);
                } else {
                    result = AbstractPathRuleMatchExpression.tryAndTrackBack(leftPattern, lState, rightPattern, rState, pos);
                    boolean bl = fail = !result;
                }
            }
            if (fail) continue;
            lState = AbstractPathRuleMatchExpression.determineNextState(leftPattern, pos[0], lastP, lState);
            rState = AbstractPathRuleMatchExpression.determineNextState(rightPattern, pos[1], lastR, rState);
        }
        if (!result && !fail) {
            result = pos[0] >= leftPattern.length() && pos[1] >= rightPattern.length();
        }
        return result;
    }

    private static boolean tryAndTrackBack(String leftPattern, MatchState leftState, String rightPattern, MatchState rightState, int[] pos) {
        boolean result = false;
        int pOffset = leftState.getOffset();
        int rOffset = rightState.getOffset();
        if (pOffset > 0) {
            result = AbstractPathRuleMatchExpression.overlaps(leftPattern, pos[0] + pOffset, rightPattern, pos[1]);
        }
        if (!result && rOffset > 0) {
            result = AbstractPathRuleMatchExpression.overlaps(leftPattern, pos[0], rightPattern, pos[1] + rOffset);
        }
        if (!result && rOffset > 0 && pOffset > 0) {
            result = AbstractPathRuleMatchExpression.overlaps(leftPattern, pos[0] + pOffset, rightPattern, pos[1] + rOffset);
        }
        return result;
    }

    private static String preparePattern(String pattern) {
        pattern = pattern.trim();
        pattern = pattern.replace('\\', '/');
        if ((pattern = pattern.replace(NORMALIZED_FILE_SEPARATOR + NORMALIZED_FILE_SEPARATOR, NORMALIZED_FILE_SEPARATOR)).endsWith(NORMALIZED_FILE_SEPARATOR)) {
            pattern = pattern + "**";
        }
        pattern = pattern.replace("**" + NORMALIZED_FILE_SEPARATOR + "**", "**");
        return pattern;
    }

    private static boolean isPatternChar(char ch) {
        return '*' == ch || '?' == ch || '/' == ch;
    }

    private static MatchState determineNextState(String text, int pos, int lastPos, MatchState state) {
        if (lastPos != pos && pos < text.length()) {
            char c = text.charAt(pos);
            boolean determineState = false;
            switch (state) {
                case MATCH_DEEP_PATH: {
                    determineState = !AbstractPathRuleMatchExpression.isPatternChar(c);
                    break;
                }
                case MATCH_MULTI_CHAR: {
                    if (c != '/') break;
                    determineState = true;
                    break;
                }
                case MATCH_SINGLE_CHAR: {
                    determineState = true;
                    break;
                }
                default: {
                    determineState = true;
                }
            }
            if (determineState) {
                state = AbstractPathRuleMatchExpression.determineState(text, pos);
            }
        }
        return state;
    }

    private static MatchState determineState(String text, int pos) {
        MatchState state;
        if (pos < text.length()) {
            char c = text.charAt(pos);
            switch (c) {
                case '*': {
                    if (pos + 1 < text.length() && '*' == text.charAt(pos + 1)) {
                        state = MatchState.MATCH_DEEP_PATH;
                        break;
                    }
                    state = MatchState.MATCH_MULTI_CHAR;
                    break;
                }
                case '?': {
                    state = MatchState.MATCH_SINGLE_CHAR;
                    break;
                }
                default: {
                    state = MatchState.EXACT_CHAR;
                    break;
                }
            }
        } else {
            state = null;
        }
        return state;
    }

    public static String replace(String lhsPattern, String rhsPattern, String rhsValue) {
        String result = lhsPattern;
        List<String> lhsTokens = AbstractPathRuleMatchExpression.tokenize(lhsPattern, false);
        if (AbstractPathRuleMatchExpression.containsWildcards(lhsTokens)) {
            List<String> rhsTokens = AbstractPathRuleMatchExpression.tokenize(rhsPattern, false);
            AbstractPathRuleMatchExpression.match(rhsTokens, rhsValue);
            result = AbstractPathRuleMatchExpression.replaceWildcards(lhsTokens, rhsTokens);
        }
        return result;
    }

    private static boolean isWildcard(String token) {
        return token.equals(SINGLE_CHAR_MATCH) || token.equals(MULTIPLE_CHAR_MATCH) || token.equals("**");
    }

    private static boolean containsWildcards(List<String> tokens) {
        boolean containsWildcards = false;
        for (int i = 0; !containsWildcards && i < tokens.size(); ++i) {
            containsWildcards = AbstractPathRuleMatchExpression.isWildcard(tokens.get(i));
        }
        return containsWildcards;
    }

    private static void match(List<String> tokens, String valueText) {
        boolean tokenRemoved;
        int textPos = 0;
        for (int tokenPos = 0; tokenPos < tokens.size() && textPos < valueText.length(); tokenPos += tokenRemoved ? 0 : 1) {
            int pos;
            String token = tokens.get(tokenPos);
            boolean isLastToken = tokenPos + 1 == tokens.size();
            tokenRemoved = false;
            if (token.equals(SINGLE_CHAR_MATCH)) {
                tokens.set(tokenPos, valueText.substring(textPos, textPos + 1));
                ++textPos;
                continue;
            }
            if (token.equals(MULTIPLE_CHAR_MATCH)) {
                if (isLastToken) {
                    int pos2 = valueText.indexOf(47, textPos);
                    if (pos2 < 0) {
                        tokens.set(tokenPos, valueText.substring(textPos));
                        textPos = valueText.length();
                        continue;
                    }
                    tokens.set(tokenPos, valueText.substring(textPos, pos2));
                    textPos = pos2;
                    continue;
                }
                String next = tokens.get(tokenPos + 1);
                pos = valueText.indexOf(next, textPos);
                if (pos < 0) break;
                tokens.set(tokenPos, valueText.substring(textPos, pos));
                textPos = pos;
                continue;
            }
            if (token.equals("**")) {
                if (isLastToken) {
                    int pos3 = valueText.lastIndexOf(47);
                    if (pos3 < 0 || pos3 <= textPos) break;
                    tokens.set(tokenPos, valueText.substring(textPos, pos3));
                    textPos = pos3;
                    continue;
                }
                String next = tokens.get(tokenPos + 1);
                pos = valueText.lastIndexOf(next);
                if (pos > textPos) {
                    if (pos < 0) break;
                    tokens.set(tokenPos, valueText.substring(textPos, pos));
                    textPos = pos;
                    continue;
                }
                tokens.set(tokenPos, "");
                textPos = pos;
                continue;
            }
            if (!valueText.startsWith(token, textPos)) break;
            tokens.remove(tokenPos);
            textPos += token.length();
            tokenRemoved = true;
        }
        if (textPos < valueText.length()) {
            tokens.clear();
        }
    }

    private static String replaceWildcards(List<String> tokens, List<String> values) {
        int t;
        StringBuilder tmp = new StringBuilder();
        int v = 0;
        for (t = 0; t < tokens.size() && v < values.size(); ++t) {
            String token = tokens.get(t);
            if (token.equals(SINGLE_CHAR_MATCH)) {
                if (v < values.size()) {
                    token = values.get(v);
                    if (token.length() > 0) {
                        token = token.substring(0, 1);
                    }
                    ++v;
                }
            } else if (token.equals("**")) {
                if (v < values.size()) {
                    token = values.get(v);
                    ++v;
                    boolean replaceByEmptyAndReduce = 0 == token.length();
                    replaceByEmptyAndReduce &= tmp.length() > 0 && tmp.charAt(tmp.length() - 1) == '/';
                    if (replaceByEmptyAndReduce &= t + 1 < tokens.size() && tokens.get(t + 1).startsWith(NORMALIZED_FILE_SEPARATOR)) {
                        tmp.deleteCharAt(tmp.length() - 1);
                    }
                }
            } else if (token.equals(MULTIPLE_CHAR_MATCH) && v < values.size()) {
                token = values.get(v);
                int pos = token.indexOf(47);
                if (pos > 0) {
                    token = token.substring(0, pos);
                }
                ++v;
            }
            tmp.append(token);
        }
        while (t < tokens.size()) {
            tmp.append(tokens.get(t));
            ++t;
        }
        return tmp.toString();
    }

    private static List<String> tokenize(String text, boolean considerSeparator) {
        ArrayList<String> result = new ArrayList<String>();
        int len = text.length();
        int lastMatch = -1;
        for (int i = 0; i < len; ++i) {
            char c = text.charAt(i);
            if ('*' == c) {
                if (i > 0) {
                    result.add(text.substring(lastMatch + 1, i));
                }
                if (i + 1 < len && '*' == text.charAt(i + 1)) {
                    result.add("**");
                } else {
                    result.add("*");
                }
                lastMatch = ++i;
                continue;
            }
            if ('?' == c) {
                if (i > 0) {
                    result.add(text.substring(lastMatch + 1, i));
                }
                result.add(SINGLE_CHAR_MATCH);
                lastMatch = i;
                continue;
            }
            if (!considerSeparator || '/' != c) continue;
            result.add(text.substring(lastMatch + 1, i));
            result.add(NORMALIZED_FILE_SEPARATOR);
            lastMatch = i;
        }
        if (lastMatch + 1 < len) {
            result.add(text.substring(lastMatch + 1, len));
        }
        return result;
    }

    private static enum MatchState {
        EXACT_CHAR(0),
        MATCH_SINGLE_CHAR(0),
        MATCH_MULTI_CHAR(1),
        MATCH_DEEP_PATH(2);

        private int offset;

        private MatchState(int offset) {
            this.offset = offset;
        }

        public int getOffset() {
            return this.offset;
        }
    }
}

