/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch;

import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactTypes;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.AbstractRuleMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.IMatchVisitor;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public class ArtifactMatchExpression
extends AbstractRuleMatchExpression {
    private Expression expression;
    private transient Object resolved;

    public ArtifactMatchExpression(Expression expression) throws VilException {
        if (!ArtifactTypes.artifactType().isAssignableFrom(expression.inferType())) {
            throw new VilException("expression does not evaluate to an artifact", 70001);
        }
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public TypeDescriptor<?> getEntryType() {
        return ArtifactTypes.artifactType();
    }

    @Override
    public Object determineExpected(AbstractRuleMatchExpression rhsExpr, Object rhsValue) {
        return this.resolved;
    }

    @Override
    protected Object accept(IMatchVisitor visitor) throws VilException {
        return visitor.visitArtifactMatchExpression(this);
    }

    @Override
    public boolean contributesTo(AbstractRuleMatchExpression expression) {
        return false;
    }

    @Override
    public Collection<?> evaluate(IExpressionVisitor evaluator) throws VilException {
        ArraySet<IArtifact> result;
        Object value = this.expression.accept(evaluator);
        if (value instanceof FileArtifact) {
            FileArtifact[] resultArray = new FileArtifact[]{(FileArtifact)value};
            TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
            param[0] = this.getEntryType();
            result = new ArraySet<FileArtifact>(resultArray, param);
        } else if (value instanceof IArtifact) {
            IArtifact[] resultArray = new IArtifact[]{(IArtifact)value};
            TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
            param[0] = this.getEntryType();
            result = new ArraySet<IArtifact>(resultArray, param);
        } else {
            throw new VilException("artifact match expression value is not of type Artifact", 70000);
        }
        return result;
    }

    void resolve(Object resolved) {
        this.resolved = resolved;
    }
}

