/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch;

import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.AbstractRuleMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.IMatchVisitor;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class BooleanMatchExpression
extends AbstractRuleMatchExpression {
    private Expression expression;
    private transient Object resolved;

    public BooleanMatchExpression(Expression expression) throws VilException {
        if (TypeRegistry.booleanType() != expression.inferType()) {
            throw new VilException("expression does not evaluate to a Boolean", 70001);
        }
        this.expression = expression;
    }

    @Override
    public TypeDescriptor<?> getEntryType() {
        return TypeRegistry.booleanType();
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public Object determineExpected(AbstractRuleMatchExpression rhsExpr, Object rhsValue) throws VilException {
        return this.resolved;
    }

    @Override
    protected Object accept(IMatchVisitor visitor) throws VilException {
        return visitor.visitBooleanMatchExpression(this);
    }

    @Override
    public boolean contributesTo(AbstractRuleMatchExpression expression) {
        return false;
    }

    @Override
    public Collection<?> evaluate(IExpressionVisitor evaluator) throws VilException {
        return null;
    }

    void resolve(Object resolved) {
        this.resolved = resolved;
    }
}

