/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch;

import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.AbstractRuleMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.IMatchVisitor;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public class CollectionMatchExpression
extends AbstractRuleMatchExpression {
    private Expression expression;
    private transient Object resolved;
    private TypeDescriptor<? extends Collection<? extends IArtifact>> type;

    public CollectionMatchExpression(Expression expression) throws VilException {
        this.type = CollectionMatchExpression.ensureType(expression.inferType());
        this.expression = expression;
    }

    public Expression getExpression() {
        return this.expression;
    }

    @Override
    public TypeDescriptor<?> getEntryType() {
        return this.type.getGenericParameterType(0);
    }

    @Override
    public TypeDescriptor<? extends Collection<? extends IArtifact>> inferType() throws VilException {
        return this.type;
    }

    @Override
    protected Object accept(IMatchVisitor visitor) throws VilException {
        return visitor.visitCollectionMatchExpression(this);
    }

    @Override
    public Object determineExpected(AbstractRuleMatchExpression rhsExpr, Object rhsValue) {
        return this.resolved;
    }

    @Override
    public boolean contributesTo(AbstractRuleMatchExpression expression) {
        return false;
    }

    @Override
    public Collection<?> evaluate(IExpressionVisitor evaluator) throws VilException {
        Object value = this.expression.accept(evaluator);
        if (!(value instanceof Collection)) {
            throw new VilException("value is not a collection", 70000);
        }
        Collection result = (Collection)value;
        return result;
    }

    void resolve(Object resolved) {
        this.resolved = resolved;
    }
}

