/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch;

import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.AbstractPathRuleMatchExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.ruleMatch.IMatchVisitor;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class PathMatchExpression
extends AbstractPathRuleMatchExpression {
    private Expression pathExpression;
    private transient Path resolved;

    public PathMatchExpression(Expression expression) throws VilException {
        if (TypeRegistry.DEFAULT.getType(Path.class) != expression.inferType()) {
            throw new VilException("expression does not evaluate to a path", 70001);
        }
        this.pathExpression = expression;
    }

    public Expression getExpression() {
        return this.pathExpression;
    }

    @Override
    public TypeDescriptor<?> getEntryType() {
        return TypeRegistry.DEFAULT.getType(IFileSystemArtifact.class);
    }

    @Override
    protected Object accept(IMatchVisitor visitor) throws VilException {
        return visitor.visitPathMatchExpression(this);
    }

    void resolve(Path resolved) {
        this.resolved = resolved;
    }

    @Override
    public Path getResolved() {
        return this.resolved;
    }

    @Override
    public Collection<?> evaluate(IExpressionVisitor evaluator) throws VilException {
        Path path = this.getResolved();
        Set<FileArtifact> result = null != path ? path.selectAll() : null;
        return result;
    }
}

