/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IModelListener;
import net.ssehub.easy.basics.modelManagement.ModelEvents;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.instantiation.core.model.common.Advice;
import net.ssehub.easy.instantiation.core.model.common.Compound;
import net.ssehub.easy.instantiation.core.model.common.ICompoundReceiver;
import net.ssehub.easy.instantiation.core.model.common.IResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.ITypedefReceiver;
import net.ssehub.easy.instantiation.core.model.common.Imports;
import net.ssehub.easy.instantiation.core.model.common.Typedef;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaParameterDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.Project;

public abstract class AbstractResolvableModel<V extends IMetaParameterDeclaration, M extends IModel>
implements IResolvableModel<V, M>,
IModelListener<Project>,
ITypedefReceiver,
ICompoundReceiver {
    private transient boolean dirty = false;
    private Imports<M> imports;
    private TypeRegistry registry;
    private Advice[] advices;
    private List<Typedef> typedefs;
    private List<Compound> compounds;

    protected AbstractResolvableModel(Imports<M> imports, TypeRegistry registry, Advice[] advices) {
        this.imports = imports;
        this.registry = registry;
        this.advices = advices;
        this.processModelListeners(true);
    }

    private void processModelListeners(boolean add) {
        if (null != this.advices) {
            ModelEvents<Project> events = VarModel.INSTANCE.events();
            for (int a = 0; a < this.advices.length; ++a) {
                Project resolved = this.advices[a].getResolved();
                if (null == resolved) continue;
                if (add) {
                    events.addModelListener(resolved, this);
                    EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").info("Added model listener to " + resolved.getName() + " " + System.identityHashCode(resolved) + " from " + this.getName() + " " + System.identityHashCode(this));
                    continue;
                }
                events.removeModelListener(resolved, this);
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").info("Removed model listener to " + resolved.getName() + " " + System.identityHashCode(resolved) + " from " + this.getName() + " " + System.identityHashCode(this));
            }
        }
    }

    @Override
    public int getImportsCount() {
        return null == this.imports ? 0 : this.imports.getImportsCount();
    }

    public ModelImport<M> getImport(int index) {
        if (null == this.imports) {
            throw new IllegalArgumentException();
        }
        return this.imports.getImport(index);
    }

    protected Imports<M> createImports() {
        return new Imports((List)null);
    }

    public void addImport(ModelImport<M> imp) {
        if (null == this.imports) {
            this.imports = this.createImports();
        }
        this.imports.add(imp);
    }

    @Override
    public void addRuntimeImport(ModelImport<M> imp) {
        this.addImport(imp);
    }

    protected Imports<M> getImports() {
        return this.imports;
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.registry;
    }

    public int getAdviceCount() {
        return null == this.advices ? 0 : this.advices.length;
    }

    public Advice getAdvice(int index) {
        if (null == this.advices) {
            throw new IndexOutOfBoundsException();
        }
        return this.advices[index];
    }

    @Override
    public int getTypedefCount() {
        return null == this.typedefs ? 0 : this.typedefs.size();
    }

    @Override
    public Typedef getTypedef(int index) {
        if (null == this.typedefs) {
            throw new IndexOutOfBoundsException();
        }
        return this.typedefs.get(index);
    }

    @Override
    public void addTypedef(Typedef typedef) {
        if (null == this.typedefs) {
            this.typedefs = new ArrayList<Typedef>();
        }
        this.typedefs.add(typedef);
    }

    @Override
    public Typedef getTypedef(String name) {
        Typedef result = null;
        int n = this.getTypedefCount();
        for (int t = 0; null == result && t < n; ++t) {
            Typedef td = this.getTypedef(t);
            if (!td.getName().equals(name)) continue;
            result = td;
        }
        return result;
    }

    @Override
    public void addCompound(Compound compound) {
        if (null == this.compounds) {
            this.compounds = new ArrayList<Compound>();
        }
        this.compounds.add(compound);
    }

    @Override
    public Compound getCompound(String name) {
        Compound result = null;
        int n = this.getCompoundCount();
        for (int c = 0; null == result && c < n; ++c) {
            Compound cmp = this.getCompound(c);
            if (!cmp.getName().equals(name)) continue;
            result = cmp;
        }
        return result;
    }

    @Override
    public int getCompoundCount() {
        return null == this.compounds ? 0 : this.compounds.size();
    }

    @Override
    public Compound getCompound(int index) {
        if (null == this.compounds) {
            throw new IndexOutOfBoundsException();
        }
        return this.compounds.get(index);
    }

    @Override
    public void dispose() {
        this.processModelListeners(false);
    }

    public boolean isDirty() {
        return this.dirty;
    }

    @Override
    public void notifyReplaced(Project oldModel, Project newModel) {
        if (null != newModel) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").info("Model " + this.getName() + " " + System.identityHashCode(this) + " became dirty as " + newModel.getName() + " was changed.");
        }
        this.dirty = true;
    }

    @Override
    public Object getIvmlElement(String name) {
        Object result = null;
        for (int a = 0; null == result && a < this.getAdviceCount(); ++a) {
            result = this.getAdvice(a).getIvmlElement(name);
        }
        return result;
    }

    protected abstract void reload();
}

