/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.net.URI;
import java.util.List;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.instantiation.core.model.common.IVisitor;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.varModel.management.VarModel;
import net.ssehub.easy.varModel.model.IvmlException;
import net.ssehub.easy.varModel.model.ModelQuery;
import net.ssehub.easy.varModel.model.Project;
import net.ssehub.easy.varModel.model.datatypes.IResolutionScope;

public class Advice {
    private String name;
    private IVersionRestriction restrictions;
    private Project resolved;

    public Advice(String name, IVersionRestriction restrictions, Project resolved) {
        this.name = name;
        this.restrictions = restrictions;
        this.resolved = resolved;
    }

    public String getName() {
        return this.name;
    }

    public IVersionRestriction getVersionRestriction() {
        return this.restrictions;
    }

    public Project getResolved() {
        return this.resolved;
    }

    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitAdvice(this);
    }

    public Object getIvmlElement(String name) {
        Object found = null;
        if (null != this.resolved && null != name) {
            found = Advice.getIvmlElement(this.resolved, name);
        }
        return found;
    }

    public static Object getIvmlElement(IResolutionScope scope, String name) {
        Object found = null;
        try {
            found = ModelQuery.findElementByName(scope, name, null);
        }
        catch (IvmlException ivmlException) {
            // empty catch block
        }
        if (null == found) {
            try {
                found = ModelQuery.enumLiteralAsValue(scope, name);
            }
            catch (IvmlException ivmlException) {
                // empty catch block
            }
        }
        return found;
    }

    public static Advice create(String name, URI modelURI, IVersionRestriction restrictions, StringBuilder warning) {
        Project resolved = null;
        ModelInfo resolvingInfo = null;
        List varModels = VarModel.INSTANCE.availableModels().getModelInfo(name);
        if (null != varModels && varModels.size() > 1) {
            varModels = VarModel.INSTANCE.availableModels().getVisibleModelInfo(name, modelURI);
        }
        if (null == varModels || 0 == varModels.size()) {
            warning.append("cannot resolve '" + name + "' - IVML identifier may also not be (fully) resolved");
        } else if (varModels.size() > 1) {
            warning.append("model '" + name + "' cannot be resolved unambigously - IVML identifier may not be (fully) resolved");
        } else {
            resolvingInfo = varModels.get(0);
        }
        if (null != resolvingInfo && null == (resolved = (Project)resolvingInfo.getResolved())) {
            try {
                resolved = (Project)VarModel.INSTANCE.load(resolvingInfo);
            }
            catch (ModelManagementException e) {
                warning.append(e.getMessage());
            }
        }
        return new Advice(name, restrictions, resolved);
    }
}

