/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.text.Collator;
import java.util.Locale;
import net.ssehub.easy.basics.DefaultLocale;
import net.ssehub.easy.instantiation.core.model.common.ITracer;
import net.ssehub.easy.instantiation.core.model.common.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;

public class ExecutionLocal {
    public static Configuration getCurrentConfiguration() {
        Configuration result = null;
        RuntimeEnvironment<?, ?> env = ExecutionLocal.getCurrentRuntimeEnvironment();
        if (null != env) {
            result = env.getTopLevelConfiguration();
        }
        return result;
    }

    public static Locale getCurrentLocale() {
        return ExecutionLocal.doCurrentLocale(null);
    }

    private static Locale doCurrentLocale(Locale locale) {
        Locale result;
        ITracer tracer = ExecutionLocal.getCurrentTracer();
        if (null != tracer) {
            if (null != locale) {
                tracer.setLocale(locale);
            }
            result = tracer.getLocale();
        } else {
            if (null != locale) {
                DefaultLocale.setDefaultLocale(locale);
            }
            result = DefaultLocale.getDefaultLocale();
        }
        return result;
    }

    public static ITracer getCurrentTracer() {
        ITracer tracer = TracerFactory.getRegisteredTemplateLanguageTracer();
        if (null == tracer) {
            tracer = TracerFactory.getRegisteredBuildLanguageTracer();
        }
        return tracer;
    }

    public static TypeRegistry getCurrentTypeRegistry() {
        TypeRegistry result = TypeRegistry.DEFAULT;
        RuntimeEnvironment<?, ?> env = ExecutionLocal.getCurrentRuntimeEnvironment();
        if (null != env) {
            result = env.getTypeRegistry();
        }
        return result;
    }

    private static RuntimeEnvironment<?, ?> getCurrentRuntimeEnvironment() {
        RuntimeEnvironment<?, ?> result = null;
        ITracer tracer = ExecutionLocal.getCurrentTracer();
        if (null != tracer) {
            result = tracer.getRuntimeEnvironment();
        }
        return result;
    }

    public static Locale setCurrentLocale(Locale locale) {
        return ExecutionLocal.doCurrentLocale(locale);
    }

    public static Collator getCurrentCollator() {
        return Collator.getInstance(ExecutionLocal.getCurrentLocale());
    }
}

