/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.buildlangModel.AlternativeExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.MapExpression;
import net.ssehub.easy.instantiation.core.model.buildlangModel.RuleExecutionResult;
import net.ssehub.easy.instantiation.core.model.common.Advice;
import net.ssehub.easy.instantiation.core.model.common.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.common.IResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.IResolvableOperation;
import net.ssehub.easy.instantiation.core.model.common.ITracer;
import net.ssehub.easy.instantiation.core.model.common.IVisitor;
import net.ssehub.easy.instantiation.core.model.common.ModelCallExpression;
import net.ssehub.easy.instantiation.core.model.common.Resolver;
import net.ssehub.easy.instantiation.core.model.common.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.EvaluationVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IArgumentProvider;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionParser;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public abstract class ExecutionVisitor<M extends IResolvableModel<V, M>, O extends IResolvableOperation<V>, V extends VariableDeclaration, R extends Resolver<M, O, ?, V>>
extends EvaluationVisitor
implements IVisitor {
    private RuntimeEnvironment<?, ?> origEnvironment;
    private RuntimeEnvironment<V, M> environment;
    private ITracer tracer;
    private java.util.Map<String, Object> parameter;

    protected ExecutionVisitor(RuntimeEnvironment<V, M> environment, ITracer tracer, java.util.Map<String, Object> parameter) {
        super(environment, tracer);
        this.environment = environment;
        this.tracer = tracer;
        this.origEnvironment = tracer.getRuntimeEnvironment();
        tracer.setRuntimeEnvironment(environment);
        this.parameter = parameter;
    }

    protected java.util.Map<String, Object> replaceParameter(java.util.Map<String, Object> parameter) {
        java.util.Map<String, Object> result = parameter;
        this.parameter = parameter;
        return result;
    }

    @Override
    public RuntimeEnvironment<V, M> getRuntimeEnvironment() {
        return this.environment;
    }

    protected Object getParameter(String name) {
        return this.parameter.get(name);
    }

    protected void enableArtifactAutoStoreOnParameters(boolean autoStore) {
        if (null != this.parameter) {
            for (Object a : this.parameter.values()) {
                if (!(a instanceof IArtifact)) continue;
                if (autoStore) {
                    this.environment.unmarkNoAutoStore((IArtifact)a);
                    continue;
                }
                this.environment.markNoAutoStore((IArtifact)a);
            }
        }
    }

    public void release(boolean releaseDefault) {
        this.tracer.setRuntimeEnvironment(this.origEnvironment);
    }

    protected boolean hasParameter(String name) {
        return this.parameter.containsKey(name);
    }

    protected int getParameterCount() {
        return this.parameter.size();
    }

    protected ITracer getTracer() {
        return this.tracer;
    }

    @Override
    public Object visitVariableDeclaration(VariableDeclaration var) throws VilException {
        Object value = null;
        VariableDeclaration v = var;
        if (null != var.getExpression()) {
            value = var.getExpression().accept(this);
            value = this.doAssignmentConversions(var, value);
            this.environment.addValue(v, value);
            this.tracer.valueDefined(var, null, value);
        } else {
            this.environment.addValue(v, null);
        }
        return value;
    }

    protected Object doAssignmentConversions(VariableDeclaration var, Object value) {
        if (var.getType().isMap()) {
            value = Map.checkConvertEmpty(var.getType(), value);
        }
        return value;
    }

    @Override
    public Object visitAdvice(Advice advice) throws VilException {
        return null;
    }

    @Override
    public Object visitExpressionStatement(ExpressionStatement statement) throws VilException {
        return statement.getExpression().accept(this);
    }

    @Override
    protected void notifyValueDefined(VariableDeclaration var, FieldDescriptor field, Object val) {
        this.tracer.valueDefined(var, field, val);
    }

    protected boolean checkConditionResult(Object value, Object element, ConditionTest test) {
        boolean ok = true;
        if (null == value) {
            ok = false;
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            if (0 == collection.size()) {
                ok = false;
            } else {
                Iterator iter = collection.iterator();
                while (iter.hasNext() && (ok = this.checkConditionResult(iter.next(), element, test))) {
                }
            }
        } else if (Boolean.class.isInstance(value)) {
            ok = (Boolean)value;
        } else if (value instanceof IArtifact) {
            switch (test) {
                case EXISTS: {
                    ok = ((IArtifact)value).exists();
                    break;
                }
                default: {
                    ok = true;
                }
            }
        }
        return ok;
    }

    public void visitModelHeader(IResolvableModel<V, M> model) throws VilException {
        HashSet<IResolvableModel<V, M>> visited = new HashSet<IResolvableModel<V, M>>();
        this.visitModelHeader(model, visited);
    }

    private void visitModelHeader(IResolvableModel<V, M> model, Set<IResolvableModel<V, M>> visited) throws VilException {
        if (!visited.contains(model)) {
            visited.add(model);
            IResolvableModel<V, M> oldContext = this.environment.switchContext(model);
            this.processModelParameter(model);
            for (int i = 0; i < model.getImportsCount(); ++i) {
                ModelImport<?> imp = model.getImport(i);
                IResolvableModel imported = (IResolvableModel)model.getImport(i).getResolved();
                if (null == imported) {
                    throw new VilException(imp.getName() + " is not resolved ", 50009);
                }
                this.visitModelHeader(imported, visited);
            }
            this.initializeImplicitVariables(model);
            for (int v = 0; v < model.getVariableDeclarationCount(); ++v) {
                VariableDeclaration varDecl = (VariableDeclaration)model.getVariableDeclaration(v);
                if (model.isImplicit(varDecl)) continue;
                ((VariableDeclaration)model.getVariableDeclaration(v)).accept(this);
            }
            this.environment.switchContext(oldContext);
        }
    }

    protected void initializeImplicitVariables(IResolvableModel<V, M> model) throws VilException {
    }

    protected void setModelArgument(V param, Object value) throws VilException {
        this.environment.addValue(param, value);
    }

    protected void processModelParameter(IResolvableModel<V, M> model) throws VilException {
        HashMap<String, VariableDeclaration> sParam = new HashMap<String, VariableDeclaration>();
        for (int p = 0; p < model.getParameterCount(); ++p) {
            VariableDeclaration variableDeclaration = (VariableDeclaration)model.getParameter(p);
            sParam.put(variableDeclaration.getName(), variableDeclaration);
        }
        this.handleParameterInSequence(model, sParam);
        for (Map.Entry<String, Object> entry : this.parameter.entrySet()) {
            String name = entry.getKey();
            if (!sParam.containsKey(name)) continue;
            this.setModelArgument((VariableDeclaration)sParam.get(name), entry.getValue());
            sParam.remove(name);
        }
        for (Map.Entry<String, Object> entry : sParam.entrySet()) {
            this.setModelArgument((VariableDeclaration)entry.getValue(), null);
        }
    }

    protected void handleParameterInSequence(IResolvableModel<V, M> model, java.util.Map<String, V> varMap) throws VilException {
    }

    protected java.util.Map<String, Object> determineScriptParam(ModelCallExpression<V, M, O> call) throws VilException {
        HashMap<String, Object> result = null;
        if (null != call) {
            if (null == call.getResolved()) {
                throw new VilException("cannot execute rule " + call.getVilSignature() + " as it is not resolved", 50009);
            }
            O resolved = call.getResolved();
            result = new HashMap<String, Object>();
            for (int a = 0; a < call.getArgumentsCount(); ++a) {
                CallArgument arg = call.getArgument(a);
                Object val = arg.fixValue(this);
                String name = arg.getName();
                if (null == name && a < resolved.getParameterCount()) {
                    name = ((VariableDeclaration)resolved.getParameter(a)).getName();
                }
                result.put(name, val);
            }
        }
        return result;
    }

    protected Object visitModelCallExpression(ModelCallExpression<V, M, O> call) throws VilException {
        return this.proceedModelCall(call.getResolved(), call.getModel(), call, call.isPlaceholder(), !call.isSuper());
    }

    protected Object proceedModelCall(O resolved, M model, IArgumentProvider arguments, boolean isPlaceholder, boolean enableParentScope) throws VilException {
        Object result;
        if (isPlaceholder) {
            result = null;
        } else {
            RuleExecutionResult.Status status = RuleExecutionResult.Status.SUCCESS;
            Object[] args = new Object[arguments.getArgumentsCount()];
            HashMap<String, Object> namedArgs = null;
            for (int a = 0; RuleExecutionResult.Status.SUCCESS == status && a < arguments.getArgumentsCount(); ++a) {
                CallArgument ca = arguments.getArgument(a);
                Object argVal = ca.accept(this);
                if (null == ca.getName() || ca.getName().equals(((VariableDeclaration)resolved.getParameter(a)).getName())) {
                    args[a] = argVal;
                }
                if (null != ca.getName()) {
                    if (null == namedArgs) {
                        namedArgs = new HashMap<String, Object>();
                    }
                    namedArgs.put(ca.getName(), argVal);
                }
                if (!(argVal instanceof RuleExecutionResult)) continue;
                status = ((RuleExecutionResult)argVal).getStatus();
            }
            if (RuleExecutionResult.Status.SUCCESS == status) {
                IResolvableModel<V, M> oldContext = this.environment.switchContext((IResolvableModel<V, M>)model);
                this.environment.pushLevel();
                this.assignModelParameter((IResolvableModel<V, M>)model, oldContext);
                O operation = this.dynamicDispatch(resolved, args, arguments, enableParentScope);
                int reqParamCount = operation.getRequiredParameterCount();
                for (int p = 0; p < operation.getParameterCount(); ++p) {
                    VariableDeclaration param = (VariableDeclaration)operation.getParameter(p);
                    if (p < reqParamCount) {
                        this.environment.addValue(param, args[p]);
                        continue;
                    }
                    if (p >= args.length || p >= reqParamCount) {
                        Object pVal;
                        Object object = pVal = null == namedArgs ? null : (Object)namedArgs.get(param.getName());
                        if (null == pVal && p < args.length) {
                            pVal = args[p];
                        }
                        if (null == pVal) {
                            pVal = this.evaluateDefault(param);
                        }
                        if (null == pVal) continue;
                        this.environment.addValue(param, pVal);
                        continue;
                    }
                    if (null == args[p]) {
                        args[p] = this.evaluateDefault(param);
                    }
                    this.environment.addValue(param, args[p]);
                }
                result = this.executeModelCall(operation);
                this.environment.popLevel();
                this.environment.switchContext(oldContext);
            } else {
                result = null;
            }
        }
        return result;
    }

    private Object evaluateDefault(VariableDeclaration decl) throws VilException {
        Object result = null != decl.getExpression() ? decl.getExpression().accept(this) : null;
        return result;
    }

    protected abstract void assignModelParameter(IResolvableModel<V, M> var1, IResolvableModel<V, M> var2) throws VilException;

    protected void evaluateModelParameter(IResolvableModel<V, M> targetModel, IResolvableModel<V, M> srcModel, int startIndex) throws VilException {
        IRuntimeEnvironment env = this.getRuntimeEnvironment();
        for (int p = startIndex; p < targetModel.getParameterCount(); ++p) {
            VariableDeclaration param = (VariableDeclaration)targetModel.getParameter(p);
            Object val = this.getParameter(param.getName());
            if (null == val) {
                try {
                    val = ((RuntimeEnvironment)env).getValue(srcModel, param.getName());
                }
                catch (VilException vilException) {
                    // empty catch block
                }
            }
            if (null == val && null != param.getExpression()) {
                val = param.getExpression().accept(this);
            }
            if (null == val) continue;
            this.setModelArgument(param, val);
        }
    }

    protected abstract O dynamicDispatch(O var1, Object[] var2, IArgumentProvider var3, boolean var4);

    protected abstract Object executeModelCall(O var1) throws VilException;

    protected Object executeMain(M model, O operation) throws VilException {
        this.environment.pushLevel();
        this.environment.increaseIndentation();
        CallArgument[] args = new CallArgument[operation.getParameterCount()];
        int commonParameterCount = Math.min(operation.getParameterCount(), model.getParameterCount());
        for (int p = 0; p < commonParameterCount; ++p) {
            VariableDeclaration opPar = (VariableDeclaration)operation.getParameter(p);
            VariableDeclaration modelPar = (VariableDeclaration)model.getParameter(p);
            if (!opPar.getType().isAssignableFrom(modelPar.getType())) {
                throw new VilException("model parameter " + modelPar.getName() + " of type " + modelPar.getType().getVilName() + " is not assignable to parameter " + opPar.getName() + " of type " + opPar.getType().getVilName() + " in " + operation.getName(), 50008);
            }
            args[p] = new CallArgument(new VariableExpression((VariableDeclaration)model.getParameter(p)));
            if (this.environment.isDefined(modelPar)) continue;
            this.tracer.traceWarning("Model parameter '" + modelPar.getName() + "' has no value assigned");
        }
        ModelCallExpression<V, M, O> call = this.createModelCall(model, operation, args);
        Object result = call.accept(this);
        this.environment.decreaseIndentation();
        this.environment.popLevel();
        this.environment.storeArtifacts(false);
        return result;
    }

    protected abstract ModelCallExpression<V, M, O> createModelCall(M var1, O var2, CallArgument ... var3) throws VilException;

    protected boolean mayFail(Object elt) {
        boolean result = false;
        if (elt instanceof ExpressionStatement) {
            ExpressionStatement ee = (ExpressionStatement)elt;
            Expression ex = ee.getExpression();
            result = !(ex instanceof CallExpression) && !(ex instanceof MapExpression) && !(ex instanceof ModelCallExpression) && !(ex instanceof AlternativeExpression);
        }
        return result;
    }

    protected Object convertToContainer(Expression expr, Object value, String eltName) throws VilException {
        TypeDescriptor<?> type = expr.inferType();
        if (type.isIterator()) {
            ArrayList result = new ArrayList();
            Iterator iter = (Iterator)value;
            while (iter.hasNext()) {
                result.add(iter.next());
            }
            value = new ListSequence(result, type.getGenericParameter());
        } else if (!type.isCollection()) {
            OperationDescriptor desc = type.getConversionToSequence();
            if (null != desc) {
                value = desc.invoke(value);
            } else {
                throw new VilException("cannot convert " + eltName + " variable to container", 50502);
            }
        }
        return value;
    }

    protected abstract IExpressionParser<R> getExpressionParser();

    protected static enum ConditionTest {
        EXISTS,
        DONT_CARE;

    }
}

