/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.util.HashSet;
import java.util.Set;
import java.util.Stack;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.instantiation.core.model.common.Compound;
import net.ssehub.easy.instantiation.core.model.common.ICallExpressionTester;
import net.ssehub.easy.instantiation.core.model.common.IResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.IResolvableOperation;
import net.ssehub.easy.instantiation.core.model.common.ModelCallExpression;
import net.ssehub.easy.instantiation.core.model.common.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.common.Typedef;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaParameterDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;

public abstract class Resolver<M extends IResolvableModel<V, M>, O extends IResolvableOperation<V>, E extends ModelCallExpression<V, M, O>, V extends IMetaParameterDeclaration>
extends net.ssehub.easy.instantiation.core.model.expressions.Resolver<V> {
    private Stack<M> models = new Stack();

    public Resolver(TypeRegistry registry) {
        super(registry);
    }

    public Resolver(IRuntimeEnvironment environment) {
        super(environment);
        RuntimeEnvironment rEnv;
        IResolvableModel model;
        if (environment instanceof RuntimeEnvironment && null != (model = (rEnv = (RuntimeEnvironment)environment).getContextModel())) {
            this.models.push(model);
        }
    }

    public void pushModel(M model) {
        this.models.push(model);
        this.pushLevel();
        for (int p = 0; p < model.getParameterCount(); ++p) {
            this.add(model.getParameter(p));
        }
        for (int v = 0; v < model.getVariableDeclarationCount(); ++v) {
            Object varDecl = model.getVariableDeclaration(v);
            if (!model.isImplicit(varDecl)) continue;
            this.add(varDecl, "");
        }
    }

    public M getCurrentModel() {
        return (M)(this.models.isEmpty() ? null : (IResolvableModel)this.models.peek());
    }

    public void enumerateImports(M model) {
        String qualifier = model.getName() + "::";
        for (int v = 0; v < model.getVariableDeclarationCount(); ++v) {
            Object varDecl = model.getVariableDeclaration(v);
            if (model.isImplicit(varDecl)) continue;
            this.add(varDecl, qualifier);
        }
        this.addImportedVariables(model, "", new HashSet());
    }

    private void addImportedVariables(M model, String path, Set<M> done) {
        if (!done.contains(model)) {
            done.add(model);
            for (int i = 0; i < model.getImportsCount(); ++i) {
                ModelImport<?> imp = model.getImport(i);
                if (null == imp.getResolved()) continue;
                IResolvableModel m = (IResolvableModel)imp.getResolved();
                String tmp = path + imp.getName() + "::";
                for (int v = 0; v < m.getVariableDeclarationCount(); ++v) {
                    Object varDecl = m.getVariableDeclaration(v);
                    if (model.isImplicit(varDecl)) continue;
                    this.add(varDecl, tmp);
                }
                this.addImportedVariables(m, tmp, done);
            }
        }
    }

    public void popModel() {
        this.models.pop();
        this.popLevel();
    }

    protected abstract E createCallExpression(M var1, boolean var2, String var3, CallArgument ... var4) throws VilException;

    private M determineQualifiedModel(M model, String name) throws VilException {
        String remainderName;
        String modelName;
        IResolvableModel result = null;
        int pos = name.indexOf("::");
        if (pos > 0) {
            modelName = name.substring(0, pos);
            remainderName = name.substring(pos + "::".length(), name.length());
        } else {
            modelName = name;
            remainderName = "";
        }
        if (model.getName().equals(modelName)) {
            result = (IResolvableModel)this.determineQualifiedModel(model, remainderName);
        } else {
            for (int i = 0; null == result && i < model.getImportsCount(); ++i) {
                ModelImport<?> imp = model.getImport(i);
                if (null == imp.getResolved() || !imp.getName().equals(modelName)) continue;
                IResolvableModel importedModel = (IResolvableModel)imp.getResolved();
                result = remainderName.length() > 0 ? this.determineQualifiedModel(importedModel, remainderName) : importedModel;
            }
        }
        return (M)result;
    }

    private M determineQualifiedModel(M model, boolean isSuper, String name) throws VilException {
        M result = null;
        int pos = name.lastIndexOf("::");
        if (pos > 0) {
            if (isSuper) {
                throw new VilException("qualified names cannot be used in super calls", 70002);
            }
            result = this.determineQualifiedModel(model, name.substring(0, pos));
            if (null == result) {
                throw new VilException("cannot resolve qualification in " + name, 70002);
            }
        }
        return result;
    }

    public E createCallExpression(boolean isSuper, String name, CallArgument ... arguments) throws VilException {
        return this.createCallExpression(isSuper, name, new CallExpressionTester(name, arguments), arguments);
    }

    public E createCallExpression(boolean isSuper, String name, ICallExpressionTester<M, O, E, V> tester, CallArgument ... arguments) throws VilException {
        E result = null;
        if (!this.models.isEmpty()) {
            IResolvableModel model = (IResolvableModel)this.models.peek();
            IResolvableModel qModel = this.determineQualifiedModel(model, isSuper, name);
            if (null != qModel) {
                result = tester.createAndCheckCall(qModel, false, model);
            }
            if (null == result) {
                if (!isSuper) {
                    result = tester.createAndCheckCall(model, isSuper, model);
                } else if (null == model.getParent()) {
                    throw new VilException("model is not extended, no super possible", 70002);
                }
                if (null == result) {
                    do {
                        if (null == (model = model.getParent())) continue;
                        result = tester.createAndCheckCall(model, isSuper, model);
                    } while (null != model && null == result);
                }
            }
            for (int s = this.models.size() - 1; null == result && s >= 0; --s) {
                IResolvableModel importedModel = (IResolvableModel)this.models.get(s);
                result = tester.createAndCheckCall(importedModel, false, model);
                for (int i = 0; null == result && i < importedModel.getImportsCount(); ++i) {
                    IResolvableModel imported = (IResolvableModel)importedModel.getImport(i).getResolved();
                    if (null == imported) continue;
                    result = tester.createAndCheckCall(imported, false, importedModel);
                }
            }
            if (null == result) {
                if (null == tester.getLastException()) {
                    throw new VilException("cannot resolve rule " + AbstractCallExpression.getSignature(name, arguments), 70002);
                }
                throw tester.getLastException();
            }
        } else {
            throw new VilException("model stack is empty", 70000);
        }
        return result;
    }

    public CallExpression createExtensionCallExpression(String name, CallArgument ... arguments) throws VilException {
        CallExpression result = null;
        if (!this.models.isEmpty()) {
            VilException lastException = null;
            IResolvableModel model = (IResolvableModel)this.models.peek();
            for (int t = 0; null == result && t < model.getExtensionTypesCount(); ++t) {
                IMetaType type = model.getExtensionType(t);
                try {
                    IMetaOperation op = AbstractCallExpression.resolveOperation(type, name, arguments);
                    if (null == op) continue;
                    result = new CallExpression(op, arguments);
                    result.inferType();
                    continue;
                }
                catch (VilException e) {
                    lastException = e;
                }
            }
            if (null == result && null != lastException) {
                throw lastException;
            }
        }
        return result;
    }

    @Override
    public Object getIvmlElement(String name) {
        Object result = null;
        for (int s = this.models.size() - 1; null == result && s >= 0; --s) {
            result = ((IResolvableModel)this.models.get(s)).getIvmlElement(name);
        }
        if (null == result && null != this.getRuntimeEnvironment()) {
            try {
                Object tmp = this.getRuntimeEnvironment().getIvmlValue(name);
                if (tmp instanceof IvmlElement) {
                    result = tmp;
                }
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    public TypeDescriptor<?> resolveType(String name) {
        TypeDescriptor<?> result = null;
        for (int s = this.models.size() - 1; null == result && s >= 0; --s) {
            result = this.resolveType((IResolvableModel)this.models.get(s), name);
        }
        return result;
    }

    private TypeDescriptor<?> resolveType(M model, String name) {
        Compound cmp;
        TypeDescriptor<?> result = null;
        Typedef td = model.getTypedef(name);
        if (null != td) {
            result = td.getType();
        }
        if (null != (cmp = model.getCompound(name))) {
            result = cmp.getType();
        }
        int n = model.getImportsCount();
        for (int i = 0; null == result && i < n; ++i) {
            ModelImport<?> imp = model.getImport(i);
            if (null == imp.getResolved()) continue;
            result = this.resolveType((IResolvableModel)imp.getResolved(), name);
        }
        return result;
    }

    private class CallExpressionTester
    implements ICallExpressionTester<M, O, E, V> {
        private String name;
        private CallArgument[] arguments;
        private VilException lastException;

        CallExpressionTester(String name, CallArgument ... arguments) {
            this.name = name;
            this.arguments = arguments;
        }

        @Override
        public E createAndCheckCall(M model, boolean isSuper, M fromModel) {
            Object result = null;
            try {
                Object tmp = Resolver.this.createCallExpression(model, isSuper, this.name, this.arguments);
                ((ModelCallExpression)tmp).inferType();
                if (!((ModelCallExpression)tmp).isVisible(fromModel)) {
                    this.lastException = new VilException(((ModelCallExpression)tmp).getResolved().getSignature() + " is not visible from " + fromModel.getName(), 30018);
                } else {
                    result = tmp;
                }
            }
            catch (VilException e) {
                this.lastException = e;
            }
            return result;
        }

        @Override
        public VilException getLastException() {
            return this.lastException;
        }
    }
}

