/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Supplier;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IVariable;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.instantiation.core.Bundle;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.common.DummyModel;
import net.ssehub.easy.instantiation.core.model.common.IResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.IResolvable;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.ITypedModel;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilGenericType;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.varModel.model.IvmlDatatypeVisitor;
import net.ssehub.easy.varModel.model.datatypes.DerivedDatatype;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;
import net.ssehub.easy.varModel.model.datatypes.Reference;
import net.ssehub.easy.varModel.model.values.CompoundValue;
import net.ssehub.easy.varModel.model.values.NullValue;

public abstract class RuntimeEnvironment<V extends VariableDeclaration, M extends IModel>
implements IRuntimeEnvironment,
IRestrictionEvaluationContext {
    private Map<IModel, Context<V, M>> contexts = new HashMap<IModel, Context<V, M>>();
    private Context<V, M> currentContext;
    private IResolvableModel<V, M> mostSpecificModel;
    private TypeRegistry typeRegistry;
    private Class<V> cls;
    private Set<IArtifact> noAutoStore = new HashSet<IArtifact>();
    private Supplier<String> modelNameSupplier = new Supplier<String>(){

        @Override
        public String get() {
            String modelName = null;
            if (null != RuntimeEnvironment.this.currentContext && RuntimeEnvironment.this.currentContext.getModel() != null && RuntimeEnvironment.this.contexts.size() > 0) {
                modelName = RuntimeEnvironment.this.currentContext.getModel().getName();
            }
            return modelName;
        }
    };

    public RuntimeEnvironment(Class<V> cls) {
        this.cls = cls;
        this.typeRegistry = TypeRegistry.DEFAULT;
    }

    public RuntimeEnvironment(Class<V> cls, TypeRegistry typeRegistry) {
        this.cls = cls;
        this.typeRegistry = typeRegistry;
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.typeRegistry;
    }

    public IResolvableModel<V, M> switchContext(IResolvableModel<V, M> model) {
        Context<V, M> oldC = this.currentContext;
        IResolvableModel<V, M> oldContext = null != this.currentContext ? this.currentContext.getModel() : null;
        TypeRegistry tmp = model.getTypeRegistry();
        if (null != tmp) {
            this.typeRegistry = tmp;
        }
        this.currentContext = this.contexts.get(model);
        if (null == this.currentContext) {
            this.currentContext = new Context<V, M>(model);
            this.contexts.put(model, this.currentContext);
            if (this.contexts.size() > 1) {
                this.currentContext.increaseIndentation();
            }
        } else if (oldC != null) {
            this.currentContext.setIndentation(oldC.getIndentation());
        }
        if (null != oldContext && this.currentContext.getModel().isAssignableFrom(oldContext)) {
            this.mostSpecificModel = oldContext;
            this.currentContext.setMostSpecificModel(oldContext);
        } else if (null == this.mostSpecificModel || oldContext != this.currentContext.getModel()) {
            this.mostSpecificModel = this.currentContext.getMostSpecificModel();
        }
        return oldContext;
    }

    public void deleteContext(ITypedModel model) {
        Context<V, M> context = this.contexts.get(model);
        if (context != this.currentContext) {
            this.contexts.remove(model);
        }
    }

    public void setContextPaths(List<File> paths) {
        if (null != this.currentContext) {
            String[] tmp = null;
            if (null != paths) {
                tmp = new String[paths.size()];
                for (int i = 0; i < tmp.length; ++i) {
                    tmp[i] = paths.get(i).getAbsolutePath();
                }
            }
            Context.access$702(this.currentContext, tmp);
        }
    }

    @Override
    public String[] getContextPaths() {
        String[] result = null;
        if (null != this.currentContext) {
            result = ((Context)this.currentContext).paths;
        }
        return result;
    }

    public IResolvableModel<?, M> getContextModel() {
        IResolvableModel<V, M> model = null == this.currentContext ? null : this.currentContext.getModel();
        return model;
    }

    public IResolvableModel<?, M> getMostSpecificContextModel() {
        return this.mostSpecificModel;
    }

    @Override
    public Object getValue(IResolvable resolvable) throws VilException {
        Object result;
        block5: {
            result = null;
            try {
                result = this.currentContext.getValue(resolvable);
            }
            catch (VilException e) {
                boolean found = false;
                for (Context<V, M> ctx : this.contexts.values()) {
                    if (ctx == this.currentContext) continue;
                    try {
                        result = ctx.getValue(resolvable);
                        found = true;
                    }
                    catch (VilException vilException) {}
                }
                if (found) break block5;
                throw e;
            }
        }
        return result;
    }

    public Object getValue(IResolvableModel<V, M> contextModel, String name) throws VilException {
        Context<V, M> context = this.contexts.get(contextModel);
        if (null == context) {
            throw new VilException("No such context", 30008);
        }
        V varDecl = context.get(name);
        if (null == varDecl) {
            throw new VilException("variable " + name + " is not defined", 50000);
        }
        return context.getValue((IResolvable)varDecl);
    }

    public Object getValue(V var) throws VilException {
        return this.getValue((IResolvable)var);
    }

    @Override
    public void storeArtifacts(boolean force) throws VilException {
        this.currentContext.storeArtifacts(force);
    }

    public V get(String name) {
        return this.currentContext.get(name);
    }

    public boolean isDefined(V var) {
        return this.currentContext.isDefined(var);
    }

    @Override
    public void setValue(IResolvable var, Object object) throws VilException {
        if (this.cls.isInstance(var)) {
            this.setValue((V)((VariableDeclaration)this.cls.cast(var)), object);
        }
    }

    public void setValue(V var, Object object) throws VilException {
        object = this.checkType(var, object);
        this.currentContext.setValue(var, object);
    }

    private static Object checkInitialCollectionValue(TypeDescriptor<?> type, Object object) {
        if ((type.isSet() || type.isSequence()) && object instanceof Collection) {
            Collection coll = (Collection)object;
            if (coll.isEmpty() && type.getGenericParameterCount() > 0 && !type.isSame(coll.getType())) {
                object = type.isSet() ? new ListSet(new ArrayList(), type.getGenericParameter()) : new ListSequence(new ArrayList(), type.getGenericParameter());
            }
        } else if (type.isMap() && object instanceof Sequence) {
            try {
                object = net.ssehub.easy.instantiation.core.model.vilTypes.Map.convert((Sequence)object);
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        return object;
    }

    public void pushLevel() {
        this.currentContext.pushLevel();
    }

    public void popLevel() throws VilException {
        this.currentContext.popLevel();
    }

    public void addValue(V var, Object object) throws VilException {
        object = this.checkType(var, object);
        this.currentContext.addValue(var, object);
    }

    public void removeValue(V var) {
        this.currentContext.removeValue(var);
    }

    private Object checkType(V var, Object object) throws VilException {
        return RuntimeEnvironment.checkType(((VariableDeclaration)var).getName(), ((VariableDeclaration)var).getType(), object, this.getTypeRegistry(), this.modelNameSupplier);
    }

    public static Object checkType(String name, TypeDescriptor<?> type, Object object, TypeRegistry registry, Supplier<String> modelName) throws VilException {
        object = type instanceof IActualValueProvider ? ((IActualValueProvider)((Object)type)).determineActualValue(object) : RuntimeEnvironment.checkInitialCollectionValue(type, object);
        if (NullValue.INSTANCE == object || NullValue.VALUE == object) {
            object = null;
        }
        if (null != object) {
            boolean compatible = type.isInstance(object);
            if (!compatible) {
                TypeDescriptor<?> td;
                IDatatype dType;
                if (object instanceof DecisionVariable) {
                    DecisionVariable decVar = (DecisionVariable)object;
                    dType = decVar.getActualType();
                    td = registry.getType(dType = DerivedDatatype.resolveToBasis(Reference.dereference(dType)));
                    if (null != td) {
                        compatible = type.isAssignableFrom(td);
                    }
                    if (compatible) {
                        object = RuntimeEnvironment.evaluatePrimitives(object, decVar, type);
                    }
                }
                if (object instanceof CompoundValue) {
                    CompoundValue cValue = (CompoundValue)object;
                    dType = cValue.getType();
                    td = registry.getType(dType = DerivedDatatype.resolveToBasis(Reference.dereference(dType)));
                    if (null != td) {
                        compatible = type.isAssignableFrom(td);
                    }
                }
            }
            if (!compatible) {
                TypeDescriptor<?> oType = registry.findType(object.getClass());
                if (null == oType && object instanceof IVilGenericType) {
                    oType = ((IVilGenericType)object).getType();
                }
                String oTypeName = null == oType ? "?" : oType.getVilName();
                if (object instanceof DecisionVariable) {
                    DecisionVariable decVar = (DecisionVariable)object;
                    IDatatype dType = decVar.getActualType();
                    String typeName = null != dType ? IvmlDatatypeVisitor.getUnqualifiedType(dType) : decVar.getTypeName();
                    oTypeName = oTypeName + " (" + typeName + ")";
                }
                String msg = RuntimeEnvironment.appendModelName("cannot assign value of type \"" + oTypeName + "\" to \"" + name + "\" of type \"" + type.getVilName() + "\"", modelName);
                Bundle.getLogger(RuntimeEnvironment.class).debug(msg);
                throw new VilException(msg, 50008);
            }
        }
        return object;
    }

    private static String appendModelName(String msg, Supplier<String> modelName) {
        String mName;
        if (null != modelName && null != (mName = modelName.get())) {
            msg = msg + " called in '" + mName + "'";
        }
        return msg;
    }

    private static Object evaluatePrimitives(Object object, DecisionVariable decVar, TypeDescriptor<?> varType) {
        if (TypeRegistry.integerType().isSame(varType)) {
            object = decVar.getIntegerValue();
        } else if (TypeRegistry.realType().isSame(varType)) {
            object = decVar.getRealValue();
        } else if (TypeRegistry.booleanType().isSame(varType)) {
            object = decVar.getBooleanValue();
        }
        return object;
    }

    public IndentationConfiguration getIndentationConfiguration() {
        return this.currentContext.getIndentationConfiguration();
    }

    public int getIndentation() {
        return this.currentContext.getIndentation();
    }

    public void setIndentationSteps(int steps) {
        this.currentContext.setIndentationSteps(steps);
    }

    public void setIndentation(int indentation) {
        this.currentContext.setIndentation(indentation);
    }

    public void increaseIndentation() {
        this.currentContext.increaseIndentation();
    }

    public void decreaseIndentation() {
        this.currentContext.decreaseIndentation();
    }

    @Override
    public Object getIvmlValue(String name) throws VilException {
        return this.currentContext.getIvmlValue(name);
    }

    @Override
    public void setValue(IVariable variable, Version version) throws RestrictionEvaluationException {
        if (this.cls.isInstance(variable)) {
            try {
                this.addValue((VariableDeclaration)this.cls.cast(variable), version);
            }
            catch (VilException e) {
                throw new RestrictionEvaluationException(e.getMessage(), e.getId());
            }
        } else {
            throw new RestrictionEvaluationException("unsupported type", 10999);
        }
    }

    @Override
    public void unsetValue(IVariable variable) throws RestrictionEvaluationException {
        if (!this.cls.isInstance(variable)) {
            throw new RestrictionEvaluationException("unsupported type", 10999);
        }
        this.removeValue((VariableDeclaration)this.cls.cast(variable));
    }

    protected abstract IExpressionVisitor createEvaluationProcessor();

    protected abstract void releaseEvaluationProcessor(IExpressionVisitor var1);

    @Override
    public Object startEvaluation() throws RestrictionEvaluationException {
        if (null == this.currentContext) {
            this.switchContext(new DummyModel());
        }
        this.pushLevel();
        return this.createEvaluationProcessor();
    }

    @Override
    public void endEvaluation(Object processor) throws RestrictionEvaluationException {
        if (processor instanceof IExpressionVisitor) {
            this.releaseEvaluationProcessor((IExpressionVisitor)processor);
        }
        try {
            this.popLevel();
        }
        catch (VilException e) {
            throw new RestrictionEvaluationException(e.getMessage(), e.getId());
        }
    }

    public Configuration getTopLevelConfiguration() {
        return this.currentContext.getTopLevelConfiguration();
    }

    public void markNoAutoStore(IArtifact artifact) {
        this.noAutoStore.add(artifact);
    }

    public void unmarkNoAutoStore(IArtifact artifact) {
        this.noAutoStore.remove(artifact);
    }

    private class Context<D extends VariableDeclaration, O extends IModel> {
        private Stack<Level<D>> levels = new Stack();
        private IResolvableModel<D, O> model;
        private IResolvableModel<D, O> specificModel;
        private int indentation;
        private IndentationConfiguration indentationConfiguration;
        private String[] paths;

        public Context(IResolvableModel<D, O> model) {
            this.model = model;
            this.specificModel = model;
            if (null != model.getIndentationConfiguration() && model.getIndentationConfiguration().isIndentationEnabled()) {
                this.indentationConfiguration = model.getIndentationConfiguration();
            }
            this.pushLevel();
        }

        public IResolvableModel<D, O> getModel() {
            return this.model;
        }

        public IResolvableModel<D, O> getMostSpecificModel() {
            return this.specificModel;
        }

        public void setMostSpecificModel(IResolvableModel<D, O> model) {
            this.specificModel = model;
        }

        public Object getValue(IResolvable resolvable) throws VilException {
            boolean found = false;
            Object value = null;
            for (int l = this.levels.size() - 1; !found && l >= 0; --l) {
                Level level = (Level)this.levels.get(l);
                if (!level.values.containsKey(resolvable)) continue;
                found = true;
                value = level.values.get(resolvable);
            }
            if (!found) {
                throw new VilException("variable " + resolvable.getName() + " is not defined", 50000);
            }
            return value;
        }

        public D get(String name) {
            VariableDeclaration result = null;
            for (int l = this.levels.size() - 1; null == result && l >= 0; --l) {
                Level level = (Level)this.levels.get(l);
                result = (VariableDeclaration)level.variables.get(name);
            }
            return (D)result;
        }

        public boolean isDefined(D var) {
            return this.isDefined(var, this.levels.size() - 1);
        }

        private boolean isDefined(D var, int maxIndex) {
            boolean found = false;
            for (int l = maxIndex; !found && l >= 0; --l) {
                Level level = (Level)this.levels.get(l);
                if (!level.values.containsKey(var)) continue;
                found = null != level.values.get(var);
            }
            return found;
        }

        public void setValue(D var, Object object) throws VilException {
            if (((VariableDeclaration)var).isConstant() && this.isDefined(var)) {
                throw new VilException("variable " + ((VariableDeclaration)var).getName() + " is constant", 50002);
            }
            boolean found = false;
            for (int l = this.levels.size() - 1; !found && l >= 0; --l) {
                Level level = (Level)this.levels.get(l);
                if (!level.values.containsKey(var)) continue;
                level.values.put(var, object);
                level.variables.put(((VariableDeclaration)var).getName(), var);
                if (((VariableDeclaration)var).getType() == IvmlTypes.configurationType() && object instanceof Configuration) {
                    level.configurations.add((Configuration)object);
                }
                found = true;
            }
            if (!found) {
                this.addValue(var, object);
            }
        }

        public void pushLevel() {
            this.levels.push(new Level());
        }

        public void popLevel() throws VilException {
            this.storeArtifacts(false);
            if (this.levels.size() <= 1) {
                throw new IllegalArgumentException("lowest level element cannot be removed");
            }
            this.levels.pop();
        }

        public void storeArtifacts(boolean force) throws VilException {
            if (this.levels.size() > 0) {
                Level<D> top = this.levels.peek();
                int maxLevel = this.levels.size() - 2;
                for (Map.Entry ent : ((Level)top).values.entrySet()) {
                    Object o = ent.getValue();
                    if (!(o instanceof IArtifact) || !force && (RuntimeEnvironment.this.noAutoStore.contains(o) || this.isDefined((VariableDeclaration)ent.getKey(), maxLevel))) continue;
                    IArtifact artifact = (IArtifact)o;
                    artifact.store();
                }
            }
        }

        public void addValue(D var, Object object) throws VilException {
            Level<D> level = this.levels.peek();
            ((Level)level).values.put(var, object);
            ((Level)level).variables.put(((VariableDeclaration)var).getName(), var);
            if (((VariableDeclaration)var).getType() == IvmlTypes.configurationType() && object instanceof Configuration) {
                ((Level)level).configurations.add((Configuration)object);
            }
        }

        public void removeValue(D var) {
            Level<D> level = this.levels.peek();
            Object object = ((Level)level).values.get(var);
            ((Level)level).values.remove(var);
            ((Level)level).variables.remove(((VariableDeclaration)var).getName());
            if (((VariableDeclaration)var).getType() == IvmlTypes.configurationType() && object instanceof Configuration) {
                ((Level)level).configurations.remove((Configuration)object);
            }
        }

        public IndentationConfiguration getIndentationConfiguration() {
            return this.indentationConfiguration;
        }

        public int getIndentation() {
            return this.indentation;
        }

        public void setIndentationSteps(int steps) {
            if (steps > 0 && null != this.indentationConfiguration) {
                this.indentation = steps * this.indentationConfiguration.getIndentationStep();
            }
        }

        public void setIndentation(int indentation) {
            if (indentation >= 0) {
                this.indentation = indentation;
            }
        }

        public void increaseIndentation() {
            if (null != this.indentationConfiguration) {
                this.indentation += Math.max(0, this.indentationConfiguration.getIndentationStep());
            }
        }

        public void decreaseIndentation() {
            int step;
            if (null != this.indentationConfiguration && this.indentation > (step = Math.max(0, this.indentationConfiguration.getIndentationStep()))) {
                this.indentation -= step;
            }
        }

        public Object getIvmlValue(String name) throws VilException {
            boolean found = false;
            IvmlElement value = null;
            for (int l = this.levels.size() - 1; !found && l >= 0; --l) {
                Level level = (Level)this.levels.get(l);
                for (int c = 0; !found && c < level.configurations.size(); ++c) {
                    IvmlElement elt = ((Configuration)level.configurations.get(c)).getElement(name);
                    if (null == elt) continue;
                    found = true;
                    value = elt;
                }
            }
            if (!found) {
                throw new VilException("IVML element " + name + " is not defined", 50000);
            }
            return value;
        }

        public Configuration getTopLevelConfiguration() {
            List cfgs;
            Configuration result = null;
            if (!this.levels.isEmpty() && (cfgs = ((Level)this.levels.get(0)).configurations) != null && !cfgs.isEmpty()) {
                result = (Configuration)cfgs.get(0);
            }
            return result;
        }

        static /* synthetic */ String[] access$702(Context x0, String[] x1) {
            x0.paths = x1;
            return x1;
        }
    }

    private static class Level<V extends VariableDeclaration> {
        private Map<V, Object> values = new HashMap<V, Object>();
        private Map<String, V> variables = new HashMap<String, V>();
        private List<Configuration> configurations = new ArrayList<Configuration>();

        private Level() {
        }

        public String toString() {
            return "[" + this.values + " " + this.variables + "]";
        }
    }
}

