/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.io.BufferedReader;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.execution.IInstantiatorTracer;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;

public class StreamGobbler
extends Thread {
    private InputStream is;
    private boolean isErrorStream;
    private IMsgManipulator manipulator;
    private TracerFactory tracers;

    public StreamGobbler(InputStream is, boolean isErrorStream) {
        this(is, isErrorStream, null);
    }

    public StreamGobbler(InputStream is, boolean isErrorStream, IMsgManipulator manipulator) {
        this.is = is;
        this.isErrorStream = isErrorStream;
        this.manipulator = manipulator;
        this.tracers = TracerFactory.getInstance();
    }

    public static void gobble(Process proc) {
        StreamGobbler.gobble(proc, null);
    }

    public static void gobble(Process proc, IMsgManipulator manipulator) {
        StreamGobbler errorGobbler = new StreamGobbler(proc.getErrorStream(), true, manipulator);
        errorGobbler.start();
        StreamGobbler outGobbler = new StreamGobbler(proc.getInputStream(), false, manipulator);
        outGobbler.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        TracerFactory.setInstance(this.tracers);
        IInstantiatorTracer tracer = TracerFactory.createInstantiatorTracer();
        try {
            InputStreamReader isr = new InputStreamReader(this.is);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (null != this.manipulator) {
                    line = this.manipulator.manipulate(line);
                }
                if (null == line) continue;
                if (this.isErrorStream) {
                    tracer.traceError(line);
                    continue;
                }
                tracer.traceMessage(line);
            }
        }
        catch (EOFException isr) {
        }
        catch (IOException ioe) {
            EASyLoggerFactory.INSTANCE.getLogger(StreamGobbler.class, "net.ssehub.easy.instantiation.core").exception(ioe);
        }
        finally {
            TracerFactory.setInstance(null);
        }
    }

    public static interface IMsgManipulator {
        public String manipulate(String var1);
    }
}

