/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.instantiation.core.model.common.IModifier;
import net.ssehub.easy.instantiation.core.model.common.IModifierHolder;
import net.ssehub.easy.instantiation.core.model.common.IVisitor;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaParameterDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public abstract class VariableDeclaration
implements IMetaParameterDeclaration,
IModifierHolder {
    private String name;
    private TypeDescriptor<?> type;
    private boolean isConstant;
    private Expression expression;
    private boolean hasExplicitType;
    private List<IModifier> modifiers;

    public VariableDeclaration(String name, TypeDescriptor<?> type) {
        this(name, type, false, null);
    }

    public VariableDeclaration(String name, TypeDescriptor<?> type, boolean isConstant, Expression expression) {
        this.name = name;
        this.type = type;
        this.isConstant = isConstant;
        this.expression = expression;
        this.hasExplicitType = true;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public TypeDescriptor<?> getType() {
        return this.type;
    }

    public void setIsConstant(boolean isConstant) {
        this.isConstant = isConstant;
    }

    public boolean isConstant() {
        return this.isConstant;
    }

    @Override
    public Expression getExpression() {
        return this.expression;
    }

    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitVariableDeclaration(this);
    }

    public void setHasExplicitType(boolean hasExplicitType) {
        this.hasExplicitType = hasExplicitType;
    }

    public boolean hasExplicitType() {
        return this.hasExplicitType;
    }

    public void addModifier(IModifier modifier) {
        if (null == this.modifiers) {
            this.modifiers = new ArrayList<IModifier>();
        }
        this.modifiers.add(modifier);
    }

    @Override
    public int getModifierCount() {
        return null == this.modifiers ? 0 : this.modifiers.size();
    }

    @Override
    public IModifier getModifier(int index) {
        if (null == this.modifiers) {
            throw new IndexOutOfBoundsException();
        }
        return this.modifiers.get(index);
    }

    @Override
    public boolean hasModifier(IModifier modifier) {
        return null == this.modifiers ? false : this.modifiers.contains(modifier);
    }

    public void resolveOperation(TypeDescriptor<?> type, IMetaOperation operation) {
        this.expression = new ResolvableOperationExpression(type, operation);
    }

    public String toString() {
        return this.type.toString() + " " + this.name;
    }

    public boolean isImplicit() {
        return false;
    }

    public static <V extends VariableDeclaration> Map<String, V> mapDefaultedParameters(Map<String, V> result, V[] decls) {
        if (null != decls) {
            for (int d = 0; d < decls.length; ++d) {
                V decl = decls[d];
                if (null == ((VariableDeclaration)decl).getExpression()) continue;
                if (null == result) {
                    result = new HashMap<String, V>();
                }
                result.put(((VariableDeclaration)decl).getName(), decl);
            }
        }
        return result;
    }

    public static <V extends VariableDeclaration> int getRequiredParameterCount(Map<String, V> named, V[] decls) {
        int result = 0;
        if (null != decls) {
            result = null == named ? decls.length : decls.length - named.size();
        }
        return result;
    }

    public static <V extends VariableDeclaration> V getParameter(Map<String, V> named, String name, V[] params) {
        VariableDeclaration result = null;
        if (null != name) {
            if (null != named) {
                result = (VariableDeclaration)named.get(name);
            }
            if (null == result && null != params) {
                for (int p = 0; null == result && p < params.length; ++p) {
                    if (!((VariableDeclaration)params[p]).getName().equals(name)) continue;
                    result = params[p];
                }
            }
        }
        return (V)result;
    }
}

