/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.common;

import java.io.Writer;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.instantiation.core.model.common.AbstractResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.Advice;
import net.ssehub.easy.instantiation.core.model.common.Compound;
import net.ssehub.easy.instantiation.core.model.common.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.common.IModifierHolder;
import net.ssehub.easy.instantiation.core.model.common.IParameterizable;
import net.ssehub.easy.instantiation.core.model.common.IVisitor;
import net.ssehub.easy.instantiation.core.model.common.Typedef;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionWriter;
import net.ssehub.easy.instantiation.core.model.vilTypes.CompoundTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaParameterDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public class WriterVisitor<V extends VariableDeclaration>
extends ExpressionWriter
implements IVisitor {
    private boolean printExpressionStatementIndentation = true;
    private boolean printExpressionStatementNewLine = true;

    public WriterVisitor(Writer out) {
        super(out);
    }

    protected boolean isPrintExpressionStatementIndentation() {
        return this.printExpressionStatementIndentation;
    }

    protected void setPrintExpressionStatementIndentation(boolean printExpressionStatementIndentation) {
        this.printExpressionStatementIndentation = printExpressionStatementIndentation;
    }

    protected boolean isPrintExpressionStatementNewLine() {
        return this.printExpressionStatementNewLine;
    }

    protected void setPrintExpressionStatementNewLine(boolean printExpressionStatementNewLine) {
        this.printExpressionStatementNewLine = printExpressionStatementNewLine;
    }

    protected void printModifiers(IModifierHolder holder) {
    }

    @Override
    public Object visitVariableDeclaration(VariableDeclaration var) throws VilException {
        this.printIndentation();
        this.printModifiers(var);
        if (var.isConstant()) {
            this.print("const ");
        }
        this.printType(var.getType());
        this.printWhitespace();
        this.print(var.getName());
        if (null != var.getExpression()) {
            this.printWhitespace();
            this.print('=');
            this.printWhitespace();
            var.getExpression().accept(this);
        }
        this.println(";");
        return null;
    }

    @Override
    public Object visitAdvice(Advice advice) throws VilException {
        this.printIndentation();
        this.print("@advice(");
        this.print(advice.getName());
        this.printVersionRestrictions(advice.getVersionRestriction(), false);
        this.println(")");
        return null;
    }

    protected void printVersionRestrictions(IVersionRestriction restriction, boolean capitalize) {
        if (null != restriction) {
            String with = " with ";
            if (capitalize) {
                with = with.toUpperCase();
            }
            this.print(with);
            this.print(restriction.toSpecification());
        }
    }

    protected void printParameterList(IParameterizable<V> parameterizable) throws VilException {
        this.print('(');
        for (int p = 0; p < parameterizable.getParameterCount(); ++p) {
            if (p > 0) {
                this.print(",");
                this.printWhitespace();
            }
            VariableDeclaration param = (VariableDeclaration)parameterizable.getParameter(p);
            this.printType(param.getType());
            this.printWhitespace();
            this.print(param.getName());
            if (null == param.getExpression()) continue;
            this.print("=");
            param.getExpression().accept(this);
        }
        this.print(')');
    }

    @Override
    public Object visitExpressionStatement(ExpressionStatement statement) throws VilException {
        if (this.printExpressionStatementIndentation) {
            this.printIndentation();
        }
        statement.getExpression().accept(this);
        if (this.endsWithSemicolon(statement)) {
            this.print(";");
            if (this.printExpressionStatementNewLine) {
                this.println();
            }
        }
        return null;
    }

    protected boolean endsWithSemicolon(ExpressionStatement statement) {
        return true;
    }

    protected void printVersion(Version ver) {
        if (null != ver) {
            this.print("version v");
            this.print(ver.toString());
            this.println(";");
        }
    }

    protected void printImportLeadin(ModelImport<?> imp) {
        if (imp.isInsert()) {
            this.print("insert");
        } else {
            this.print("import");
        }
        this.print(" ");
        this.print(imp.getName());
    }

    protected static final int o2i(Object object) {
        return null == object ? 0 : 1;
    }

    @Override
    public Object visitTypedef(Typedef typedef) throws VilException {
        this.printIndentation();
        this.print("typedef");
        this.printWhitespace();
        this.print(typedef.getName());
        this.printWhitespace();
        this.print(typedef.getType().getVilName());
        this.println(";");
        return null;
    }

    protected <R extends IMetaParameterDeclaration, M extends IModel> void printTypedefs(AbstractResolvableModel<R, M> model) throws VilException {
        for (int t = 0; t < model.getTypedefCount(); ++t) {
            model.getTypedef(t).accept(this);
        }
    }

    protected <R extends IMetaParameterDeclaration, M extends IModel> void printCompounds(AbstractResolvableModel<R, M> model) throws VilException {
        for (int c = 0; c < model.getCompoundCount(); ++c) {
            model.getCompound(c).accept(this);
        }
    }

    @Override
    public Object visitCompound(Compound compound) throws VilException {
        this.printIndentation();
        if (compound.isAbstract()) {
            this.print("abstract ");
        }
        this.print("compound ");
        this.print(compound.getName());
        if (null != compound.getRefines()) {
            this.print(" refines ");
            this.print(compound.getRefines().getName());
        }
        this.println(" {");
        this.increaseIndentation();
        for (int s = 0; s < compound.getSlotsCount(); ++s) {
            CompoundTypeDescriptor.SlotDescriptor slot = compound.getSlot(s);
            this.printIndentation();
            this.printModifiers(slot);
            if (slot.isConstant()) {
                this.print("const ");
            }
            this.printType((TypeDescriptor<?>)slot.getType());
            this.printWhitespace();
            this.print(slot.getName());
            if (null != slot.getExpression()) {
                this.printWhitespace();
                this.print('=');
                this.printWhitespace();
                slot.getExpression().accept(this);
            }
            this.println(";");
        }
        this.decreaseIndentation();
        this.printIndentation();
        this.println("}");
        return null;
    }
}

