/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.defaultInstantiators;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.instantiation.core.Bundle;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.artifactModel.VtlFileArtifact;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.common.ITerminatable;
import net.ssehub.easy.instantiation.core.model.common.ITerminator;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.TracerFactory;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionParserRegistry;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionParser;
import net.ssehub.easy.instantiation.core.model.expressions.StringReplacer;
import net.ssehub.easy.instantiation.core.model.templateModel.ITracer;
import net.ssehub.easy.instantiation.core.model.templateModel.Resolver;
import net.ssehub.easy.instantiation.core.model.templateModel.StringReplacerFactory;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateLangExecution;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateSubstitutionExecution;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import org.apache.commons.io.FileUtils;

@Instantiator(value="vilTemplateProcessor", acceptsImplicitParameters=true)
public class VilTemplateProcessor
implements IVilType {
    public static final String PARAM_CONFIG = "config";
    public static final String PARAM_TARGET = "target";

    @OperationMeta(returnGenerics={IArtifact.class}, requiresDynamicExpressionProcessing=true)
    public static Set<IArtifact> vilTemplateProcessor(FileArtifact template, Configuration config, Collection<IArtifact> targets, Map<String, Object> other) throws VilException {
        return VilTemplateProcessor.vilTemplateProcessor(template, config, targets, false, other);
    }

    @OperationMeta(returnGenerics={IArtifact.class}, requiresDynamicExpressionProcessing=true)
    public static Set<IArtifact> vilTemplateProcessor(FileArtifact template, Configuration config, Collection<IArtifact> targets, boolean addAdvice, Map<String, Object> other) throws VilException {
        ArrayList<IArtifact> result = new ArrayList<IArtifact>();
        for (IArtifact target : targets) {
            VilTemplateProcessor.process(template, config, target, other, result, addAdvice);
        }
        return new ListSet<IArtifact>(result, IArtifact.class);
    }

    @OperationMeta(returnGenerics={IArtifact.class}, requiresDynamicExpressionProcessing=true)
    public static Set<IArtifact> vilTemplateProcessor(FileArtifact template, Configuration config, IArtifact target, Map<String, Object> other) throws VilException {
        return VilTemplateProcessor.vilTemplateProcessor(template, config, target, false, other);
    }

    @OperationMeta(returnGenerics={IArtifact.class}, requiresDynamicExpressionProcessing=true)
    public static Set<IArtifact> vilTemplateProcessor(FileArtifact template, Configuration config, IArtifact target, boolean addAdvice, Map<String, Object> other) throws VilException {
        ArrayList<IArtifact> result = new ArrayList<IArtifact>();
        VilTemplateProcessor.process(template, config, target, other, result, addAdvice);
        return new ListSet<IArtifact>(result, IArtifact.class);
    }

    private static void process(FileArtifact template, Configuration config, IArtifact target, Map<String, Object> other, List<IArtifact> result, boolean addAdvice) throws VilException {
        String templateContents;
        IExpressionParser<Resolver> expressionParser = ExpressionParserRegistry.getExpressionParser(TemplateLangExecution.LANGUAGE);
        if (null == expressionParser) {
            throw new VilException("no expression parser registered", 70000);
        }
        File inAbsFile = template.getPath().getAbsolutePath();
        URI baseURI = inAbsFile.toURI();
        try {
            templateContents = FileUtils.readFileToString((File)inAbsFile, (Charset)Charset.defaultCharset());
        }
        catch (IOException e) {
            throw new VilException(e.getMessage(), 50001);
        }
        ITracer tracer = TracerFactory.createTemplateLanguageTracer();
        TracerFactory.registerTemplateLanguageTracer(tracer);
        String instantiatedContent = "";
        try {
            TemplateSubstitutionExecution evaluationVisitor = new TemplateSubstitutionExecution(tracer, template.getName(), addAdvice, config, baseURI);
            Resolver resolver = new Resolver(evaluationVisitor.getRuntimeEnvironment());
            instantiatedContent = StringReplacer.substitute(templateContents, resolver, expressionParser, evaluationVisitor, StringReplacerFactory.INSTANCE);
            evaluationVisitor.release(false);
        }
        catch (VilException e) {
            throw e;
        }
        finally {
            TracerFactory.unregisterTemplateLanguageTracer(tracer);
        }
        StringWriter out = new StringWriter();
        out.append(instantiatedContent);
        out.flush();
        String tmp = out.toString();
        if (tmp.length() > 0) {
            target.getText().setText(tmp);
            target.store();
        }
        result.add(target);
    }

    @OperationMeta(returnGenerics={IArtifact.class})
    public static Set<IArtifact> vilTemplateProcessor(VtlFileArtifact template, Configuration config, Collection<IArtifact> targets, Map<String, Object> other) throws VilException {
        ArrayList<IArtifact> result = new ArrayList<IArtifact>();
        for (IArtifact target : targets) {
            VilTemplateProcessor.process(template, config, target, other, result);
        }
        return new ListSet<IArtifact>(result, IArtifact.class);
    }

    @OperationMeta(returnGenerics={IArtifact.class})
    public static Set<IArtifact> vilTemplateProcessor(VtlFileArtifact template, Configuration config, IArtifact target, Map<String, Object> other) throws VilException {
        ArrayList<IArtifact> result = new ArrayList<IArtifact>();
        VilTemplateProcessor.process(template, config, target, other, result);
        return new ListSet<IArtifact>(result, IArtifact.class);
    }

    @OperationMeta(returnGenerics={IArtifact.class})
    private static void process(VtlFileArtifact template, Configuration config, IArtifact target, Map<String, Object> other, List<IArtifact> result) throws VilException {
        Path path = template.getPath();
        if (path.isPattern()) {
            throw new VilException("template '" + path.getPath() + "' is a pattern and cannot be instantiated", 50001);
        }
        File absPath = template.getPath().getAbsolutePath();
        if (!path.exists()) {
            throw new VilException("template '" + path.getPath() + "' (" + absPath + ") does not exist", 50001);
        }
        URI uri = template.getPath().getAbsolutePath().toURI();
        ModelInfo info = TemplateModel.INSTANCE.availableModels().getInfo(uri);
        if (null == info) {
            throw new VilException("template '" + path.getPath() + "' does not contain a valid template model", 50001);
        }
        try {
            Template model = (Template)TemplateModel.INSTANCE.load(info);
            VilTemplateProcessor.process(model, config, target, other, result);
        }
        catch (ModelManagementException e) {
            throw new VilException(e.getMessage(), 50001);
        }
    }

    private static ModelImport<Template> getVtlRestrictions(String templateName, Map<String, Object> other) {
        Object parent;
        ModelImport<Template> result = null;
        if (null != other && (parent = other.get("$parent")) instanceof Script) {
            Script script = (Script)parent;
            for (int r = 0; null == result && r < script.getVtlRestrictionsCount(); ++r) {
                ModelImport<Template> restriction = script.getVtlRestriction(r);
                if (!restriction.getName().equals(templateName)) continue;
                result = restriction;
            }
        }
        return result;
    }

    private static String[] getVtlPaths(Map<String, Object> other) {
        String[] result = null;
        Object tmp = other.get("$paths");
        if (tmp instanceof String[]) {
            result = (String[])tmp;
        }
        return result;
    }

    private static Script getParent(Map<String, Object> other) {
        Script result = null;
        Object tmp = other.get("$parent");
        if (tmp instanceof Script) {
            result = (Script)tmp;
        }
        return result;
    }

    @OperationMeta(returnGenerics={IArtifact.class})
    public static Set<IArtifact> vilTemplateProcessor(String templateName, Configuration config, Collection<IArtifact> targets, Map<String, Object> other) throws VilException {
        return VilTemplateProcessor.vilTemplateProcessor(templateName, config, targets, false, other);
    }

    @OperationMeta(returnGenerics={IArtifact.class})
    public static Set<IArtifact> vilTemplateProcessor(String templateName, Configuration config, Collection<IArtifact> targets, boolean addAdvice, Map<String, Object> other) throws VilException {
        Set<IArtifact> result = null;
        try {
            Path path = Path.convert(templateName);
            FileArtifact art = ArtifactFactory.createArtifact(FileArtifact.class, path.getAbsolutePath(), path.getArtifactModel());
            result = art instanceof VtlFileArtifact ? VilTemplateProcessor.vilTemplateProcessor((VtlFileArtifact)art, config, targets, other) : VilTemplateProcessor.vilTemplateProcessor(art, config, targets, addAdvice, other);
        }
        catch (VilException path) {
            // empty catch block
        }
        if (null == result) {
            ArrayList<IArtifact> tmp = new ArrayList<IArtifact>();
            Template template = VilTemplateProcessor.obtainTemplate(templateName, VilTemplateProcessor.getVtlRestrictions(templateName, other), VilTemplateProcessor.getVtlPaths(other), config.getRootScript());
            for (IArtifact target : targets) {
                VilTemplateProcessor.process(template, config, target, other, tmp);
            }
            result = new ListSet(tmp, IArtifact.class);
        }
        return result;
    }

    @OperationMeta(returnGenerics={IArtifact.class})
    public static Set<IArtifact> vilTemplateProcessor(String templateName, Configuration config, IArtifact target, Map<String, Object> other) throws VilException {
        return VilTemplateProcessor.vilTemplateProcessor(templateName, config, target, false, other);
    }

    @OperationMeta(returnGenerics={IArtifact.class})
    public static Set<IArtifact> vilTemplateProcessor(String templateName, Configuration config, IArtifact target, boolean addAdvice, Map<String, Object> other) throws VilException {
        Set<IArtifact> result = null;
        try {
            Path path = Path.convert(templateName);
            FileArtifact art = ArtifactFactory.createArtifact(FileArtifact.class, path.getAbsolutePath(), path.getArtifactModel());
            result = art instanceof VtlFileArtifact ? VilTemplateProcessor.vilTemplateProcessor((VtlFileArtifact)art, config, target, other) : VilTemplateProcessor.vilTemplateProcessor(art, config, target, addAdvice, other);
        }
        catch (VilException path) {
            // empty catch block
        }
        if (null == result) {
            ArrayList<IArtifact> tmp = new ArrayList<IArtifact>();
            Script caller = config.getRootScript();
            if (null == caller) {
                caller = VilTemplateProcessor.getParent(other);
            }
            String[] possiblePaths = VilTemplateProcessor.getVtlPaths(other);
            Template template = VilTemplateProcessor.obtainTemplate(templateName, VilTemplateProcessor.getVtlRestrictions(templateName, other), possiblePaths, caller);
            if (null != template) {
                VilTemplateProcessor.process(template, config, target, other, tmp);
                result = new ListSet<IArtifact>(tmp, IArtifact.class);
            } else {
                VilTemplateProcessor.throwMissingTemplateError(templateName, possiblePaths);
            }
        }
        return result;
    }

    private static void throwMissingTemplateError(String templateName, String[] possiblePaths) throws VilException {
        StringBuffer errMsg = new StringBuffer("The script \"");
        errMsg.append(templateName);
        errMsg.append("\" could not be loaded, maybe the file contains syntax errors or is not named as \"");
        errMsg.append(templateName);
        errMsg.append("\".");
        if (null != possiblePaths && possiblePaths.length > 0) {
            errMsg.append("\nPlease check whether one of the following paths contains a valid template file:\n");
            errMsg.append(" - ");
            errMsg.append(possiblePaths[0]);
            for (int i = 1; i < possiblePaths.length; ++i) {
                errMsg.append("\n - ");
                errMsg.append(possiblePaths[i]);
            }
            errMsg.append("\n");
            throw new VilException(errMsg.toString(), 50000);
        }
    }

    private static void pruneByPaths(List<ModelInfo<Template>> info, String[] vtlPaths) {
        if (null != info && null != vtlPaths) {
            for (int i = info.size() - 1; i >= 0; --i) {
                ModelInfo<Template> tmp = info.get(i);
                String location = new File(tmp.getLocation()).getAbsolutePath();
                boolean found = false;
                for (int p = 0; !found && p < vtlPaths.length; ++p) {
                    found = location.startsWith(vtlPaths[p]);
                }
                if (found) continue;
                info.remove(i);
            }
        }
    }

    private static Template obtainTemplate(String templateName, ModelImport<Template> restrictions, String[] vtlPaths, Script caller) throws VilException {
        Template model = null;
        try {
            IRestrictionEvaluationContext context;
            Template tpl = null;
            URI baseURI = null;
            if (null != caller) {
                ModelInfo<Script> cInfo = BuildModel.INSTANCE.availableModels().getModelInfo(caller);
                baseURI = cInfo.getLocation();
                context = caller.getRestrictionEvaluationContext();
            } else {
                List<ModelInfo<Template>> infos = TemplateModel.INSTANCE.availableModels().getModelInfo(templateName, (Version)null);
                VilTemplateProcessor.pruneByPaths(infos, vtlPaths);
                if (null == infos || infos.isEmpty()) {
                    throw new VilException(templateName + " cannot be found", 50001);
                }
                if (infos.size() > 1) {
                    throw new VilException(templateName + " is ambigous (" + infos.size() + " models found)", 50001);
                }
                ModelInfo<Template> info = infos.get(0);
                baseURI = info.getLocation();
                tpl = info.getResolved();
                if (null == tpl) {
                    tpl = TemplateModel.INSTANCE.load(info);
                }
                context = tpl.getRestrictionEvaluationContext();
            }
            IVersionRestriction restriction = null != restrictions ? restrictions.getVersionRestriction() : null;
            model = (Template)TemplateModel.INSTANCE.resolve(templateName, restriction, baseURI, context);
            if (null == model) {
                model = tpl;
            }
            if (null == model) {
                throw new VilException("Cannot find VIL template " + templateName + " with resolution URI " + baseURI, 50000);
            }
            if (model.isDirty()) {
                Template old = model;
                model = TemplateModel.INSTANCE.reload(model);
                EASyLoggerFactory.INSTANCE.getLogger(VilTemplateProcessor.class, "net.ssehub.easy.instantiation.core").info("Reloading model " + model.getName() + " " + System.identityHashCode(model) + " as it was marked dirty: " + (old != model));
            }
        }
        catch (ModelManagementException e) {
            throw new VilException(e.getMessage(), e.getId());
        }
        catch (RuntimeException e) {
            throw new VilException(e, 30012);
        }
        return model;
    }

    @OperationMeta(returnGenerics={IArtifact.class})
    private static void process(Template template, Configuration config, IArtifact target, Map<String, Object> other, List<IArtifact> result) throws VilException {
        ITerminator terminator = null;
        TemplateLangExecution exec = null;
        StringWriter out = new StringWriter();
        ITracer tracer = TracerFactory.createTemplateLanguageTracer();
        try {
            Object tmp;
            HashMap<String, Object> localParam = new HashMap<String, Object>();
            localParam.put(PARAM_CONFIG, config);
            localParam.put(PARAM_TARGET, target);
            localParam.putAll(other);
            localParam.put("$$config", config);
            localParam.put("$$target", target);
            TracerFactory.registerTemplateLanguageTracer(tracer);
            exec = new TemplateLangExecution(tracer, out, localParam);
            if (null != other && (tmp = other.get("$terminator")) instanceof ITerminator) {
                terminator = (ITerminator)tmp;
                terminator.register(exec);
            }
            template.accept(exec);
            TemplateLangExecution.storeContent(target, out);
            exec.release(false);
        }
        catch (VilException e) {
            VilTemplateProcessor.unregisterTerminatable(terminator, exec);
            StringBuffer errMsg = new StringBuffer(e.getMessage());
            errMsg.append(" in template \"");
            errMsg.append(template.getName());
            errMsg.append("\".");
            e = new VilException(errMsg.toString(), 30010);
            errMsg.append("\nWritten so far:\n");
            errMsg.append(out.toString());
            Bundle.getLogger(VilTemplateProcessor.class).error(errMsg.toString());
            throw e;
        }
        finally {
            TracerFactory.unregisterTemplateLanguageTracer(tracer);
        }
        result.add(target);
    }

    private static void unregisterTerminatable(ITerminator terminator, ITerminatable terminatable) {
        if (null != terminator && null != terminatable) {
            terminator.unregister(terminatable);
        }
    }
}

