/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.defaultInstantiators;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactFactory;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactModel;
import net.ssehub.easy.instantiation.core.model.artifactModel.FileArtifact;
import net.ssehub.easy.instantiation.core.model.artifactModel.Path;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.defaultInstantiators.ZipHandler;
import net.ssehub.easy.instantiation.core.model.vilTypes.ArraySet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Instantiator;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;

@Instantiator(value="zip")
public class Zip
implements IVilType {
    @OperationMeta(returnGenerics={FileArtifact.class})
    public static Set<FileArtifact> zip(Path base, Path artifacts, Path zip) throws VilException {
        return Zip.add(base, artifacts.selectAll(), zip, new ZipHandler());
    }

    @OperationMeta(returnGenerics={FileArtifact.class})
    public static Set<FileArtifact> zip(Path base, Collection<FileArtifact> artifacts, Path zip) throws VilException {
        return Zip.add(base, artifacts, zip, new ZipHandler());
    }

    @Invisible
    public static Set<FileArtifact> add(Path base, Collection<FileArtifact> artifacts, Path target, ZipHandler handler) throws VilException {
        List<File> zipResult;
        List<File> files = Zip.toFileList(artifacts);
        try {
            zipResult = handler.add(base.getAbsolutePath(), files, target.getAbsolutePath());
        }
        catch (IOException e) {
            throw new VilException(e, 50001);
        }
        return Zip.toFileArtifactSet(zipResult, target.getArtifactModel());
    }

    @Invisible
    public static final List<File> toFileList(Collection<FileArtifact> artifacts) {
        ArrayList<File> files = new ArrayList<File>();
        for (FileArtifact artifact : artifacts) {
            files.add(artifact.getPath().getAbsolutePath());
        }
        return files;
    }

    @Invisible
    public static final Set<FileArtifact> toFileArtifactSet(List<File> files, ArtifactModel model) throws VilException {
        FileArtifact[] result = new FileArtifact[files.size()];
        for (int f = 0; f < files.size(); ++f) {
            File file = files.get(f);
            if (file.isDirectory()) continue;
            result[f] = ArtifactFactory.createArtifact(FileArtifact.class, file, model);
        }
        return new ArraySet<FileArtifact>(result, FileArtifact.class);
    }
}

