/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.defaultInstantiators;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.tools.ant.types.selectors.SelectorUtils;

public class ZipHandler {
    public List<File> add(File base, List<File> files, File zip) throws IOException {
        File tmp = null;
        if (zip.exists()) {
            tmp = this.unpack(zip, null, null, null);
        } else {
            zip.getParentFile().mkdirs();
        }
        ZipOutputStream zos = null;
        try {
            String basePath;
            zos = this.createOutputStream(new FileOutputStream(zip));
            if (null != base) {
                basePath = FilenameUtils.normalize((String)base.getAbsolutePath());
                if (!basePath.endsWith(File.separator)) {
                    basePath = basePath + File.separator;
                }
            } else {
                basePath = null;
            }
            HashSet<String> done = new HashSet<String>();
            for (File file : files) {
                String filePath = this.makeRelative(basePath, file);
                ZipEntry entry = this.createEntry(filePath, file);
                zos.putNextEntry(entry);
                FileInputStream in = null;
                try {
                    in = new FileInputStream(file);
                    IOUtils.copy((InputStream)in, (OutputStream)zos);
                    in.close();
                }
                catch (IOException e1) {
                    IOUtils.closeQuietly(in);
                    throw e1;
                }
                zos.closeEntry();
                done.add(filePath);
            }
            if (null != tmp) {
                this.packInto(tmp.getAbsolutePath(), tmp, zos, done);
                FileUtils.deleteQuietly((File)tmp);
            }
            zos.close();
        }
        catch (IOException e) {
            IOUtils.closeQuietly(zos);
            throw e;
        }
        ArrayList<File> result = new ArrayList<File>();
        result.add(zip);
        return result;
    }

    private String makeRelative(String basePath, File file) {
        String filePath = FilenameUtils.normalize((String)file.getAbsolutePath());
        if (null != basePath && filePath.startsWith(basePath) && filePath.length() > basePath.length()) {
            filePath = filePath.substring(basePath.length());
        }
        return filePath;
    }

    protected ZipInputStream createInputStream(InputStream in) throws IOException {
        return new ZipInputStream(in);
    }

    protected ZipOutputStream createOutputStream(OutputStream out) throws IOException {
        return new ZipOutputStream(out);
    }

    protected ZipEntry createEntry(String name, File file) {
        return new ZipEntry(name);
    }

    public File unpack(File zip, File target, String pattern, List<File> files) throws IOException {
        if (zip.exists()) {
            if (null == target) {
                target = File.createTempFile("easy", "jar");
                target.delete();
                target.mkdirs();
            }
            FileInputStream fis = null;
            try {
                fis = new FileInputStream(zip);
                ZipInputStream zis = this.createInputStream(fis);
                ZipEntry entry = zis.getNextEntry();
                while (null != entry) {
                    if (!entry.isDirectory() && ZipHandler.matches(entry, pattern)) {
                        FileOutputStream fos = null;
                        try {
                            File out = new File(target, entry.getName());
                            out.getParentFile().mkdirs();
                            fos = new FileOutputStream(out);
                            IOUtils.copy((InputStream)zis, (OutputStream)fos);
                            fos.close();
                            if (null != files) {
                                files.add(out);
                            }
                        }
                        catch (IOException e1) {
                            IOUtils.closeQuietly(fos);
                            throw e1;
                        }
                    }
                    entry = zis.getNextEntry();
                }
                this.additionalUnpacking(zis, target, files);
                fis.close();
            }
            catch (IOException e) {
                IOUtils.closeQuietly(fis);
                throw e;
            }
        }
        return target;
    }

    private static boolean matches(ZipEntry entry, String pattern) {
        boolean matches = false;
        if (pattern == null) {
            matches = true;
        } else if (entry != null && pattern.length() > 0) {
            matches = SelectorUtils.matchPath((String)pattern, (String)entry.getName());
        }
        return matches;
    }

    protected void additionalUnpacking(ZipInputStream zis, File target, List<File> files) throws IOException {
    }

    private void packInto(String basePath, File source, ZipOutputStream out, Set<String> done) throws IOException {
        if (source.isDirectory()) {
            File[] files = source.listFiles();
            if (null != files) {
                for (File f : files) {
                    this.packInto(basePath, f, out, done);
                }
            }
        } else if (this.include(source)) {
            String sourcePath = this.makeRelative(basePath, source);
            while (sourcePath.startsWith("/") || sourcePath.startsWith("\\")) {
                sourcePath = sourcePath.substring(1);
            }
            if (!done.contains(sourcePath)) {
                ZipEntry entry = this.createEntry(sourcePath, source);
                out.putNextEntry(entry);
                FileInputStream fis = null;
                try {
                    fis = new FileInputStream(source);
                    IOUtils.copy((InputStream)fis, (OutputStream)out);
                    fis.close();
                }
                catch (IOException e) {
                    IOUtils.closeQuietly(fis);
                    throw e;
                }
                out.closeEntry();
                done.add(sourcePath);
            }
        }
    }

    protected boolean include(File file) {
        return true;
    }
}

