/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.basics.modelManagement.IModel;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.FieldAccessExpression;
import net.ssehub.easy.instantiation.core.model.expressions.IArgumentProvider;
import net.ssehub.easy.instantiation.core.model.expressions.ResolutionListener;
import net.ssehub.easy.instantiation.core.model.expressions.VarModelIdentifierExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.IActualTypeProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaParameterDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.ITypedModel;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionTypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.varModel.model.datatypes.IDatatype;

public abstract class AbstractCallExpression
extends Expression
implements IArgumentProvider {
    private static final ResolutionListener RESLIST = new ResolutionListener(){

        @Override
        public void resolved(VarModelIdentifierExpression ex) {
            ex.markAsResolved();
        }
    };
    private String name;
    private String prefix;

    protected AbstractCallExpression() {
    }

    protected AbstractCallExpression(String name, boolean unqualify) throws VilException {
        int pos;
        this.name = name;
        if (unqualify && null != name && (pos = name.lastIndexOf("::")) > 0) {
            this.prefix = name.substring(0, pos);
            this.name = name.substring(pos + 2, name.length());
            if (0 == this.name.length()) {
                throw new VilException("illegal qualified name " + name, 70000);
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public String getQualifiedName() {
        String result = null == this.prefix ? this.name : this.prefix + "::" + this.name;
        return result;
    }

    protected static IMetaType getParameterType(IMetaOperation operation, int index, CallArgument[] arguments, int unnamedArgsCount) {
        IMetaParameterDeclaration pDecl;
        IMetaType result = index < unnamedArgsCount ? operation.getParameterType(index) : (index < arguments.length ? (null != (pDecl = operation.getParameter(arguments[index].getName())) ? pDecl.getType() : null) : operation.getParameterType(index));
        return result;
    }

    private static void candidatesOnImports(ITypedModel model, String name, int unnamedArgsCount, List<IMetaOperation> candidates, boolean inInsert) {
        for (int i = 0; i < model.getImportsCount(); ++i) {
            ModelImport<?> imp = model.getImport(i);
            if (!(imp.getResolved() instanceof ITypedModel)) continue;
            ITypedModel res = (ITypedModel)imp.getResolved();
            if (imp.isWildcard() && imp.isInsert()) {
                AbstractCallExpression.candidatesOnImports(res, name, unnamedArgsCount, candidates, true);
                continue;
            }
            if (!inInsert) continue;
            candidates.addAll(res.getCandidates(name, unnamedArgsCount));
        }
    }

    private static List<IMetaOperation> assignableCandidates(IMetaType operand, String name, CallArgument[] arguments, int unnamedArgsCount, boolean allowAny) throws VilException {
        ArrayList<IMetaOperation> result = new ArrayList<IMetaOperation>();
        IMetaType[] argumentTypes = AbstractCallExpression.toTypeDescriptors(arguments);
        List<IMetaOperation> candidates = operand.getCandidates(name, unnamedArgsCount);
        if (operand instanceof ITypedModel) {
            AbstractCallExpression.candidatesOnImports((ITypedModel)operand, name, unnamedArgsCount, candidates, false);
        }
        for (int o = 0; o < candidates.size(); ++o) {
            IMetaOperation desc = candidates.get(o);
            boolean allEqual = true;
            for (int p = 0; allEqual && p < arguments.length; ++p) {
                IMetaOperation funcOp;
                IMetaType aType;
                IMetaType pType = AbstractCallExpression.getParameterType(desc, p, arguments, unnamedArgsCount);
                if (null == pType || (allEqual &= TypeRegistry.equals(pType, aType = argumentTypes[p])) || null == (funcOp = AbstractCallExpression.resolveResolvableOperation(null, pType, aType, arguments[p].getExpression(), RESLIST))) continue;
                arguments[p].resolveOperation((TypeDescriptor)pType, funcOp);
                allEqual = true;
            }
            if (!allEqual) continue;
            result.add(desc);
        }
        if (result.isEmpty()) {
            int minAssignables = 0;
            for (int o = 0; o < candidates.size(); ++o) {
                IMetaOperation desc = candidates.get(o);
                boolean allAssignable = true;
                int aCount = 0;
                TypeDescriptor<?> any = TypeRegistry.anyType();
                for (int p = 0; allAssignable && p < arguments.length; ++p) {
                    IMetaType pType = AbstractCallExpression.getParameterType(desc, p, arguments, unnamedArgsCount);
                    IMetaType aType = argumentTypes[p];
                    if (null == pType) continue;
                    if (pType.isAssignableFrom(aType) || allowAny && any == pType) {
                        aCount += pType != aType ? 1 : 0;
                        continue;
                    }
                    allAssignable = false;
                }
                if (!allAssignable) continue;
                if (0 == minAssignables || aCount < minAssignables) {
                    result.clear();
                    minAssignables = aCount;
                }
                if (aCount != minAssignables) continue;
                AbstractCallExpression.addAndPruneByType(result, desc, argumentTypes, arguments, unnamedArgsCount);
            }
        }
        if (result.size() > 1) {
            throw new VilException(AbstractCallExpression.toSignatures(result) + " are ambiguous", 70003);
        }
        return result;
    }

    private static String toSignatures(Iterable<IMetaOperation> operations) {
        StringBuilder tmp = new StringBuilder();
        for (IMetaOperation op : operations) {
            if (tmp.length() > 0) {
                tmp.append(",");
            }
            tmp.append(op.getSignature());
        }
        return tmp.toString();
    }

    public static IMetaOperation resolveResolvableOperation(IMetaType operand, IMetaType pType, IMetaType aType, Expression initExpression, ResolutionListener listener) throws VilException {
        IMetaOperation result = null;
        if (initExpression instanceof VarModelIdentifierExpression) {
            CallArgument[] args;
            String opName;
            List<IMetaOperation> ops;
            VarModelIdentifierExpression varModelIdEx = (VarModelIdentifierExpression)initExpression;
            if (null == operand) {
                operand = varModelIdEx.getModel();
            }
            if (TypeRegistry.resolvableOperationType().isAssignableFrom(pType) && IvmlTypes.ivmlElement().isAssignableFrom(aType) && operand instanceof IModel && 1 == (ops = AbstractCallExpression.assignableCandidates(operand, opName = varModelIdEx.getIdentifier(), args = AbstractCallExpression.toTypeDescriptors(pType, 1), args.length, false)).size()) {
                IMetaOperation functionOp = ops.get(0);
                TypeDescriptor<?> ret = pType.getGenericParameterType(pType.getGenericParameterCount() - 1);
                if (ReflectionTypeDescriptor.VOID == ret || ret.isAssignableFrom(functionOp.getReturnType())) {
                    result = functionOp;
                    listener.resolved(varModelIdEx);
                }
            }
        }
        return result;
    }

    private static CallArgument[] toTypeDescriptors(IMetaType type, int exclude) {
        CallArgument[] result = new CallArgument[Math.max(0, type.getGenericParameterCount() - exclude)];
        for (int a = 0; a < result.length; ++a) {
            result[a] = new CallArgument(type.getGenericParameterType(a));
        }
        return result;
    }

    private static IMetaType[] toTypeDescriptors(CallArgument[] args) throws VilException {
        IMetaType[] result = new IMetaType[args.length];
        for (int a = 0; a < args.length; ++a) {
            result[a] = args[a].inferType();
        }
        return result;
    }

    private static void addAndPruneByType(List<IMetaOperation> candidates, IMetaOperation toAdd, IMetaType[] argTypes, CallArgument[] arguments, int unnamedArgsCount) {
        if (!candidates.isEmpty()) {
            int toAddDiff = AbstractCallExpression.calcTypeDiff(toAdd, argTypes, arguments, unnamedArgsCount);
            for (int i = candidates.size() - 1; i >= 0; --i) {
                IMetaOperation op = candidates.get(i);
                int opDiff = AbstractCallExpression.calcTypeDiff(op, argTypes, arguments, unnamedArgsCount);
                if (toAddDiff >= opDiff) continue;
                candidates.remove(i);
            }
        }
        if (candidates.isEmpty()) {
            candidates.add(toAdd);
        }
    }

    private static int calcTypeDiff(IMetaOperation operation, IMetaType[] argTypes, CallArgument[] arguments, int unnamedArgsCount) {
        int diff = 0;
        for (int p = 0; p < argTypes.length; ++p) {
            IMetaType aType;
            IMetaType pType = AbstractCallExpression.getParameterType(operation, p, arguments, unnamedArgsCount);
            if (TypeRegistry.equals(pType, aType = argTypes[p])) continue;
            diff += AbstractCallExpression.calcSuperDiffRec(aType, pType);
        }
        return diff;
    }

    private static int calcSuperDiffRec(IMetaType iter, IMetaType reference) {
        int diff = AbstractCallExpression.calcSuperDiff(iter, reference);
        if (iter.getGenericParameterCount() == reference.getGenericParameterCount()) {
            for (int p = 0; p < iter.getGenericParameterCount(); ++p) {
                diff += AbstractCallExpression.calcSuperDiffRec(iter.getGenericParameterType(p), reference.getGenericParameterType(p));
            }
        }
        return diff;
    }

    private static int calcSuperDiff(IMetaType iter, IMetaType reference) {
        int diff = 0;
        while (null != iter && !TypeRegistry.equals(iter, reference)) {
            ++diff;
            iter = iter.getSuperType();
        }
        if (null == iter) {
            diff = 100;
        }
        return diff;
    }

    private static List<ConvertibleOperation> convertibleCandidates(IMetaType operand, String name, CallArgument[] arguments, int unnamedArgsCount) throws VilException {
        List<ConvertibleOperation> result = new ArrayList<ConvertibleOperation>();
        List<IMetaOperation> candidates = operand.getCandidates(name, unnamedArgsCount);
        for (int o = 0; o < candidates.size(); ++o) {
            IMetaOperation desc = candidates.get(o);
            int conversionCount = 0;
            Object[] conversionOps = new IMetaOperation[arguments.length];
            boolean allParamOk = true;
            for (int p = 0; allParamOk && p < desc.getParameterCount(); ++p) {
                TypeDescriptor<?> argType;
                IMetaType pType = AbstractCallExpression.getParameterType(desc, p, arguments, unnamedArgsCount);
                TypeDescriptor<?> typeDescriptor = argType = p < arguments.length ? arguments[p].inferType() : null;
                if (null == argType || null == pType || pType.isAssignableFrom(argType)) continue;
                conversionOps[p] = TypeHelper.findConversion(argType, pType);
                if (null != conversionOps[p]) {
                    if (argType.checkConversion(pType, (IMetaOperation)conversionOps[p])) {
                        ++conversionCount;
                    } else {
                        conversionOps[p] = null;
                    }
                }
                allParamOk = null != conversionOps[p];
            }
            if (allParamOk && conversionCount > 0) {
                assert (null != conversionOps && conversionOps.length == arguments.length);
                result.add(new ConvertibleOperation(desc, (IMetaOperation[])conversionOps));
                conversionOps = new IMetaOperation[arguments.length];
                continue;
            }
            Arrays.fill(conversionOps, null);
        }
        if (result.size() > 1 && (result = AbstractCallExpression.selectAmongMultipleCandidates(result, arguments, unnamedArgsCount)).size() > 1) {
            StringBuilder tmp = new StringBuilder();
            for (ConvertibleOperation op : result) {
                if (tmp.length() > 0) {
                    tmp.append(",");
                }
                tmp.append(op.operation.getSignature());
            }
            throw new VilException(tmp + " are ambiguous", 70003);
        }
        return result;
    }

    private static List<ConvertibleOperation> selectAmongMultipleCandidates(List<ConvertibleOperation> candidates, CallArgument[] arguments, int unnamedArgsCount) throws VilException {
        ConvertibleOperation op = null;
        int opCount = 0;
        int minScore = Integer.MAX_VALUE;
        for (int c = 0; c < candidates.size(); ++c) {
            ConvertibleOperation tmp = candidates.get(c);
            int score = tmp.getScore(arguments, unnamedArgsCount);
            if (null == op || score < minScore) {
                op = tmp;
                minScore = score;
                opCount = 1;
                continue;
            }
            if (minScore != score) continue;
            ++opCount;
        }
        if (opCount == 1) {
            candidates.clear();
            candidates.add(op);
        }
        return candidates;
    }

    public static IMetaOperation resolveOperation(IMetaType operand, String name, CallArgument ... arguments) throws VilException {
        IMetaOperation op = null;
        try {
            op = AbstractCallExpression.resolveOperation(operand, name, arguments, true, false);
        }
        catch (VilException e) {
            try {
                if (null != arguments && arguments.length > 0 && !(operand instanceof IModel)) {
                    TypeDescriptor<?> opType = arguments[0].inferType();
                    if (2 == arguments.length) {
                        op = AbstractCallExpression.tryOpConversionToSecond(opType, name, arguments);
                    }
                    if (null == op && null == (op = AbstractCallExpression.resolveFallbacks(opType, name, arguments))) {
                        throw e;
                    }
                }
                throw e;
            }
            catch (VilException e1) {
                throw e;
            }
        }
        return op;
    }

    private static IMetaOperation resolveFallbacks(IMetaType opType, String name, CallArgument[] arguments) {
        IMetaOperation op = null;
        ArrayList fallback = new ArrayList();
        fallback.add(TypeRegistry.stringType());
        if (IvmlTypes.decisionVariableType().isAssignableFrom(opType)) {
            fallback.add(TypeRegistry.booleanType());
            fallback.add(TypeRegistry.realType());
            fallback.add(TypeRegistry.integerType());
        }
        IMetaOperation convOp = null;
        for (int f = 0; null == op && f < fallback.size(); ++f) {
            IMetaType fType = (IMetaType)fallback.get(f);
            convOp = TypeHelper.findConversion(opType, fType);
            if (null == convOp) continue;
            try {
                op = AbstractCallExpression.resolveOperation(fType, name, arguments, true, false);
                if (opType != TypeRegistry.anyType()) continue;
                arguments[0].insertConversion(convOp);
                continue;
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        return op;
    }

    public static IMetaOperation resolveOperation(IMetaType operand, boolean checkMetaForFirstArgField, String name, CallArgument[] arguments) throws VilException {
        FieldAccessExpression fae;
        TypeDescriptor<?> fOperand;
        IMetaOperation op = null;
        if (arguments.length > 0 && checkMetaForFirstArgField && arguments[0].getExpression() instanceof FieldAccessExpression && null != (fOperand = (fae = (FieldAccessExpression)arguments[0].getExpression()).getField().getMetaType())) {
            CallArgument[] args = new CallArgument[arguments.length];
            args[0] = new CallArgument(fOperand);
            for (int a = 1; a < arguments.length; ++a) {
                args[a] = arguments[a];
            }
            try {
                try {
                    op = AbstractCallExpression.resolveOperation(fOperand, name, args);
                }
                catch (VilException e) {
                    op = AbstractCallExpression.resolveOperationOnModel(operand, name, args, new HashSet<Object>());
                }
                if (null != op && null == args[0].getExpression()) {
                    fae.enableMetaAccess();
                } else {
                    op = null;
                }
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        if (null == op) {
            op = AbstractCallExpression.resolveOperation(operand, name, arguments);
        }
        return op;
    }

    private static IMetaOperation resolveOperationOnModel(Object operand, String name, CallArgument[] arguments, Set<Object> done) throws VilException {
        ITypedModel model;
        IMetaOperation op = null;
        if (operand instanceof ITypedModel && !done.contains(model = (ITypedModel)operand)) {
            done.add(model);
            try {
                op = AbstractCallExpression.resolveOperation((IMetaType)model, name, arguments);
            }
            catch (VilException vilException) {
                // empty catch block
            }
            for (int i = 0; null == op && i < model.getImportsCount(); ++i) {
                try {
                    op = AbstractCallExpression.resolveOperationOnModel(model.getImport(i).getResolved(), name, arguments, done);
                    continue;
                }
                catch (VilException vilException) {
                    // empty catch block
                }
            }
        }
        return op;
    }

    private static IMetaOperation tryOpConversionToSecond(IMetaType opType, String name, CallArgument[] arguments) throws VilException {
        IMetaOperation op = null;
        TypeDescriptor<?> sndArgType = arguments[1].inferType();
        IMetaOperation convOp = TypeHelper.findConversion(opType, sndArgType);
        if (null != convOp) {
            try {
                op = AbstractCallExpression.resolveOperation(sndArgType, name, arguments, true, false);
                if (!op.getReturnType().isAssignableFrom(sndArgType)) {
                    arguments[0].insertConversion(convOp);
                }
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        return op;
    }

    private static IMetaOperation resolveOperation(IMetaType operand, String name, CallArgument[] arguments, boolean allowConversion, boolean allowAny) throws VilException {
        IMetaOperation resolved = null;
        int unnamedArgsCount = CallArgument.countUnnamedArguments(arguments);
        List<IMetaOperation> candidates = AbstractCallExpression.assignableCandidates(operand, name, arguments, unnamedArgsCount, allowAny);
        if (1 == candidates.size()) {
            resolved = candidates.get(0);
        } else if (allowConversion) {
            List<ConvertibleOperation> convertible = AbstractCallExpression.convertibleCandidates(operand, name, arguments, unnamedArgsCount);
            if (0 == convertible.size() && null != operand.getBaseType()) {
                convertible = AbstractCallExpression.convertibleCandidates(operand.getBaseType(), name, arguments, unnamedArgsCount);
            }
            if (1 == convertible.size()) {
                ConvertibleOperation found = convertible.get(0);
                resolved = found.operation;
                for (int i = 0; i < unnamedArgsCount; ++i) {
                    IMetaOperation conversionOp = found.conversions[i];
                    if (null == conversionOp) continue;
                    arguments[i].insertConversion(conversionOp);
                }
            }
        }
        if (null == resolved) {
            resolved = operand.addPlaceholderOperation(name, unnamedArgsCount, arguments.length - unnamedArgsCount > 0);
        }
        if (null == resolved) {
            throw new VilException("cannot resolve operation " + AbstractCallExpression.getSignature(name, arguments), 70002);
        }
        int optionalNamed = 0;
        for (int i = unnamedArgsCount; i < arguments.length; ++i) {
            if (null != resolved.getParameter(arguments[i].getName())) continue;
            ++optionalNamed;
        }
        if (optionalNamed > 0 && !resolved.acceptsNamedParameters()) {
            throw new VilException(resolved.getJavaSignature() + " does not accept (optional) named parameters", 70002);
        }
        return resolved;
    }

    public static final String getSignature(String name, CallArgument[] arguments) {
        StringBuilder signature = new StringBuilder(name);
        signature.append("(");
        for (int a = 0; a < arguments.length; ++a) {
            CallArgument arg = arguments[a];
            if (arg.hasName()) {
                signature.append(arg.getName());
                signature.append(" = ");
            }
            try {
                signature.append(arguments[a].inferType().getName());
            }
            catch (VilException e) {
                signature.append("<unknown>");
            }
            if (a >= arguments.length - 1) continue;
            signature.append(",");
        }
        signature.append(")");
        return signature.toString();
    }

    private static IMetaType determineActualType(IMetaType type, Object object, TypeRegistry registry) {
        TypeDescriptor<?> tmpType;
        IDatatype actualType;
        TypeDescriptor<?> result = type;
        if (object instanceof IActualTypeProvider && null != (actualType = ((IActualTypeProvider)object).determineActualTypeName()) && null != (tmpType = registry.getType(actualType)) && tmpType.isActualTypeOf(type)) {
            result = tmpType;
        }
        return result;
    }

    private static IMetaType getEnumType(TypeRegistry registry, EnumValue val) {
        TypeDescriptor<?> tmp = registry.getType(val.getDatatype());
        if (null == tmp) {
            tmp = registry.getType(EnumValue.class);
        }
        return tmp;
    }

    public static <O extends IMetaOperation> O dynamicDispatch(O operation, Object[] args, Class<O> cls, TypeRegistry registry, IArgumentProvider arguments, IMetaType operandOverride) {
        Object result = operation;
        int offset = 0;
        if (operation.isFirstParameterOperand()) {
            offset = 1;
        }
        if (args.length >= offset) {
            boolean forceResolve;
            TypeDescriptor<?> operand = AbstractCallExpression.getOperand(operation, operandOverride);
            boolean bl = forceResolve = operation.getDeclaringType() != operand;
            if (null != operand && operand.enableDynamicDispatch()) {
                CallArgument[] types = new CallArgument[args.length - offset];
                boolean allSame = true;
                boolean failure = false;
                int a = 0;
                while (!failure && a < operation.getRequiredParameterCount()) {
                    String argName = arguments.getArgument(a).getName();
                    if (null == args[a]) {
                        if (a - offset < 0) {
                            failure = true;
                            continue;
                        }
                        types[a - offset] = new CallArgument(argName, (TypeDescriptor)operation.getParameterType(a));
                        ++a;
                        continue;
                    }
                    IMetaType tmp = args[a] instanceof EnumValue ? AbstractCallExpression.getEnumType(registry, (EnumValue)args[a]) : registry.obtainTypeDescriptor(args[a]);
                    if (null == (tmp = AbstractCallExpression.determineActualType(tmp, args[a], registry))) {
                        tmp = operation.getParameterType(a);
                    } else {
                        allSame &= tmp == operation.getParameterType(a);
                    }
                    if (0 == a && offset > 0) {
                        operand = tmp;
                    } else if (tmp instanceof TypeDescriptor) {
                        types[a - offset] = new CallArgument(argName, (TypeDescriptor<?>)tmp);
                    } else {
                        failure = true;
                    }
                    ++a;
                }
                while (!failure && a < types.length) {
                    types[a] = new CallArgument("name", (Expression)null);
                    ++a;
                }
                if (!(allSame && !forceResolve || failure)) {
                    try {
                        IMetaOperation op = AbstractCallExpression.resolveOperation((IMetaType)operand, operation.getName(), types, false, true);
                        if (cls.isInstance(op)) {
                            result = (IMetaOperation)cls.cast(op);
                        }
                    }
                    catch (VilException vilException) {
                        // empty catch block
                    }
                }
            }
        }
        return result;
    }

    private static <O extends IMetaOperation> IMetaType getOperand(O operation, IMetaType operandOverride) {
        IMetaType operand = operation.getDeclaringType();
        if (null != operandOverride && operand.isAssignableFrom(operandOverride)) {
            operand = operandOverride;
        }
        return operand;
    }

    protected static boolean isPlaceholder(IMetaOperation operation) {
        boolean isPlaceholder;
        if (null == operation) {
            isPlaceholder = true;
        } else {
            isPlaceholder = operation.isPlaceholder();
            if (!isPlaceholder) {
                isPlaceholder = operation.getReturnType().isPlaceholder();
                for (int p = 0; !isPlaceholder && p < operation.getParameterCount(); ++p) {
                    isPlaceholder = operation.getParameterType(p).isPlaceholder();
                }
            }
        }
        return isPlaceholder;
    }

    protected String getVilSignature(IMetaOperation operation) {
        String result = null == operation ? this.name + "(?)" : operation.getSignature();
        return result;
    }

    public abstract boolean isPlaceholder();

    public abstract String getVilSignature();

    public boolean isOclCompliant() {
        return true;
    }

    public boolean isIteratingCollectionOperation() {
        return false;
    }

    @Override
    public abstract int getArgumentsCount();

    @Override
    public abstract CallArgument getArgument(int var1);

    private static class ConvertibleOperation {
        private IMetaOperation operation;
        private IMetaOperation[] conversions;

        ConvertibleOperation(IMetaOperation operation, IMetaOperation[] conversions) {
            this.operation = operation;
            this.conversions = conversions;
        }

        public int getScore(CallArgument[] arguments, int unnamedArgsCount) throws VilException {
            int score = 0;
            int step = this.operation.getParameterCount();
            for (int c = 0; c < this.conversions.length; ++c) {
                IMetaType pType = AbstractCallExpression.getParameterType(this.operation, c, arguments, unnamedArgsCount);
                if (null == this.conversions[c]) {
                    TypeDescriptor<?> aType = arguments[c].inferType();
                    if (pType == aType) continue;
                    ++score;
                    continue;
                }
                IMetaType cType = this.conversions[c].getReturnType();
                if (pType == cType) {
                    score += step;
                    continue;
                }
                score += step * step;
            }
            return score;
        }
    }
}

