/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.varModel.model.values.Value;

public class ConstantExpression
extends Expression {
    private Object value;
    private TypeDescriptor<?> type;

    ConstantExpression() {
    }

    public ConstantExpression(TypeDescriptor<?> type, Object value, TypeRegistry registry) throws VilException {
        assert (null != type);
        if (null == type) {
            throw new VilException("type must not be null", 70000);
        }
        this.type = type;
        this.value = value;
        if (null != value) {
            boolean ok;
            if (TypeRegistry.NULL == value) {
                ok = true;
            } else if (value instanceof EnumValue) {
                ok = this.checkAndConvert(registry.getType(((EnumValue)value).getDatatype()));
            } else if (value instanceof Version) {
                ok = this.checkAndConvert(TypeRegistry.versionType());
            } else if (value instanceof Value) {
                Value val = (Value)value;
                ok = this.checkAndConvert(registry.getType(val.getType()));
            } else {
                ok = this.checkAndConvert(registry.getType(value.getClass().getName()));
                ok |= this.checkAndConvert(registry.getType(value.getClass().getSimpleName()));
            }
            if (!ok) {
                throw new VilException("type '" + type.getName() + "' is not compatible to value " + value, 70001);
            }
        }
    }

    private boolean checkAndConvert(TypeDescriptor<?> checkFor) {
        boolean ok = false;
        if (null != checkFor) {
            if (!this.type.isAssignableFrom(checkFor)) {
                if (String.class == this.value.getClass()) {
                    try {
                        if (this.type == TypeRegistry.booleanType()) {
                            this.value = Boolean.valueOf((String)this.value);
                            ok = true;
                        } else if (this.type == TypeRegistry.integerType()) {
                            this.value = Integer.valueOf((String)this.value);
                            ok = true;
                        } else if (this.type == TypeRegistry.realType()) {
                            this.value = Double.valueOf((String)this.value);
                            ok = true;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
            } else {
                ok = true;
            }
        }
        return ok;
    }

    public Object getValue() {
        return this.value;
    }

    public TypeDescriptor<?> getType() {
        return this.type;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        return this.type;
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        return visitor.visitConstantExpression(this);
    }
}

