/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.util.ArrayList;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class ContainerInitializerExpression
extends Expression {
    private Expression[] initExpressions;
    private TypeDescriptor<?> type;

    public ContainerInitializerExpression() {
        this(null);
    }

    public ContainerInitializerExpression(Expression[] initExpressions) {
        this.initExpressions = initExpressions;
    }

    protected ContainerInitializerExpression(Expression[] initExpressions, TypeDescriptor<?> type) {
        this.initExpressions = initExpressions;
        this.type = type;
    }

    public Expression getInitExpression(int index) {
        return this.initExpressions[index];
    }

    public void setInitExpression(int index, Expression expr) {
        this.initExpressions[index] = expr;
    }

    public int getInitExpressionsCount() {
        return null == this.initExpressions ? 0 : this.initExpressions.length;
    }

    private static TypeDescriptor<?> moreCommon(TypeDescriptor<?> t1, TypeDescriptor<?> t2) {
        TypeDescriptor<?> result = t1.isAssignableFrom(t2) ? t1 : (t2.isAssignableFrom(t1) ? t2 : TypeRegistry.anyType());
        return result;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        if (null == this.type) {
            TypeDescriptor<?>[] parameter;
            if (this.getInitExpressionsCount() > 0) {
                ArrayList params = new ArrayList();
                ArrayList local = new ArrayList();
                for (int e = 0; e < this.getInitExpressionsCount(); ++e) {
                    Expression ex = this.getInitExpression(e);
                    local.clear();
                    if (ex instanceof ContainerInitializerExpression) {
                        ContainerInitializerExpression initEx = (ContainerInitializerExpression)ex;
                        for (int i = 0; i < initEx.getInitExpressionsCount(); ++i) {
                            local.add(initEx.getInitExpression(i).inferType());
                        }
                    } else {
                        local.add(ex.inferType());
                    }
                    if (0 == e) {
                        params.addAll(local);
                        continue;
                    }
                    if (params.size() != local.size()) {
                        throw new VilException("parameter size does not match", 70001);
                    }
                    for (int p = 0; p < params.size(); ++p) {
                        params.set(p, ContainerInitializerExpression.moreCommon((TypeDescriptor)params.get(p), (TypeDescriptor)local.get(p)));
                    }
                }
                parameter = TypeDescriptor.createArray(params.size());
                params.toArray(parameter);
            } else {
                parameter = null;
            }
            this.type = TypeRegistry.getSequenceType(parameter);
        }
        return this.type;
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        return visitor.visitContainerInitializerExpression(this);
    }

    public boolean isImplicit() {
        return false;
    }

    protected ContainerInitializerExpression createInitExpression(Expression[] initExpressions, TypeDescriptor<?> type) {
        return new ContainerInitializerExpression(initExpressions, type);
    }

    public ContainerInitializerExpression toSet() throws VilException {
        TypeDescriptor<?>[] parameter = TypeDescriptor.createArray(this.type.getGenericParameterCount());
        for (int p = 0; p < parameter.length; ++p) {
            parameter[p] = this.type.getGenericParameterType(p);
        }
        return this.createInitExpression(this.initExpressions, TypeRegistry.getSetType(parameter));
    }
}

