/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.modelManagement.IVariable;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CompositeExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ContainerInitializerExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.expressions.FieldAccessExpression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionIterator;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.MultiAndExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ParenthesisExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationExpression;
import net.ssehub.easy.instantiation.core.model.expressions.StringExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ValueAssignmentExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VarModelIdentifierExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VilTypeExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;

public class CopyVisitor
implements IExpressionVisitor {
    private Map<VariableDeclaration, VariableDeclaration> mapping;
    private boolean reuse;
    private IVersionRestriction.IVariableMapper mapper;

    public CopyVisitor(Map<VariableDeclaration, VariableDeclaration> mapping, boolean reuse) {
        this(mapping, reuse, null);
    }

    public CopyVisitor(Map<VariableDeclaration, VariableDeclaration> mapping, boolean reuse, IVersionRestriction.IVariableMapper mapper) {
        this.mapping = mapping;
        this.reuse = reuse;
        this.mapper = mapper;
    }

    protected IVersionRestriction.IVariableMapper getMapper() {
        return this.mapper;
    }

    @Override
    public Object visitParenthesisExpression(ParenthesisExpression par) throws VilException {
        ParenthesisExpression result = new ParenthesisExpression((Expression)par.accept(this));
        ((Expression)result).inferType();
        return result;
    }

    protected CallArgument[] copyCallArguments(AbstractCallExpression call) throws VilException {
        CallArgument[] arguments = new CallArgument[call.getArgumentsCount()];
        for (int a = 0; a < arguments.length; ++a) {
            CallArgument arg = call.getArgument(a);
            arguments[a] = new CallArgument(arg.getName(), (Expression)arg.getExpression().accept(this));
        }
        return arguments;
    }

    @Override
    public Object visitCallExpression(CallExpression call) throws VilException {
        CallExpression result;
        CallArgument[] arguments = this.copyCallArguments(call);
        switch (call.getCallType()) {
            case NORMAL: {
                result = new CallExpression(call.getParent(), call.getName(), call.isDotRightExpression(), arguments);
                break;
            }
            case EXTERNAL: {
                result = new CallExpression((IMetaOperation)call.getResolved(), arguments);
                break;
            }
            case TRANSPARENT: {
                result = new CallExpression(call.getResolved(), arguments[0]);
                break;
            }
            default: {
                result = call;
            }
        }
        ((Expression)result).inferType();
        return result;
    }

    @Override
    public Object visitConstantExpression(ConstantExpression cst) throws VilException {
        return cst;
    }

    @Override
    public Object visitVarModelIdentifierExpression(VarModelIdentifierExpression identifier) throws VilException {
        VarModelIdentifierExpression result;
        if (this.reuse) {
            result = identifier;
        } else {
            result = new VarModelIdentifierExpression(identifier.getIdentifier(), identifier.getType(), identifier.getModel());
            ((Expression)result).inferType();
        }
        return result;
    }

    @Override
    public Object visitVilTypeExpression(VilTypeExpression typeExpression) throws VilException {
        VilTypeExpression result;
        if (this.reuse) {
            result = typeExpression;
        } else {
            result = new VilTypeExpression(typeExpression.getIdentifier(), typeExpression.getResolved());
            ((Expression)result).inferType();
        }
        return result;
    }

    @Override
    public Object visitVariableExpression(VariableExpression cst) throws VilException {
        VariableExpression result;
        VariableDeclaration var = this.map(cst.getDeclaration(), true);
        if (null == var) {
            result = cst;
        } else {
            result = new VariableExpression(var);
            ((Expression)result).inferType();
        }
        return result;
    }

    @Override
    public Object visitFieldAccessExpression(FieldAccessExpression ex) throws VilException {
        FieldAccessExpression result;
        if (null != ex.getVariable()) {
            VariableDeclaration var = this.map(ex.getVariable(), true);
            if (null == var) {
                result = ex;
            } else {
                result = new FieldAccessExpression(var, ex.getField());
                ((Expression)result).inferType();
            }
        } else {
            Object nested = ex.getNested().accept(this);
            if (nested instanceof FieldAccessExpression) {
                result = new FieldAccessExpression((FieldAccessExpression)nested, ex.getField());
                ((Expression)result).inferType();
            } else {
                result = null;
            }
        }
        return result;
    }

    protected VariableDeclaration map(VariableDeclaration decl, boolean allowNull) {
        IVariable var;
        VariableDeclaration result = null;
        if (null != this.mapping) {
            result = this.mapping.get(decl);
        }
        if (null == result && null != this.mapper && (var = this.mapper.map(decl)) instanceof VariableDeclaration) {
            result = (VariableDeclaration)var;
        }
        if (!this.reuse && null == result) {
            result = decl;
        }
        if (!allowNull && null == result) {
            result = decl;
        }
        return result;
    }

    @Override
    public Object visitExpressionEvaluator(ExpressionEvaluator ex) throws VilException {
        VariableDeclaration origIter = ex.getIteratorVariable();
        VariableDeclaration iter = this.map(origIter, false);
        Expression expr = (Expression)ex.getExpression().accept(this);
        ArrayList<VariableDeclaration> decl = new ArrayList<VariableDeclaration>();
        for (int d = 0; d < ex.getDeclaratorsCount(); ++d) {
            VariableDeclaration declarator = ex.getDeclarator(d);
            declarator = declarator == origIter ? iter : this.map(declarator, false);
            decl.add(declarator);
        }
        ExpressionEvaluator result = new ExpressionEvaluator(expr, iter, decl);
        ((Expression)result).inferType();
        return result;
    }

    @Override
    public Object visitExpression(Expression ex) throws VilException {
        return new ParenthesisExpression((Expression)ex.accept(this));
    }

    @Override
    public Object visitValueAssignmentExpression(ValueAssignmentExpression ex) throws VilException {
        VariableDeclaration decl = this.map(ex.getVarDecl(), false);
        Expression valEx = (Expression)ex.getValueExpression().accept(this);
        ValueAssignmentExpression result = new ValueAssignmentExpression(decl, ex.getField(), valEx);
        ((Expression)result).inferType();
        return result;
    }

    @Override
    public Object visitContainerInitializerExpression(ContainerInitializerExpression ex) throws VilException {
        Expression[] init = new Expression[ex.getInitExpressionsCount()];
        for (int i = 0; i < init.length; ++i) {
            init[i] = (Expression)ex.getInitExpression(i).accept(this);
        }
        ContainerInitializerExpression result = new ContainerInitializerExpression(init);
        ((Expression)result).inferType();
        return result;
    }

    @Override
    public Object visitCompositeExpression(CompositeExpression ex) throws VilException {
        return new CompositeExpression(this.copyExpressions(ex));
    }

    protected List<Expression> copyExpressions(IExpressionIterator iter) throws VilException {
        ArrayList<Expression> result = new ArrayList<Expression>();
        for (int e = 0; e < iter.getExpressionsCount(); ++e) {
            result.add(this.copyExpression(iter.getExpression(e)));
        }
        return result;
    }

    protected Expression copyExpression(Expression ex) throws VilException {
        Expression result = null != ex ? (Expression)ex.accept(this) : null;
        return result;
    }

    @Override
    public Object visitResolvableOperationExpression(ResolvableOperationExpression ex) throws VilException {
        return new ResolvableOperationExpression(ex.getType(), ex.getOperation());
    }

    @Override
    public Object visitResolvableOperationCallExpression(ResolvableOperationCallExpression ex) throws VilException {
        return new ResolvableOperationCallExpression(ex.getVariable(), this.copyCallArguments(ex));
    }

    @Override
    public Object visitMultiAndExpression(MultiAndExpression ex) throws VilException {
        AbstractCallExpression[] exprs = new AbstractCallExpression[ex.getExpressionCount()];
        for (int e = 0; e < exprs.length; ++e) {
            exprs[e] = (AbstractCallExpression)ex.getExpression(e).accept(this);
        }
        MultiAndExpression result = new MultiAndExpression(exprs);
        ((Expression)result).inferType();
        return result;
    }

    @Override
    public Object visitStringExpression(StringExpression ex) throws VilException {
        return new StringExpression((Expression)ex.getExpression().accept(this), ex.isNested());
    }
}

