/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionParser;
import net.ssehub.easy.instantiation.core.model.expressions.Resolver;

public class ExpressionParserRegistry {
    private static Map<ILanguage<?>, IExpressionParser<?>> expressionParsers = new HashMap();

    public static <R extends Resolver<?>> void setExpressionParser(ILanguage<R> language, IExpressionParser<R> parser) {
        String info = null != parser ? "registered expression parser " + parser.getClass().getName() + " for " + language.getName() : "expression parser unregistered";
        EASyLoggerFactory.INSTANCE.getLogger(ExpressionParserRegistry.class, "net.ssehub.easy.instantiation.core").info(info);
        expressionParsers.put(language, parser);
    }

    public static <R extends Resolver<?>> IExpressionParser<R> getExpressionParser(ILanguage<R> language) {
        return expressionParsers.get(language);
    }

    public static interface ILanguage<R extends Resolver<?>> {
        public String getName();
    }
}

