/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.io.StringWriter;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.IRestrictionEvaluationContext;
import net.ssehub.easy.basics.modelManagement.IVersionRestriction;
import net.ssehub.easy.basics.modelManagement.RestrictionEvaluationException;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionWriter;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public abstract class ExpressionVersionRestriction
implements IVersionRestriction {
    private Expression expr;
    private VariableDeclaration versionVariable;

    public ExpressionVersionRestriction(Expression expr, VariableDeclaration versionVariable) throws RestrictionEvaluationException {
        this.expr = expr;
        this.versionVariable = versionVariable;
        try {
            TypeDescriptor<?> type = expr.inferType();
            if (!TypeRegistry.booleanType().isAssignableFrom(type)) {
                throw new RestrictionEvaluationException("restriction expression must be of type Boolean", 10100);
            }
        }
        catch (VilException e) {
            throw new RestrictionEvaluationException(e.getMessage(), e.getId(), e);
        }
    }

    public static Expression createSingleRestriction(VariableDeclaration var, String operator, Version version) throws VilException {
        Expression result = new VariableExpression(var);
        ConstantExpression varConst = new ConstantExpression(TypeRegistry.versionType(), version, TypeRegistry.DEFAULT);
        result = new CallExpression(null, operator, result, varConst);
        result.inferType();
        return result;
    }

    @Override
    public void emit(Object context) {
        if (context instanceof IExpressionVisitor) {
            try {
                this.expr.accept((IExpressionVisitor)context);
            }
            catch (VilException e) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(e);
            }
        }
    }

    @Override
    public String toSpecification() {
        StringWriter out = new StringWriter();
        ExpressionWriter writer = new ExpressionWriter(out);
        try {
            this.expr.accept(writer);
        }
        catch (VilException e) {
            EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(e);
        }
        return out.toString();
    }

    @Override
    public boolean evaluate(IRestrictionEvaluationContext context, Version version) throws RestrictionEvaluationException {
        boolean result = false;
        if (context instanceof IRuntimeEnvironment) {
            Object visitor = context.startEvaluation();
            try {
                context.setValue(this.versionVariable, version);
                Object tmp = this.expr.accept((IExpressionVisitor)visitor);
                context.unsetValue(this.versionVariable);
                if (tmp instanceof Boolean) {
                    result = (Boolean)tmp;
                } else if (null != tmp) {
                    context.endEvaluation(visitor);
                    throw new RestrictionEvaluationException("expression does not evaluate to Boolean", 70000);
                }
            }
            catch (VilException e) {
                EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").exception(e);
            }
            context.endEvaluation(visitor);
        }
        return result;
    }

    protected Expression getExpression() {
        return this.expr;
    }

    protected VariableDeclaration getVersionVariable() {
        return this.versionVariable;
    }
}

