/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IStringParserFactory;
import net.ssehub.easy.instantiation.core.model.expressions.InPlaceCommand;

public class InPlaceIfCommand<I extends VariableDeclaration>
extends InPlaceCommand<I> {
    private Expression condition;
    private List<Expression> thenEx;
    private List<Expression> elseEx;
    private transient List<Expression> curEx;

    InPlaceIfCommand(Expression condition) {
        this.condition = condition;
        this.thenEx = new ArrayList<Expression>();
        this.curEx = this.thenEx;
    }

    public Expression getCondition() {
        return this.condition;
    }

    public List<Expression> getThenExpressions() {
        return this.thenEx;
    }

    public List<Expression> getElseExpressions() {
        return this.elseEx;
    }

    @Override
    protected void advanceState() {
        this.elseEx = new ArrayList<Expression>();
        this.curEx = this.elseEx;
    }

    @Override
    protected void append(Expression ex) {
        this.curEx.add(ex);
    }

    @Override
    protected Expression close(IStringParserFactory<I> factory) throws VilException {
        return factory.createIfExpression(this);
    }

    @Override
    protected void append(List<Expression> exprs) {
        exprs.addAll(this.thenEx);
        if (null != this.elseEx) {
            exprs.addAll(this.elseEx);
        }
    }

    @Override
    protected void replace(InPlaceCommand<I> cmd, Expression expr) {
        if (!this.replace(this.thenEx, cmd, expr) && null != this.elseEx) {
            this.replace(this.elseEx, cmd, expr);
        }
    }
}

