/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CompositeExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ContainerInitializerExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.expressions.FieldAccessExpression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionParser;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.expressions.IResolvable;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.expressions.IStringParserFactory;
import net.ssehub.easy.instantiation.core.model.expressions.InPlaceCommand;
import net.ssehub.easy.instantiation.core.model.expressions.MultiAndExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ParenthesisExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Resolver;
import net.ssehub.easy.instantiation.core.model.expressions.StringExpression;
import net.ssehub.easy.instantiation.core.model.expressions.StringParser;
import net.ssehub.easy.instantiation.core.model.expressions.ValueAssignmentExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VarModelIdentifierExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import net.ssehub.easy.instantiation.core.model.expressions.VilTypeExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;

public class StringReplacer<I extends VariableDeclaration, R extends Resolver<I>>
extends StringParser<String, I, R> {
    private IRuntimeEnvironment environment;
    private IExpressionVisitor expressionEvaluator;
    private IExpressionParser<R> expressionParser;
    private Map<Object, Positions> inPlacePositions = new HashMap<Object, Positions>();
    private IExpressionVisitor recursiveReplacer = new IExpressionVisitor(){

        @Override
        public Object visitVilTypeExpression(VilTypeExpression typeExpression) throws VilException {
            return null;
        }

        @Override
        public Object visitVariableExpression(VariableExpression cst) throws VilException {
            return null;
        }

        @Override
        public Object visitVarModelIdentifierExpression(VarModelIdentifierExpression ex) throws VilException {
            return StringReplacer.this.resolve(ex);
        }

        @Override
        public Object visitValueAssignmentExpression(ValueAssignmentExpression ex) throws VilException {
            return null;
        }

        @Override
        public Object visitResolvableOperationExpression(ResolvableOperationExpression ex) throws VilException {
            return null;
        }

        @Override
        public Object visitResolvableOperationCallExpression(ResolvableOperationCallExpression ex) throws VilException {
            return null;
        }

        @Override
        public Object visitParenthesisExpression(ParenthesisExpression par) throws VilException {
            return par.getExpr().accept(this);
        }

        @Override
        public Object visitMultiAndExpression(MultiAndExpression ex) throws VilException {
            return null;
        }

        @Override
        public Object visitFieldAccessExpression(FieldAccessExpression ex) throws VilException {
            return null;
        }

        @Override
        public Object visitExpressionEvaluator(ExpressionEvaluator ex) throws VilException {
            return null;
        }

        @Override
        public Object visitExpression(Expression ex) throws VilException {
            return null;
        }

        @Override
        public Object visitContainerInitializerExpression(ContainerInitializerExpression ex) throws VilException {
            ContainerInitializerExpression result = null;
            for (int e = 0; e < ex.getInitExpressionsCount(); ++e) {
                Object tmp = ex.getInitExpression(e).accept(this);
                if (!(tmp instanceof Expression)) continue;
                ex.setInitExpression(e, (Expression)tmp);
                result = ex;
            }
            return result;
        }

        @Override
        public Object visitConstantExpression(ConstantExpression cst) throws VilException {
            ConstantExpression result;
            if (TypeRegistry.stringType().isAssignableFrom(cst.getType())) {
                String in = cst.getValue().toString();
                String tmp = StringReplacer.substitute(cst.getValue().toString(), StringReplacer.this.getResolver(), StringReplacer.this.expressionParser, StringReplacer.this.expressionEvaluator, StringReplacer.this.getFactory());
                result = null != tmp && !tmp.equals(in) ? new ConstantExpression(TypeRegistry.stringType(), tmp, StringReplacer.this.environment.getTypeRegistry()) : null;
            } else {
                result = null;
            }
            return result;
        }

        @Override
        public Object visitCompositeExpression(CompositeExpression ex) throws VilException {
            CompositeExpression result = null;
            for (int e = 0; e < ex.getExpressionsCount(); ++e) {
                Object tmp = ex.getExpression(e).accept(this);
                if (!(tmp instanceof Expression)) continue;
                ex.setExpression(e, (Expression)tmp);
                result = ex;
            }
            return result;
        }

        @Override
        public Object visitCallExpression(CallExpression call) throws VilException {
            CallExpression result = null;
            for (int a = 0; a < call.getArgumentsCount(); ++a) {
                Object tmp;
                CallArgument arg = call.getArgument(a);
                Expression ex = arg.getExpression();
                if (null == ex || !((tmp = ex.accept(this)) instanceof Expression)) continue;
                arg.setExpression((Expression)tmp);
                result = call;
            }
            return result;
        }

        @Override
        public Object visitStringExpression(StringExpression ex) throws VilException {
            return ex.getExpression().accept(this);
        }
    };

    private StringReplacer(String text, R resolver, IExpressionParser<R> expressionParser, IExpressionVisitor expressionEvaluator, IStringParserFactory<I> factory) {
        super(text, resolver, factory);
        this.environment = ((Resolver)resolver).getRuntimeEnvironment();
        this.expressionEvaluator = expressionEvaluator;
        this.expressionParser = expressionParser;
    }

    public static <I extends VariableDeclaration, R extends Resolver<I>> String substitute(String text, R resolver, IExpressionParser<R> expressionParser, IExpressionVisitor expressionEvaluator, IStringParserFactory<I> factory) throws VilException {
        String result;
        if (null != text) {
            try {
                StringReplacer<I, R> replacer = new StringReplacer<I, R>(text, resolver, expressionParser, expressionEvaluator, factory);
                result = (String)replacer.parse();
            }
            catch (VilException e) {
                if (50504 == e.getId()) {
                    result = null;
                }
                throw e;
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    protected String createParseResult() throws VilException {
        return this.toText();
    }

    @Override
    protected void handleQuote(int pos) throws VilException {
        if (pos + 2 < this.length() && this.charAt(pos + 2) != '$') {
            this.deleteCharAt(pos);
        }
    }

    @Override
    protected void handleTextEnd(int curStart, int pos) throws VilException {
        this.handleConstant(curStart, pos, 0);
    }

    @Override
    protected int handleVariableStartExpression(int curStart, int pos) throws VilException {
        this.handleConstant(curStart, pos, 1);
        return pos + 1;
    }

    @Override
    protected int handleVariableStartVariable(int curStart, int pos) throws VilException {
        this.handleConstant(curStart, pos, 0);
        return pos;
    }

    @Override
    protected int handleEndOfText(int curStart, int pos, StringParser.State state) throws VilException {
        if (StringParser.State.VARIABLE_START == state) {
            this.handleConstant(curStart, pos, 0);
        }
        return pos;
    }

    private void handleConstant(int curStart, int position, int posAdvance) throws VilException {
        if (this.isNonEmptyCommandStack()) {
            String string;
            InPlaceCommand cmd = this.getCurrentInPlaceCommand();
            Positions p = this.inPlacePositions.get(cmd);
            if (null != p) {
                int end;
                int start = p.getLatestPos() + 1;
                if (start < (end = position - 1)) {
                    string = this.substring(p.getLatestPos() + 1, position - 1);
                    p.setLatestPos(position + posAdvance);
                } else {
                    string = "";
                }
            } else {
                string = this.substring(curStart, position);
            }
            if (string.length() > 0) {
                this.addExpression(this.createConstantStringExpression(string), null);
            }
        }
    }

    @Override
    protected int handleVariable(int curStart, int pos) throws VilException {
        String value;
        String variableName = this.substring(curStart, pos);
        Object oValue = null;
        IResolvable var = this.environment.get(variableName);
        if (null != var) {
            oValue = this.environment.getValue(var);
        } else {
            try {
                oValue = this.environment.getIvmlValue(variableName);
            }
            catch (VilException e) {
                this.warnParsingIgnoring(variableName, e);
            }
        }
        if (null != oValue && null != (value = StringValueHelper.getStringValueInReplacement(oValue, null))) {
            InPlaceCommand cmd;
            Positions p;
            int start = curStart - 1;
            if (this.isNonEmptyCommandStack() && null != (p = this.inPlacePositions.get(cmd = this.getCurrentInPlaceCommand()))) {
                start = p.getLatestPos() + 1;
            }
            pos = this.setPos(this.replace(start, pos, value));
        }
        return -1;
    }

    @Override
    protected int handleExpression(int curStart, int pos) throws VilException {
        if (null == this.expressionParser) {
            this.getLogger().warn("no expression parser registered");
        } else if (null == this.expressionEvaluator) {
            this.getLogger().warn("no expression evaluator registered");
        } else {
            String value;
            Object oValue;
            Object tmp;
            String expressionString = this.substring(curStart, pos);
            Expression expr = null;
            try {
                expr = this.handleInPlaceCommands(expressionString, curStart, pos);
            }
            catch (VilException e) {
                this.warnParsingIgnoring(expressionString, e);
            }
            if (null != expr && (tmp = expr.accept(this.recursiveReplacer)) instanceof Expression) {
                expr = (Expression)tmp;
            }
            if (null != expr && null != (oValue = expr.accept(this.expressionEvaluator)) && null != (value = StringValueHelper.getStringValueInReplacement(oValue, null))) {
                Positions inPlaceStart = this.inPlacePositions.remove(expr);
                int start = null == inPlaceStart ? curStart : inPlaceStart.openCurPos;
                pos = this.setPos(this.replace(start - 2, pos + 1, value));
                pos = this.checkForEmptyLine(value, expr, pos);
            }
        }
        return pos;
    }

    private int checkForEmptyLine(String value, Expression expr, int pos) {
        if (0 == value.length() && expr.replaceEmptyLine() && pos > 0 && pos < this.length()) {
            char before = this.charAt(pos - 1);
            char at = this.charAt(pos);
            if (!('\r' != before && '\n' != before || '\r' != at && '\n' != at)) {
                this.deleteCharAt(pos);
                if ('\r' == at && pos < this.length() && '\n' == this.charAt(pos)) {
                    this.deleteCharAt(pos);
                }
            }
        }
        return pos;
    }

    @Override
    protected void notifyStartInPlaceCommand(InPlaceCommand<I> cmd, int curStart, int pos) {
        Positions p = this.inPlacePositions.get(cmd);
        if (null == p) {
            this.inPlacePositions.put(cmd, new Positions(curStart, pos));
        } else {
            p.midPos = pos;
        }
    }

    @Override
    protected void notifyBracketsClosed(InPlaceCommand<I> cmd, int pos) {
        Positions p = this.inPlacePositions.get(cmd);
        if (null != p) {
            if (p.midPos < 0) {
                p.openPos = pos;
            } else {
                p.midPos = pos;
            }
        }
    }

    @Override
    protected void notifyEndInPlaceCommand(InPlaceCommand<I> cmd, Expression expr, int curStart, int pos) {
        Positions p = this.inPlacePositions.remove(cmd);
        if (null != p) {
            this.inPlacePositions.put(expr, p);
        }
    }

    @Override
    protected Expression parseExpressionImpl(String expressionString) throws VilException {
        Expression result = null;
        try {
            result = this.expressionParser.parse(expressionString, this.getResolver());
            if (result instanceof VarModelIdentifierExpression) {
                result = this.resolve((VarModelIdentifierExpression)result);
            }
        }
        catch (VilException e) {
            this.warnParsingIgnoring(expressionString, e);
        }
        return result;
    }

    private Expression resolve(VarModelIdentifierExpression ex) {
        ConstantExpression result = null;
        String id = ex.getIdentifier();
        try {
            IRuntimeEnvironment env = ((Resolver)this.getResolver()).getRuntimeEnvironment();
            Object res = env.getIvmlValue(id);
            if (res instanceof DecisionVariable) {
                DecisionVariable var = (DecisionVariable)res;
                TypeDescriptor<?> type = var.getType();
                result = new ConstantExpression(type, var.getValue(), this.environment.getTypeRegistry());
            }
        }
        catch (VilException e) {
            this.warnParsingIgnoring(id, e);
        }
        return result;
    }

    private static class Positions {
        private int openCurPos;
        private int openPos;
        private int midPos = -1;

        private Positions(int curPos, int pos) {
            this.openCurPos = curPos;
            this.openPos = pos;
        }

        private int getLatestPos() {
            return this.midPos < 0 ? this.openPos : this.midPos;
        }

        private void setLatestPos(int pos) {
            if (this.midPos < 0) {
                this.openPos = pos;
            } else {
                this.midPos = pos;
            }
        }
    }
}

