/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.expressions;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.basics.messages.IMessage;
import net.ssehub.easy.basics.messages.Status;
import net.ssehub.easy.dslCore.ModelUtility;
import net.ssehub.easy.dslCore.translation.IMessageReceiver;
import net.ssehub.easy.instantiation.core.model.common.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CompositeExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IStringParserFactory;
import net.ssehub.easy.instantiation.core.model.expressions.Resolver;
import net.ssehub.easy.instantiation.core.model.expressions.StringParser;
import net.ssehub.easy.instantiation.core.model.expressions.VariableExpression;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;

public class StringResolver<I extends VariableDeclaration, R extends Resolver<I>, E extends ExpressionStatement>
extends StringParser<CompositeExpression, I, R>
implements IMessageReceiver {
    private IExpressionTranslator<I, R> translator;
    private StringBuilder warnings;
    private List<Expression> expressions = new ArrayList<Expression>();

    private StringResolver(String text, R resolver, IExpressionTranslator<I, R> translator, StringBuilder warnings, IStringParserFactory<I> factory) {
        super(text, resolver, factory);
        this.warnings = warnings;
        this.translator = translator;
    }

    public static <I extends VariableDeclaration, R extends Resolver<I>, E extends ExpressionStatement> Expression substitute(String text, R resolver, IExpressionTranslator<I, R> translator, StringBuilder warnings, IStringParserFactory<I> factory) throws VilException {
        CompositeExpression result;
        if (null != text) {
            try {
                StringResolver<I, R, E> replacer = new StringResolver<I, R, E>(text, resolver, translator, warnings, factory);
                if (text.contains("$")) {
                    result = (CompositeExpression)replacer.parse();
                }
                List<Expression> list = super.handleConstant(text);
                result = new CompositeExpression(list);
            }
            catch (VilException e) {
                if (50504 == e.getId()) {
                    result = null;
                }
                throw e;
            }
        } else {
            result = null;
        }
        return result;
    }

    @Override
    protected CompositeExpression createParseResult() throws VilException {
        this.clearStatementStack(this.expressions);
        return new CompositeExpression(this.expressions);
    }

    @Override
    protected void handleQuote(int pos) throws VilException {
    }

    @Override
    protected void handleTextEnd(int curStart, int pos) throws VilException {
        this.handleConstant(curStart, pos + 1);
    }

    @Override
    protected int handleVariableStartExpression(int curStart, int pos) throws VilException {
        this.handleConstant(curStart, pos - 1);
        return pos;
    }

    @Override
    protected int handleVariableStartVariable(int curStart, int pos) throws VilException {
        this.handleConstant(curStart, pos - 1);
        return pos;
    }

    @Override
    protected int handleEndOfText(int curStart, int pos, StringParser.State state) throws VilException {
        if (StringParser.State.VARIABLE_START == state) {
            this.handleConstant(curStart, pos);
        }
        return pos;
    }

    @Override
    protected int handleExpression(int curStart, int pos) throws VilException {
        Expression result = null;
        String expressionString = this.substring(curStart - 1, pos + 1);
        expressionString = expressionString.substring(2, expressionString.length() - 1);
        result = this.handleInPlaceCommands(expressionString, curStart, pos);
        this.addExpression(result, this.expressions);
        return pos + 1;
    }

    @Override
    protected Expression parseExpressionImpl(String expressionString) throws VilException {
        return this.translator.parseExpression(expressionString, this.getResolver(), this.warnings);
    }

    private void handleConstant(int curStart, int position) throws VilException {
        String string = this.substring(curStart, position);
        if (string.length() > 0) {
            this.addExpression(this.createConstantStringExpression(string), this.expressions);
        }
    }

    private List<Expression> handleConstant(String text) throws VilException {
        ArrayList<Expression> list = new ArrayList<Expression>();
        list.add(this.createConstantStringExpression(text));
        return list;
    }

    protected CompositeExpression resolveVariable(String text) {
        CompositeExpression compExpression = null;
        VariableDeclaration var = (VariableDeclaration)((Resolver)this.getResolver()).resolve(text, false, null, null, this);
        VariableExpression varExpr = null;
        if (var != null) {
            varExpr = new VariableExpression(var);
            ArrayList<Expression> expressionList = new ArrayList<Expression>();
            expressionList.add(varExpr);
            compExpression = new CompositeExpression(expressionList);
        }
        return compExpression;
    }

    @Override
    protected int handleVariable(int curStart, int pos) throws VilException {
        String variableName = this.substring(curStart - 1, pos);
        String pattern2 = "\\$([A-Za-z0-9]+)";
        variableName = variableName.replaceAll(pattern2, "$1");
        pos = this.setPos(this.replace(curStart - 1, pos, variableName));
        VariableDeclaration var = (VariableDeclaration)((Resolver)this.getResolver()).resolve(variableName, false, null, null, this);
        VariableExpression varExpr = null;
        if (var != null) {
            varExpr = new VariableExpression(var);
        } else {
            this.appendWarning(VariableExpression.composeUnkownVariableWarning(variableName));
        }
        this.addExpression(varExpr, this.expressions);
        return pos;
    }

    @Override
    public void error(String message, EObject cause, EStructuralFeature causeFeature, int code) {
    }

    @Override
    public void warning(String message, EObject cause, EStructuralFeature causeFeature, int code) {
        this.appendWarning(message);
    }

    @Override
    public void collect(IMessage message, EObject cause, EStructuralFeature causeFeature, int code) {
        if (Status.WARNING == message.getStatus()) {
            this.appendWarning(message.getDescription());
        }
    }

    private void appendWarning(String message) {
        StringResolver.appendWarning(this.warnings, message);
    }

    public static void appendWarning(StringBuilder warnings, String message) {
        if (null != warnings) {
            ModelUtility.appendWithNewLine(warnings, message);
        }
    }

    public static interface IExpressionTranslator<I extends VariableDeclaration, R extends Resolver<I>> {
        public Expression parseExpression(String var1, R var2, StringBuilder var3) throws VilException;
    }
}

