/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.util.List;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionIterator;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.InContentExpression;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class ContentAlternativeExpression
extends InContentExpression {
    private Expression condition;
    private List<Expression> thenEx;
    private List<Expression> elseEx;

    public ContentAlternativeExpression(Expression condition, List<Expression> thenEx, List<Expression> elseEx) throws VilException {
        this.condition = condition;
        this.thenEx = thenEx;
        this.elseEx = elseEx;
        if (null == this.condition) {
            throw new VilException("No condition expression given/resolved", 30006);
        }
        if (!TypeRegistry.booleanType().isAssignableFrom(this.condition.inferType())) {
            throw new VilException("Condition expression must evaluate to Boolean", 30006);
        }
    }

    public Expression getCondition() {
        return this.condition;
    }

    public IExpressionIterator thenEx() {
        return new IExpressionIterator(){

            @Override
            public int getExpressionsCount() {
                return ContentAlternativeExpression.this.getThenExpressionsCount();
            }

            @Override
            public Expression getExpression(int index) {
                return ContentAlternativeExpression.this.getThenExpression(index);
            }
        };
    }

    public IExpressionIterator elseEx() {
        return new IExpressionIterator(){

            @Override
            public int getExpressionsCount() {
                return ContentAlternativeExpression.this.getElseExpressionsCount();
            }

            @Override
            public Expression getExpression(int index) {
                return ContentAlternativeExpression.this.getElseExpression(index);
            }
        };
    }

    public int getThenExpressionsCount() {
        return this.thenEx.size();
    }

    public int getElseExpressionsCount() {
        return null == this.elseEx ? 0 : this.elseEx.size();
    }

    public Expression getThenExpression(int index) {
        return this.thenEx.get(index);
    }

    public Expression getElseExpression(int index) {
        if (null == this.elseEx) {
            throw new IndexOutOfBoundsException();
        }
        return this.elseEx.get(index);
    }

    @Override
    public Object accept(IExpressionVisitor visitor) throws VilException {
        Object result = visitor instanceof IVisitor ? ((IVisitor)((Object)visitor)).visitContentAlternativeExpression(this) : null;
        return result;
    }
}

