/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import net.ssehub.easy.instantiation.core.model.common.ILanguageElement;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.CompositeExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.templateModel.AbstractTemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class ContentStatement
extends AbstractTemplateElement {
    private CompositeExpression content;
    private String terminal;
    private Expression indentExpression;
    private LineEndType lineEndType;

    ContentStatement() {
    }

    public ContentStatement(CompositeExpression content, String terminal, Expression indentExpression, LineEndType lineEndType, ILanguageElement parent) throws VilException {
        this.setParent(parent);
        this.lineEndType = lineEndType;
        this.content = content;
        this.terminal = terminal;
        this.indentExpression = indentExpression;
        if (null != this.indentExpression && this.indentExpression.inferType() != TypeRegistry.integerType()) {
            throw new VilException("indent expression must result in an Integer", 70001);
        }
    }

    public boolean needsLineEnd(boolean deflt) {
        boolean result = LineEndType.DEFAULT == this.lineEndType ? deflt : LineEndType.LINE_END == this.lineEndType;
        return result;
    }

    public LineEndType getLineEndType() {
        return this.lineEndType;
    }

    public CompositeExpression getContent() {
        return this.content;
    }

    public String getTerminal() {
        return this.terminal;
    }

    @Override
    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitContentStatement(this);
    }

    @Override
    public boolean isBlock() {
        return false;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        return TypeRegistry.stringType();
    }

    public Expression getIndentExpression() {
        return this.indentExpression;
    }

    @Override
    public boolean endsWithContentStatement() {
        return true;
    }

    public static enum LineEndType {
        DEFAULT,
        LINE_END,
        NO_LINE_END;

    }
}

