/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.util.Map;
import net.ssehub.easy.instantiation.core.model.common.ILanguageElement;
import net.ssehub.easy.instantiation.core.model.common.IResolvableOperation;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ContainerInitializerExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.templateModel.ExpressionStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateLangElement;
import net.ssehub.easy.instantiation.core.model.templateModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateBlock;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class Def
extends TemplateBlock
implements ITemplateLangElement,
IResolvableOperation<VariableDeclaration>,
IStringValueProvider {
    private Template parent;
    private String name;
    private VariableDeclaration[] param;
    private Map<String, VariableDeclaration> namedParam;
    private TypeDescriptor<?> specifiedType;
    private boolean isProtected = false;

    Def() {
        super(null);
    }

    public Def(String name, VariableDeclaration[] param, ITemplateElement[] body, TypeDescriptor<?> specifiedType, Template parent) {
        super(body);
        this.parent = parent;
        this.name = name;
        this.param = param;
        this.namedParam = VariableDeclaration.mapDefaultedParameters(this.namedParam, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.param);
        this.specifiedType = specifiedType;
        this.setParent(this);
    }

    public boolean isProtected() {
        return this.isProtected;
    }

    public void setProtected(boolean isProtected) {
        this.isProtected = isProtected;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public TypeDescriptor<?> getSpecifiedType() {
        return this.specifiedType;
    }

    @Override
    public int getParameterCount() {
        return null == this.param ? 0 : this.param.length;
    }

    @Override
    public VariableDeclaration getParameter(int index) {
        if (null == this.param) {
            throw new IndexOutOfBoundsException();
        }
        return this.param[index];
    }

    @Override
    public int getRequiredParameterCount() {
        return VariableDeclaration.getRequiredParameterCount(this.namedParam, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.param);
    }

    @Override
    public VariableDeclaration getParameter(String name) {
        return (VariableDeclaration)VariableDeclaration.getParameter(this.namedParam, (String)name, (net.ssehub.easy.instantiation.core.model.common.VariableDeclaration[])this.param);
    }

    @Override
    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitDef(this);
    }

    @Override
    public IMetaType getParameterType(int index) {
        return this.param[index].getType();
    }

    @Override
    public String getJavaSignature() {
        return this.getSignature();
    }

    @Override
    public String getSignature() {
        StringBuilder signature = new StringBuilder();
        if (null != this.getName()) {
            signature.append(this.getName());
        }
        signature.append("(");
        if (null != this.param) {
            for (int p = 0; p < this.param.length; ++p) {
                signature.append(this.param[p].getType().getVilName());
                if (p >= this.param.length - 1) continue;
                signature.append(",");
            }
        }
        signature.append(")");
        return signature.toString();
    }

    @Override
    public TypeDescriptor<?> getReturnType() {
        return null != this.specifiedType ? this.specifiedType : TypeRegistry.anyType();
    }

    @Override
    public boolean acceptsNamedParameters() {
        return false;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        TypeDescriptor<?> result = super.inferType();
        if (null != this.specifiedType && !this.specifiedType.isAssignableFrom(result)) {
            boolean ok = this.checkEmptyContainerIntializerCompliance(result, this.specifiedType);
            if (!ok && this.specifiedType.getBaseType() instanceof TypeDescriptor) {
                ok = this.checkEmptyContainerIntializerCompliance(result, (TypeDescriptor)this.specifiedType.getBaseType());
            }
            if (!ok) {
                throw new VilException("resulting type of block " + result.getVilName() + " does not fit to specified type " + this.specifiedType.getVilName(), 70001);
            }
        }
        return result;
    }

    private boolean checkEmptyContainerIntializerCompliance(TypeDescriptor<?> result, TypeDescriptor<?> specifiedType) {
        Expression eltEx;
        ITemplateElement elt;
        boolean ok = false;
        if (result.isCollection() && specifiedType.isCollection() && (elt = this.getTypeDefiningElement()) instanceof ExpressionStatement && (eltEx = ((ExpressionStatement)elt).getExpression()) instanceof ContainerInitializerExpression) {
            ok = 0 == ((ContainerInitializerExpression)eltEx).getInitExpressionsCount();
        }
        return ok;
    }

    @Override
    public boolean isFirstParameterOperand() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public IMetaType getDeclaringType() {
        return this.parent;
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return this.getSignature();
    }

    public String toString() {
        StringBuffer result = new StringBuffer(this.name);
        result.append("(");
        if (null != this.param && this.param.length > 0) {
            result.append(this.param[0].toString());
            for (int i = 1; i < this.param.length; ++i) {
                result.append(", ");
                result.append(this.param[i].toString());
            }
        }
        result.append(")");
        return result.toString();
    }

    @Override
    protected void setParent(ILanguageElement parent) {
        super.setParent(parent);
        for (int p = 0; p < this.getParameterCount(); ++p) {
            this.getParameter(p).setParent(this);
        }
    }

    @Override
    public IMetaOperation.CompatibilityResult isCompatible(Class<?> retType, Object ... params) {
        return null;
    }

    @Override
    public Object invoke(Object ... args) throws VilException {
        return null;
    }

    @Override
    public boolean isConstructor() {
        return false;
    }
}

