/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

public class IndentationUtils {
    private IndentationUtils() {
    }

    public static String removeIndentation(String content, int indentation, int tabEmu) {
        int tabWidth = Math.max(1, tabEmu);
        StringBuilder text = new StringBuilder(content);
        int i = 0;
        int lineCount = 0;
        int removedLines = 0;
        while (i < text.length() && indentation > 0) {
            char c = text.charAt(i);
            int startPos = -1;
            if ('\r' == c) {
                i = IndentationUtils.advanceIfNextIsNewLine(text, i);
                startPos = ++i;
                ++lineCount;
            } else if ('\n' == c) {
                if (i > 0 && '\r' != text.charAt(i - 1)) {
                    ++lineCount;
                }
                startPos = ++i;
            } else if (0 == i && IndentationUtils.isIndentationChar(c)) {
                startPos = i;
            } else {
                ++i;
            }
            if (startPos < 0) continue;
            int actIndent = 0;
            while (i < text.length() && actIndent < indentation) {
                c = text.charAt(i);
                if (' ' == c) {
                    ++actIndent;
                } else {
                    if ('\t' != c) break;
                    actIndent += tabWidth;
                }
                ++i;
            }
            if (actIndent == indentation) {
                text.delete(startPos, i);
                i = startPos;
                ++removedLines;
                continue;
            }
            if (actIndent <= 0 || lineCount - removedLines <= 1) continue;
            i = text.length();
        }
        return text.toString();
    }

    private static boolean nextIs(CharSequence text, int pos, char ch) {
        return pos + 1 < text.length() && ch == text.charAt(pos + 1);
    }

    private static int advanceIfNextIsNewLine(CharSequence text, int pos) {
        int result = pos;
        if (IndentationUtils.nextIs(text, pos, '\n')) {
            ++result;
        }
        return result;
    }

    public static String insertIndentation(String content, int indentation, boolean skipFirst) {
        StringBuilder text = new StringBuilder(content);
        int i = 0;
        int count = 0;
        while (i < text.length()) {
            int startPos = -1;
            char c = text.charAt(i);
            if ('\r' == c) {
                i = IndentationUtils.advanceIfNextIsNewLine(text, i);
                startPos = i + 1;
            } else if ('\n' == c) {
                startPos = i + 1;
            } else if (0 == i && !IndentationUtils.isIndentationChar(c)) {
                startPos = i;
            } else {
                ++i;
            }
            if (startPos < 0) continue;
            i = skipFirst && 0 == count ? startPos + 1 : IndentationUtils.insertIndentation(text, startPos, indentation);
            ++count;
            i = IndentationUtils.skipWhitespaces(text, i);
        }
        return text.toString();
    }

    public static boolean isIndentationChar(char ch) {
        return ' ' == ch || '\t' == ch;
    }

    public static boolean isLineEnd(char ch) {
        return '\r' == ch || '\n' == ch;
    }

    private static int skipWhitespaces(StringBuilder text, int pos) {
        char c;
        while (pos < text.length() && (' ' == (c = text.charAt(pos)) || '\t' == c)) {
            ++pos;
        }
        return pos;
    }

    private static int insertIndentation(StringBuilder text, int pos, int indentation) {
        for (int i = 0; i < indentation; ++i) {
            text.insert(pos, ' ');
        }
        return pos + Math.max(0, indentation);
    }

    public static String appendWithLastIndentation(String string, String text, boolean skipLastIndent) {
        String result = string;
        if (result != null) {
            if (text.length() > 0 && IndentationUtils.isIndentationChar(text.charAt(0)) || skipLastIndent) {
                result = result + text;
            } else {
                int pos;
                for (pos = result.length() - 1; pos >= 0 && !IndentationUtils.isIndentationChar(result.charAt(pos)); --pos) {
                }
                int endPos = pos;
                while (pos >= 0 && IndentationUtils.isIndentationChar(result.charAt(pos))) {
                    --pos;
                }
                if (pos < 0) {
                    pos = 0;
                } else if (!IndentationUtils.isLineEnd(result.charAt(pos))) {
                    pos = -1;
                } else if (IndentationUtils.countLineEnds(result, endPos) > 1) {
                    pos = -1;
                }
                result = pos >= 0 && endPos >= pos ? result + IndentationUtils.insertIndentation(text, endPos - pos, IndentationUtils.isIndentationChar(result.charAt(result.length() - 1))) : result + text;
            }
        } else {
            result = text;
        }
        return result;
    }

    public static int countLineEnds(CharSequence string, int startPos) {
        int count = 0;
        for (int i = startPos; i < string.length(); ++i) {
            char c = string.charAt(i);
            if ('\r' == c) {
                ++count;
                i = IndentationUtils.advanceIfNextIsNewLine(string, i);
                continue;
            }
            if ('\n' != c) continue;
            ++count;
        }
        return count;
    }

    public static boolean allLinesStartWith(String text, int indent) {
        boolean allLinesStart = text.length() > 0;
        int actIndent = 0;
        boolean inText = false;
        for (int i = 0; i < text.length(); ++i) {
            char c = text.charAt(i);
            if (IndentationUtils.isIndentationChar(c)) {
                if (inText) continue;
                ++actIndent;
                continue;
            }
            if (IndentationUtils.isLineEnd(c)) {
                inText = false;
                actIndent = 0;
                continue;
            }
            if (!inText && actIndent < indent) {
                allLinesStart = false;
                break;
            }
            inText = true;
        }
        return allLinesStart;
    }

    public static String removeLastIndentation(String text, boolean includingLineEnd) {
        int pos;
        String result = text;
        int initPos = pos = result.length() - 1;
        while (pos > 0 && IndentationUtils.isLineEnd(result.charAt(pos))) {
            --pos;
        }
        while (pos > 0 && IndentationUtils.isIndentationChar(result.charAt(pos))) {
            --pos;
        }
        if (includingLineEnd) {
            while (pos > 0 && IndentationUtils.isLineEnd(result.charAt(pos))) {
                --pos;
            }
        }
        if (pos > 0 && pos < initPos) {
            result = result.substring(0, pos + 1);
        }
        return result;
    }

    public static boolean isIndentationString(String text) {
        boolean result;
        if (text.length() > 0) {
            result = true;
            for (int i = 0; result && i < text.length(); ++i) {
                char c = text.charAt(i);
                result = IndentationUtils.isIndentationChar(c) || IndentationUtils.isLineEnd(c);
            }
        } else {
            result = false;
        }
        return result;
    }
}

