/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.util.List;
import net.ssehub.easy.instantiation.core.model.common.ILanguageElement;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.templateModel.AbstractTemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class SwitchStatement
extends AbstractTemplateElement {
    private Expression switchExpression;
    private Alternative[] alternatives;
    private VariableDeclaration implicitVar;

    SwitchStatement() {
    }

    public SwitchStatement(Expression switchExpression, VariableDeclaration implicitVar, List<Alternative> alternatives) throws VilException {
        this(switchExpression, implicitVar, SwitchStatement.toArray(alternatives));
    }

    public SwitchStatement(Expression switchExpression, VariableDeclaration implicitVar, Alternative[] alternatives) throws VilException {
        this.switchExpression = switchExpression;
        this.implicitVar = implicitVar;
        this.switchExpression.inferType();
        if (null == alternatives || 0 == alternatives.length) {
            throw new VilException("switch must contain at least on alternative", 70001);
        }
        int dfltCount = 0;
        for (int a = 0; a < alternatives.length; ++a) {
            if (!alternatives[a].isDefault()) continue;
            ++dfltCount;
        }
        if (dfltCount > 1) {
            throw new VilException("switch must not contain several defaults", 70001);
        }
        this.alternatives = alternatives;
    }

    public static final Alternative[] toArray(List<Alternative> alternatives) {
        Alternative[] result;
        if (null == alternatives) {
            result = null;
        } else {
            result = new Alternative[alternatives.size()];
            alternatives.toArray(result);
        }
        return result;
    }

    public Expression getSwitchExpression() {
        return this.switchExpression;
    }

    public int getAlternativeCount() {
        return null == this.alternatives ? 0 : this.alternatives.length;
    }

    public Alternative getAlternative(int index) {
        if (null == this.alternatives) {
            throw new IndexOutOfBoundsException();
        }
        return this.alternatives[index];
    }

    public VariableDeclaration getImplicitVariable() {
        return this.implicitVar;
    }

    @Override
    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitSwitch(this);
    }

    @Override
    public boolean isBlock() {
        return false;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        TypeDescriptor<?> result = null;
        for (int a = 0; TypeRegistry.anyType() != result && a < this.alternatives.length; ++a) {
            Alternative alt = this.alternatives[a];
            TypeDescriptor<?> tmp = alt.inferType();
            if (null == result) {
                result = tmp;
                continue;
            }
            if (tmp.equals(result)) continue;
            result = TypeRegistry.anyType();
        }
        return result;
    }

    @Override
    protected void setParent(ILanguageElement parent) {
        super.setParent(parent);
        this.implicitVar.setParent(this);
    }

    @Override
    public boolean endsWithContentStatement() {
        return false;
    }

    public static class Alternative {
        private Expression condition;
        private Expression value;

        Alternative() {
        }

        public Alternative(Expression value) {
            this(null, value);
        }

        public Alternative(Expression condition, Expression value) {
            this.condition = condition;
            this.value = value;
        }

        public Expression getCondition() {
            return this.condition;
        }

        public Expression getValue() {
            return this.value;
        }

        public boolean isDefault() {
            return null == this.condition;
        }

        public TypeDescriptor<?> inferType() throws VilException {
            return this.value.inferType();
        }
    }
}

