/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import net.ssehub.easy.instantiation.core.model.common.ILanguageElement;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.templateModel.AbstractTemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.IVisitor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class TemplateBlock
extends AbstractTemplateElement {
    private ITemplateElement[] body;

    TemplateBlock() {
    }

    public TemplateBlock(ITemplateElement[] body) {
        this.body = body;
    }

    public void setBody(ITemplateElement[] body) {
        this.body = body;
    }

    public int getBodyElementCount() {
        return null == this.body ? 0 : this.body.length;
    }

    public ITemplateElement getBodyElement(int index) {
        if (null == this.body) {
            throw new IndexOutOfBoundsException();
        }
        return this.body[index];
    }

    @Override
    public Object accept(IVisitor visitor) throws VilException {
        return visitor.visitTemplateBlock(this);
    }

    @Override
    public boolean isBlock() {
        return true;
    }

    @Override
    public TypeDescriptor<?> inferType() throws VilException {
        ITemplateElement last = this.getTypeDefiningElement();
        TypeDescriptor<?> result = null == last ? TypeRegistry.voidType() : last.inferType();
        return result;
    }

    protected ITemplateElement getTypeDefiningElement() {
        ITemplateElement result = null == this.body || 0 == this.body.length ? null : this.body[this.body.length - 1];
        return result;
    }

    @Override
    protected void setParent(ILanguageElement parent) {
        super.setParent(parent);
        if (null != this.body) {
            for (int b = 0; b < this.getBodyElementCount(); ++b) {
                ITemplateElement elt = this.getBodyElement(b);
                if (!(elt instanceof AbstractTemplateElement)) continue;
                ((AbstractTemplateElement)elt).setParent(this);
            }
        }
    }

    @Override
    public boolean endsWithContentStatement() {
        ITemplateElement elt = this.getTypeDefiningElement();
        return null != elt && elt.endsWithContentStatement();
    }
}

