/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.basics.modelManagement.AvailableModels;
import net.ssehub.easy.basics.modelManagement.IndentationConfiguration;
import net.ssehub.easy.basics.modelManagement.ModelImport;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.ModelManagementException;
import net.ssehub.easy.instantiation.core.model.artifactModel.ArtifactTypes;
import net.ssehub.easy.instantiation.core.model.artifactModel.IArtifact;
import net.ssehub.easy.instantiation.core.model.common.Compound;
import net.ssehub.easy.instantiation.core.model.common.ExecutionVisitor;
import net.ssehub.easy.instantiation.core.model.common.IResolvableModel;
import net.ssehub.easy.instantiation.core.model.common.ITerminatable;
import net.ssehub.easy.instantiation.core.model.common.ModelCallExpression;
import net.ssehub.easy.instantiation.core.model.common.Typedef;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.ConstantExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionParserRegistry;
import net.ssehub.easy.instantiation.core.model.expressions.IArgumentProvider;
import net.ssehub.easy.instantiation.core.model.expressions.IExpressionParser;
import net.ssehub.easy.instantiation.core.model.expressions.ResolvableOperationCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.StringReplacer;
import net.ssehub.easy.instantiation.core.model.templateModel.AlternativeStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentAlternativeExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentImportExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentLoopExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.ContentVarDeclExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.Def;
import net.ssehub.easy.instantiation.core.model.templateModel.FlushStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.FormattingConfiguration;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateElement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateLangVisitor;
import net.ssehub.easy.instantiation.core.model.templateModel.ITracer;
import net.ssehub.easy.instantiation.core.model.templateModel.InContentExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.IndentationUtils;
import net.ssehub.easy.instantiation.core.model.templateModel.JavaExtension;
import net.ssehub.easy.instantiation.core.model.templateModel.LoopStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.NoTracer;
import net.ssehub.easy.instantiation.core.model.templateModel.Resolver;
import net.ssehub.easy.instantiation.core.model.templateModel.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.templateModel.SwitchStatement;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateBlock;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateCallExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.templateModel.WhileStatement;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.EnumValue;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.varModel.model.values.ContainerValue;
import net.ssehub.easy.varModel.model.values.NullValue;

public class TemplateLangExecution
extends ExecutionVisitor<Template, Def, VariableDeclaration, Resolver>
implements ITemplateLangVisitor,
ITerminatable {
    public static final ExpressionParserRegistry.ILanguage<Resolver> LANGUAGE = new ExpressionParserRegistry.ILanguage<Resolver>(){

        @Override
        public String getName() {
            return "VTL";
        }
    };
    public static final String DEFAULT_MAIN_TEMPLATE = "main";
    public static final String PARAM_CONFIG = "config";
    public static final String PARAM_TARGET = "target";
    public static final String INTERNAL_PARAM_PREFIX = "$$";
    public static final String PARAM_CONFIG_SURE = "$$config";
    public static final String PARAM_TARGET_SURE = "$$target";
    private static final List<JavaExtension> DEFAULT_EXTENSIONS = new ArrayList<JavaExtension>();
    private static final String EMPTY_CONTENT = "\u0000\u0001\u0000";
    private RuntimeEnvironment environment;
    private Writer mainOut;
    private PrintWriter out;
    private String mainName;
    private ITracer tracer;
    private boolean stop = false;
    private int contentNestingLevel;
    private int lastContentNestingLevel = -1;
    private boolean lastContentFormatted = false;
    private Stack<String> defContentStack = new Stack();
    private ContentStatement lastContent = null;
    private ContentStatement.LineEndType lastContentLineEndType = ContentStatement.LineEndType.DEFAULT;

    public TemplateLangExecution(ITracer tracer, Writer out, Map<String, Object> parameter) {
        this(tracer, out, DEFAULT_MAIN_TEMPLATE, parameter);
    }

    public TemplateLangExecution(ITracer tracer, Writer out, String mainName, Map<String, Object> parameter) {
        super(new RuntimeEnvironment(), tracer, parameter);
        this.environment = (RuntimeEnvironment)this.getRuntimeEnvironment();
        this.mainOut = out;
        this.out = new PrintWriter(out);
        this.mainName = mainName;
        this.tracer = tracer;
        this.enableArtifactAutoStoreOnParameters(false);
    }

    TemplateLangExecution(RuntimeEnvironment environment) {
        super(environment, NoTracer.INSTANCE, new HashMap<String, Object>());
        this.environment = environment;
        this.out = new PrintWriter(new Writer(){

            @Override
            public void close() throws IOException {
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void write(char[] arg0, int arg1, int arg2) throws IOException {
            }
        });
        this.mainName = DEFAULT_MAIN_TEMPLATE;
        this.tracer = NoTracer.INSTANCE;
    }

    @Override
    public void release(boolean releaseDefault) {
        this.enableArtifactAutoStoreOnParameters(true);
        super.release(releaseDefault);
    }

    public static void registerDefaultExtension(Class<?> extension) {
        if (null != extension) {
            EASyLoggerFactory.EASyLogger logger = EASyLoggerFactory.INSTANCE.getLogger(TemplateLangExecution.class, "net.ssehub.easy.instantiation.core");
            try {
                DEFAULT_EXTENSIONS.add(new JavaExtension(extension, TypeRegistry.DEFAULT));
                logger.info("registered default VTL extension " + extension.getName());
            }
            catch (VilException e) {
                logger.exception(e);
            }
        }
    }

    public static int getDefaultExtensionCount() {
        return DEFAULT_EXTENSIONS.size();
    }

    public static JavaExtension getDefaultExtension(int index) {
        return DEFAULT_EXTENSIONS.get(index);
    }

    @Override
    public Object visitTemplate(Template template) throws VilException {
        this.environment.switchContext(template);
        this.tracer.visitTemplate(template);
        this.visitModelHeader(template);
        Def main = null;
        for (int d = 0; null == main && d < template.getDefCount(); ++d) {
            Def def = template.getDef(d);
            if (!def.getName().equals(this.mainName) || template.getParameterCount() != def.getParameterCount()) continue;
            main = def;
            for (int p = 0; null != main && p < template.getParameterCount(); ++p) {
                if (template.getParameter(p).getType().isAssignableFrom(def.getParameter(p).getType())) continue;
                main = null;
            }
        }
        if (null == main) {
            throw new VilException("no '" + this.mainName + "' template found with suitable parameters", 50003);
        }
        Object result = this.executeMain(template, main);
        this.tracer.visitedTemplate(template);
        return result;
    }

    @Override
    public Object visitDef(Def def) throws VilException {
        Object result;
        this.defContentStack.push("");
        if (def.isPlaceholder()) {
            result = null;
        } else {
            this.tracer.visitDef(def, this.environment);
            result = this.visitTemplateBlock(def);
            if (null != this.lastContent && this.lastContent.needsLineEnd(0 == this.contentNestingLevel)) {
                this.appendContent(this.getLineEnd());
            }
            this.lastContent = null;
            this.tracer.visitedDef(def, this.environment, result);
        }
        String content = this.defContentStack.pop();
        if (0 == this.contentNestingLevel) {
            if (this.defContentStack.isEmpty()) {
                this.out.print(content);
            } else {
                this.appendContent(content);
            }
        }
        return result;
    }

    private void increaseIndentation(ITemplateElement element) {
        if (!element.isBlock()) {
            this.environment.increaseIndentation();
        }
    }

    private void decreaseIndentation(ITemplateElement element) {
        if (!element.isBlock()) {
            this.environment.decreaseIndentation();
        }
    }

    @Override
    public Object visitTemplateBlock(TemplateBlock block) throws VilException {
        boolean ok = true;
        boolean returns = !TypeRegistry.voidType().isSame(block.inferType());
        Object value = null;
        Object lastValue = null;
        this.environment.increaseIndentation();
        int count = block.getBodyElementCount();
        for (int e = 0; ok && !this.stop && e < count; ++e) {
            ITemplateElement elt = block.getBodyElement(e);
            value = elt.accept(this);
            if (elt.isLoop() && elt.endsWithContentStatement() && value == EMPTY_CONTENT && lastValue instanceof String) {
                value = lastValue;
            }
            if ((!returns || returns && e + 1 < count) && this.mayFail(elt)) {
                ok = this.checkConditionResult(value, block, ExecutionVisitor.ConditionTest.DONT_CARE);
            }
            if (!ok) {
                this.tracer.failedAt(block.getBodyElement(e));
                value = null;
            }
            lastValue = value;
        }
        this.environment.decreaseIndentation();
        return value;
    }

    @Override
    public Object visitAlternative(AlternativeStatement alternative) throws VilException {
        Object value = null;
        Expression cond = alternative.getCondition();
        Object condValue = cond.accept(this);
        if (this.checkConditionResult(condValue, cond, ExecutionVisitor.ConditionTest.DONT_CARE)) {
            ITemplateElement ifStmt = alternative.getIfStatement();
            this.increaseIndentation(ifStmt);
            this.tracer.visitAlternative(true);
            value = ifStmt.accept(this);
            this.decreaseIndentation(ifStmt);
            value = this.checkContentStatement(value, null, alternative.getIfStatement());
        } else if (null != alternative.getElseStatement()) {
            ITemplateElement elseStmt = alternative.getElseStatement();
            this.increaseIndentation(elseStmt);
            this.tracer.visitAlternative(false);
            value = elseStmt.accept(this);
            this.decreaseIndentation(elseStmt);
            value = this.checkContentStatement(value, null, alternative.getElseStatement());
        } else {
            boolean isIfContentStatement = TemplateLangExecution.isContentStatement(alternative.getIfStatement());
            if (isIfContentStatement) {
                value = !this.defContentStack.isEmpty() ? this.defContentStack.peek() : "";
            }
            value = this.checkContentStatement(value, null, isIfContentStatement);
        }
        return value;
    }

    private String getSeparatorFromExpression(Expression expression) throws VilException {
        String separator = null != expression ? StringValueHelper.getStringValue(expression.accept(this), null) : null;
        return separator;
    }

    @Override
    public Object visitLoop(LoopStatement loop) throws VilException {
        Expression expr = loop.getContainerExpression();
        Object object = this.convertToContainer(expr, expr.accept(this), "loop");
        String separator = this.getSeparatorFromExpression(loop.getSeparatorExpression());
        String finalSeparator = this.getSeparatorFromExpression(loop.getFinalSeparatorExpression());
        Object bodyResult = NullValue.VALUE;
        if (object instanceof net.ssehub.easy.instantiation.core.model.vilTypes.Collection) {
            VariableDeclaration iterVar = loop.getIteratorVariable();
            this.environment.pushLevel();
            net.ssehub.easy.instantiation.core.model.vilTypes.Collection collection = (net.ssehub.easy.instantiation.core.model.vilTypes.Collection)object;
            Iterator iter = collection.iterator();
            this.tracer.visitLoop(iterVar);
            while (iter.hasNext() && !this.stop) {
                Object value = iter.next();
                this.environment.addValue(iterVar, value);
                this.tracer.valueDefined(iterVar, null, value);
                ITemplateElement loopStmt = loop.getLoopStatement();
                this.increaseIndentation(loopStmt);
                bodyResult = loopStmt.accept(this);
                this.decreaseIndentation(loopStmt);
                if (null != separator && iter.hasNext()) {
                    this.appendContent(separator);
                }
                if (null == finalSeparator || iter.hasNext()) continue;
                this.appendContent(finalSeparator);
            }
            this.tracer.visitedLoop(iterVar);
            this.environment.popLevel();
        } else if (null != object) {
            throw new VilException("loop must iterate over collection", 70001);
        }
        return this.checkContentStatement(bodyResult, NullValue.VALUE, loop.getLoopStatement());
    }

    private Object checkContentStatement(Object currentValue, Object noValue, ITemplateElement check) {
        return this.checkContentStatement(currentValue, noValue, TemplateLangExecution.isContentStatement(check));
    }

    private Object checkContentStatement(Object currentValue, Object noValue, boolean isContentStatement) {
        Object result = currentValue;
        if (noValue == currentValue && isContentStatement) {
            result = EMPTY_CONTENT;
        }
        return result;
    }

    private static final boolean isContentStatement(ITemplateElement elt) {
        return null == elt ? false : elt.endsWithContentStatement();
    }

    private void appendContent(String string) {
        String topContent = this.defContentStack.pop();
        topContent = null == topContent ? string : topContent + string;
        this.defContentStack.push(topContent);
    }

    @Override
    public Object visitSwitch(SwitchStatement swtch) throws VilException {
        this.environment.pushLevel();
        Object select = swtch.getSwitchExpression().accept(this);
        this.environment.addValue(swtch.getImplicitVariable(), select);
        int found = -1;
        Object value = null;
        for (int a = 0; found < 0 && a < swtch.getAlternativeCount(); ++a) {
            SwitchStatement.Alternative alt = swtch.getAlternative(a);
            boolean take = alt.isDefault();
            if (!take) {
                Expression cond = alt.getCondition();
                Object condValue = cond.accept(this);
                take = this.equals(condValue, select);
            }
            if (!take) continue;
            value = alt.getValue().accept(this);
            found = a;
        }
        this.tracer.visitedSwitch(select, found, value);
        this.environment.popLevel();
        return value;
    }

    private boolean equals(Object condValue, Object exprValue) {
        boolean result = condValue.equals(exprValue);
        if (!result && exprValue instanceof IvmlElement) {
            IvmlElement iElt = (IvmlElement)exprValue;
            if (condValue instanceof String) {
                result = condValue.equals(iElt.getStringValue());
            } else if (condValue instanceof Integer) {
                result = condValue.equals(iElt.getIntegerValue());
            } else if (condValue instanceof Boolean) {
                result = condValue.equals(iElt.getBooleanValue());
            } else if (condValue instanceof Double) {
                result = condValue.equals(iElt.getRealValue());
            } else if (condValue instanceof EnumValue) {
                result = condValue.equals(iElt.getEnumValue());
            }
        }
        return result;
    }

    @Override
    public Object visitContentStatement(ContentStatement cnt) throws VilException {
        ++this.contentNestingLevel;
        this.lastContentFormatted = false;
        if (null != this.lastContent && this.lastContent.needsLineEnd(true)) {
            this.appendContent(this.getLineEnd());
        }
        this.lastContent = null;
        String content = (String)cnt.getContent().accept(this);
        if (null != content) {
            content = TemplateLangExecution.cleanLineEnd(content, true);
        }
        if (null != content) {
            String topContent;
            int indentation = this.environment.getIndentation();
            if (indentation > 0) {
                int indent = indentation + this.getAdditionalIndentation();
                content = IndentationUtils.removeIndentation(content, indent, this.getTabEmulation());
            }
            int forced = 0;
            if (null != cnt.getIndentExpression()) {
                Object val = cnt.getIndentExpression().accept(this);
                if (val instanceof Integer) {
                    forced = (Integer)val;
                    if (forced > 0) {
                        content = IndentationUtils.insertIndentation(content, forced, this.contentNestingLevel > 1);
                        this.lastContentFormatted = true;
                    }
                } else {
                    throw new VilException("indentation value is no integer", 70001);
                }
            }
            topContent = 0 == (topContent = this.defContentStack.pop()).length() ? content : IndentationUtils.appendWithLastIndentation(topContent, content, this.contentNestingLevel == 1 || this.lastContentNestingLevel == this.contentNestingLevel);
            this.defContentStack.push(topContent);
            content = topContent;
        }
        this.lastContentNestingLevel = this.contentNestingLevel--;
        this.lastContent = cnt;
        this.lastContentLineEndType = cnt.getLineEndType();
        return content;
    }

    @Override
    protected boolean lastContentReplaceEmptyLine() {
        boolean result = this.lastContentLineEndType == ContentStatement.LineEndType.NO_LINE_END;
        this.lastContentLineEndType = null;
        return result;
    }

    private static String cleanLineEnd(String content, boolean includeIndentation) {
        int pos;
        do {
            int start;
            int end;
            if ((pos = content.indexOf(EMPTY_CONTENT)) < 0) continue;
            if (includeIndentation) {
                for (end = pos + EMPTY_CONTENT.length(); end < content.length() && IndentationUtils.isLineEnd(content.charAt(end)); ++end) {
                }
            }
            if ((start = pos) > 0) {
                --start;
                if (includeIndentation) {
                    while (start >= 0 && IndentationUtils.isIndentationChar(content.charAt(start))) {
                        --start;
                    }
                }
                if (start < 0) {
                    start = 0;
                }
            }
            content = content.substring(0, start) + content.substring(end);
        } while (pos >= 0);
        return content;
    }

    @Override
    protected String appendInCompositeExpression(String s1, Expression e1, Object v1, String s2, Expression e2) {
        String result;
        boolean format = false;
        boolean clear = false;
        boolean isS1 = false;
        IndentationConfiguration config = this.environment.getIndentationConfiguration();
        if (e1 instanceof ConstantExpression && e2 instanceof TemplateCallExpression) {
            boolean bl = format = !this.lastContentFormatted;
            if (format && s1.length() > 0) {
                char last = s1.charAt(s1.length() - 1);
                format = IndentationUtils.isLineEnd(last) || IndentationUtils.isIndentationChar(last);
            }
        } else if (e2 instanceof InContentExpression) {
            clear = null != config && s2.isEmpty();
        } else if (e1 instanceof InContentExpression && v1.toString().isEmpty() && IndentationUtils.isIndentationString(s2)) {
            format = false;
            isS1 = true;
        }
        String hint = e2.getFormattingHint();
        boolean clearLE = false;
        if (null != hint) {
            if ("e".equals(hint)) {
                if (s2.length() == 0) {
                    clear = true;
                    clearLE = true;
                } else {
                    format = true;
                }
            } else if ("<".equals(hint)) {
                s1 = IndentationUtils.removeLastIndentation(s1, false);
                clear = false;
                format = false;
                isS1 = false;
            }
        }
        if (format) {
            int indent;
            int indentation = this.environment.getIndentation();
            if ((indentation -= this.getIndentationStep()) > 0 && IndentationUtils.allLinesStartWith(s2, indent = indentation + this.getAdditionalIndentation())) {
                s2 = IndentationUtils.removeIndentation(s2, indent, this.getTabEmulation());
            }
            result = IndentationUtils.appendWithLastIndentation(s1, s2, false);
        } else {
            result = clear ? IndentationUtils.removeLastIndentation(s1, clearLE) : (isS1 ? s1 : super.appendInCompositeExpression(s1, e1, v1, s2, e2));
        }
        return result;
    }

    private int getAdditionalIndentation() {
        IndentationConfiguration icfg = this.environment.getIndentationConfiguration();
        return null == icfg ? 0 : icfg.getAdditional();
    }

    private int getTabEmulation() {
        IndentationConfiguration icfg = this.environment.getIndentationConfiguration();
        return null == icfg ? 0 : icfg.getTabEmulation();
    }

    private int getIndentationStep() {
        IndentationConfiguration icfg = this.environment.getIndentationConfiguration();
        return null == icfg ? 0 : icfg.getIndentationStep();
    }

    private String getLineEnd() {
        FormattingConfiguration cfg = null;
        IResolvableModel model = this.environment.getContextModel();
        if (model instanceof Template) {
            Template template = (Template)model;
            cfg = template.getFormattingConfiguration();
        }
        return FormattingConfiguration.getLineEnding(cfg);
    }

    @Override
    public Object visitConstantExpression(ConstantExpression cst) throws VilException {
        Object result = cst.getValue();
        if (result instanceof String) {
            result = StringReplacer.substitute(result.toString(), new Resolver(this.environment), this.getExpressionParser(), this, null);
        }
        return result;
    }

    @Override
    public Object visitJavaExtension(JavaExtension ext) throws VilException {
        return null;
    }

    @Override
    public Object visitTemplateCallExpression(TemplateCallExpression call) throws VilException {
        Object result;
        if (this.stop) {
            result = null;
        } else {
            int indentation = this.environment.getIndentation();
            this.environment.setIndentationSteps(1);
            result = this.visitModelCallExpression(call);
            this.environment.setIndentation(indentation);
        }
        return result;
    }

    @Override
    protected Object executeModelCall(Def def) throws VilException {
        return def.accept(this);
    }

    @Override
    protected ModelCallExpression<VariableDeclaration, Template, Def> createModelCall(Template model, Def operation, CallArgument ... arguments) throws VilException {
        return new TemplateCallExpression(model, operation, arguments);
    }

    @Override
    protected Def dynamicDispatch(Def operation, Object[] args, IArgumentProvider argumentProvider, boolean enableParentScope) {
        return AbstractCallExpression.dynamicDispatch(operation, args, Def.class, this.environment.getTypeRegistry(), argumentProvider, enableParentScope ? this.environment.getMostSpecificContextModel() : null);
    }

    @Override
    protected void handleParameterInSequence(IResolvableModel<VariableDeclaration, Template> model, Map<String, VariableDeclaration> varMap) throws VilException {
        if (model.getParameterCount() >= 2) {
            boolean ok = IvmlTypes.configurationType().isAssignableFrom(((VariableDeclaration)model.getParameter(0)).getType());
            if (ok &= ArtifactTypes.artifactType().isAssignableFrom(((VariableDeclaration)model.getParameter(1)).getType())) {
                this.assignModelParameter(model, model);
                for (int p = 0; p < 2; ++p) {
                    varMap.remove(((VariableDeclaration)model.getParameter(p)).getName());
                }
            }
        }
        varMap.remove(PARAM_CONFIG_SURE);
        varMap.remove(PARAM_TARGET_SURE);
    }

    @Override
    protected void assignModelParameter(IResolvableModel<VariableDeclaration, Template> targetModel, IResolvableModel<VariableDeclaration, Template> srcModel) throws VilException {
        if (srcModel.getParameterCount() >= 1) {
            this.setModelArgument((VariableDeclaration)srcModel.getParameter(0), this.getParameter(PARAM_CONFIG_SURE));
        }
        if (srcModel.getParameterCount() >= 2) {
            this.setModelArgument((VariableDeclaration)srcModel.getParameter(1), this.getParameter(PARAM_TARGET_SURE));
        }
        this.evaluateModelParameter(targetModel, srcModel, 2);
    }

    @Override
    protected IExpressionParser<Resolver> getExpressionParser() {
        return ExpressionParserRegistry.getExpressionParser(LANGUAGE);
    }

    @Override
    public Object visitResolvableOperationCallExpression(ResolvableOperationCallExpression ex) throws VilException {
        Object result;
        Object val = this.environment.getValue(ex.getVariable());
        int indentation = this.environment.getIndentation();
        this.environment.setIndentationSteps(1);
        if (val instanceof Def) {
            Def def = (Def)val;
            result = this.proceedModelCall(def, (Template)this.environment.getContextModel(), ex, ex.isPlaceholder(), false);
        } else {
            result = super.visitResolvableOperationCallExpression(ex);
        }
        this.environment.setIndentation(indentation);
        return result;
    }

    @Override
    public Object visitTypedef(Typedef typedef) throws VilException {
        return null;
    }

    @Override
    public Object visitWhile(WhileStatement stmt) throws VilException {
        Expression condition = stmt.getConditionExpression();
        boolean executeLoop = false;
        this.environment.pushLevel();
        Object bodyResult = NullValue.VALUE;
        do {
            Object conditionResult;
            boolean bl = executeLoop = (conditionResult = condition.accept(this)) instanceof Boolean && (Boolean)conditionResult != false;
            if (!executeLoop) continue;
            this.tracer.visitWhileBody();
            ITemplateElement loopStmt = stmt.getLoopStatement();
            this.increaseIndentation(loopStmt);
            bodyResult = loopStmt.accept(this);
            if (null == bodyResult) {
                executeLoop = false;
            }
            this.decreaseIndentation(loopStmt);
            this.tracer.visitedWhileBody();
        } while (executeLoop && !this.stop);
        this.environment.popLevel();
        return this.checkContentStatement(bodyResult, NullValue.VALUE, stmt.getLoopStatement());
    }

    @Override
    public void stop() {
        this.stop = true;
    }

    @Override
    public Object visitFlush(FlushStatement stmt) throws VilException {
        this.tracer.visitFlush();
        this.storeContent();
        this.tracer.visitedFlush();
        return null;
    }

    public void storeContent() throws VilException {
        Object tgt = this.getParameter(PARAM_TARGET_SURE);
        if (null == tgt) {
            tgt = this.getParameter(PARAM_TARGET);
        }
        if (tgt instanceof IArtifact && this.mainOut instanceof StringWriter) {
            TemplateLangExecution.storeContent((IArtifact)tgt, (StringWriter)this.mainOut);
        }
    }

    public static void storeContent(IArtifact target, StringWriter out) throws VilException {
        String tmp = out.toString();
        if (tmp.length() > 0) {
            target.getText().setText(tmp);
        }
        target.store();
    }

    @Override
    public Object visitContentAlternativeExpression(ContentAlternativeExpression ex) throws VilException {
        String result = null;
        Object cond = ex.getCondition().accept(this);
        if (Boolean.TRUE.equals(cond)) {
            result = this.evaluateContentExpression(ex.thenEx());
        } else if (Boolean.FALSE.equals(cond)) {
            result = ex.getElseExpressionsCount() > 0 ? this.evaluateContentExpression(ex.elseEx()) : "";
        }
        return result;
    }

    private String evaluateSeparator(Expression ex, String deflt) throws VilException {
        String separator = deflt;
        if (null != ex) {
            Object tmp = ex.accept(this);
            separator = null == tmp ? deflt : tmp.toString();
        }
        return separator;
    }

    @Override
    public Object visitContentLoopExpression(ContentLoopExpression ex) throws VilException {
        String result = null;
        String separator = this.evaluateSeparator(ex.getSeparator(), "");
        String endSeparator = this.evaluateSeparator(ex.getEndSeparator(), "");
        Object init = ex.getInit().accept(this);
        Iterator<Object> iter = init instanceof net.ssehub.easy.instantiation.core.model.vilTypes.Collection ? ((net.ssehub.easy.instantiation.core.model.vilTypes.Collection)init).iterator() : (init instanceof Collection ? ((Collection)init).iterator() : (init instanceof ContainerValue ? ((ContainerValue)init).iterator() : null));
        if (null != iter) {
            result = "";
            this.environment.pushLevel();
            VariableDeclaration decl = ex.getIterator();
            this.environment.addValue(decl, null);
            while (iter.hasNext()) {
                this.environment.setValue(decl, iter.next());
                String tmp = this.evaluateContentExpression(ex);
                if (null == tmp) break;
                if (result.length() == 0) {
                    result = tmp;
                    continue;
                }
                result = result + separator + tmp;
            }
            this.environment.popLevel();
            if (result.length() > 0) {
                result = result + endSeparator;
            }
        }
        return result;
    }

    @Override
    public Object visitContentVarDeclExpression(ContentVarDeclExpression ex) throws VilException {
        VariableDeclaration var = ex.getVariable();
        Object value = null != var.getExpression() ? var.getExpression().accept(this) : null;
        this.environment.addValue(var, value);
        return "";
    }

    @Override
    public Object visitContentImportExpression(ContentImportExpression ex) throws VilException {
        try {
            Template resolved;
            Template current = (Template)this.environment.getContextModel();
            AvailableModels<Template> available = TemplateModel.INSTANCE.availableModels();
            ModelInfo<Template> currentInfo = available.getModelInfo(current);
            URI baseUri = null;
            if (null != currentInfo) {
                baseUri = currentInfo.getLocation();
            }
            if (null == baseUri) {
                baseUri = this.getFallbackBaseURI();
            }
            if (null != (resolved = (Template)TemplateModel.INSTANCE.resolve(ex.getTemplate(), ex.getVersionRestriction(), baseUri, this.environment))) {
                ModelImport<Template> imp = new ModelImport<Template>(ex.getTemplate());
                imp.setResolved(resolved);
                current.addRuntimeImport(imp);
            }
        }
        catch (ModelManagementException e) {
            throw new VilException(e);
        }
        return "";
    }

    protected URI getFallbackBaseURI() {
        return null;
    }

    @Override
    public Object visitCompound(Compound compound) throws VilException {
        return null;
    }
}

