/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.templateModel;

import java.io.StringWriter;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.instantiation.core.model.common.Advice;
import net.ssehub.easy.instantiation.core.model.common.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.IRuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.expressions.VarModelIdentifierExpression;
import net.ssehub.easy.instantiation.core.model.templateModel.ITracer;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateDescriptor;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateLangExecution;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.Configuration;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlElement;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypeResolver;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;
import net.ssehub.easy.varModel.model.Project;

public class TemplateSubstitutionExecution
extends TemplateLangExecution {
    private URI baseURI;

    public TemplateSubstitutionExecution(ITracer tracer, String modelName, boolean addAdvice, Configuration config, URI baseURI) throws VilException {
        super(tracer, new StringWriter(), TemplateSubstitutionExecution.createParams(config));
        this.baseURI = baseURI;
        IRuntimeEnvironment environment = this.getRuntimeEnvironment();
        TypeRegistry registry = new TypeRegistry(TypeRegistry.DEFAULT);
        TemplateDescriptor desc = new TemplateDescriptor();
        if (addAdvice) {
            Advice[] advices = new Advice[1];
            Project prj = config.getConfiguration().getProject();
            advices[0] = new Advice(prj.getName(), null, prj);
            desc.setAdvices(advices);
            registry.addTypeResolver(new IvmlTypeResolver(prj, registry));
        }
        Template model = new Template(modelName, null, desc, registry);
        ((RuntimeEnvironment)environment).switchContext(model);
        ((RuntimeEnvironment)environment).addValue(new VariableDeclaration("config", IvmlTypes.configurationType()), config);
    }

    private static Map<String, Object> createParams(Configuration config) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("config", config);
        params.put("target", null);
        return params;
    }

    @Override
    public Object visitVarModelIdentifierExpression(VarModelIdentifierExpression identifier) throws VilException {
        Object res = super.visitVarModelIdentifierExpression(identifier);
        if (res instanceof IvmlElement) {
            res = ((IvmlElement)res).getValue();
        }
        return res;
    }

    @Override
    protected URI getFallbackBaseURI() {
        return this.baseURI;
    }
}

