/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.tracing;

import java.io.StringWriter;
import java.util.HashMap;
import java.util.Map;
import net.ssehub.easy.basics.modelManagement.ModelInfo;
import net.ssehub.easy.basics.modelManagement.Version;
import net.ssehub.easy.instantiation.core.model.artifactModel.IFileSystemArtifact;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildModel;
import net.ssehub.easy.instantiation.core.model.buildlangModel.BuildlangWriter;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IBuildlangElement;
import net.ssehub.easy.instantiation.core.model.buildlangModel.IEnumeratingLoop;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Rule;
import net.ssehub.easy.instantiation.core.model.buildlangModel.Script;
import net.ssehub.easy.instantiation.core.model.common.ITraceFilter;
import net.ssehub.easy.instantiation.core.model.common.NoTraceFilter;
import net.ssehub.easy.instantiation.core.model.common.RuntimeEnvironment;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.execution.IInstantiatorTracer;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractTracerBase;
import net.ssehub.easy.instantiation.core.model.expressions.CallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.templateModel.Def;
import net.ssehub.easy.instantiation.core.model.templateModel.ITemplateLangElement;
import net.ssehub.easy.instantiation.core.model.templateModel.ITracer;
import net.ssehub.easy.instantiation.core.model.templateModel.Template;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateLangWriter;
import net.ssehub.easy.instantiation.core.model.templateModel.TemplateModel;
import net.ssehub.easy.instantiation.core.model.templateModel.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.tracing.TracerHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.Constants;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

public abstract class AbstractVilTracer
extends AbstractTracerBase
implements net.ssehub.easy.instantiation.core.model.buildlangModel.ITracer,
ITracer,
IInstantiatorTracer {
    private static final String INDENTATION_STEP = "  ";
    private String indentation = "";
    private boolean emitTraceText;
    private boolean enable = true;
    private ITraceFilter filter = NoTraceFilter.INSTANCE;
    private boolean templateDefVisited = false;

    protected AbstractVilTracer() {
        this(false);
    }

    protected AbstractVilTracer(boolean emitTraceText) {
        this.emitTraceText = emitTraceText;
    }

    @Override
    public void setTraceFilter(ITraceFilter filter) {
        if (null != filter) {
            this.filter = filter;
        }
    }

    @Override
    public ITraceFilter getTraceFilter() {
        return this.filter;
    }

    private void increaseIndentation() {
        this.indentation = this.indentation + INDENTATION_STEP;
    }

    private void decreaseIndentation() {
        int pos = this.indentation.length() - INDENTATION_STEP.length();
        if (pos > 0) {
            this.indentation = this.indentation.substring(0, pos);
        }
    }

    protected void write(String msg) {
        if (this.enable) {
            this.writeImpl(this.indentation + msg);
        }
    }

    protected abstract void writeImpl(String var1);

    @Override
    public void trace(String text) {
        if (this.emitTraceText) {
            this.write(text);
        }
    }

    @Override
    public void valueDefined(net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var, FieldDescriptor field, Object value) {
    }

    @Override
    public void traceExecutionException(VilException exception) {
        if (this.filter.isEnabled(ITraceFilter.LanguageElementKind.FAILURE)) {
            this.write("exception " + exception.getMessage());
        }
    }

    private static Map<?, ?> cleanImplicitFromOptionalArgument(Map<?, ?> argument) {
        HashMap cleaned = new HashMap();
        for (Map.Entry<?, ?> entry : argument.entrySet()) {
            if (Constants.IMPLICIT_PARAMETER.contains(entry.getKey())) continue;
            cleaned.put(entry.getKey(), entry.getValue());
        }
        if (cleaned.isEmpty()) {
            cleaned = null;
        }
        return cleaned;
    }

    @Override
    public void visitedCallExpression(OperationDescriptor descriptor, CallExpression.CallType callType, Object[] args, Object result) {
    }

    @Override
    public void visitingCallExpression(OperationDescriptor descriptor, CallExpression.CallType callType, Object[] args) {
        if (TracerHelper.trace(descriptor) && this.filter.isEnabled(ITraceFilter.LanguageElementKind.OPERATION_EXECUTION)) {
            String msg = "call " + descriptor.getName();
            if (descriptor.isConstructor() && null != descriptor.getReturnType()) {
                msg = msg + " " + ((TypeDescriptor)descriptor.getReturnType()).getVilName();
            }
            msg = msg + "(";
            if (null != args) {
                Map optionalArgsOrig = null;
                int lastArgPos = args.length - 1;
                int argsLength = args.length;
                if (descriptor.acceptsImplicitParameters() && lastArgPos >= 0) {
                    Object tmp = args[lastArgPos];
                    if (tmp instanceof Map) {
                        optionalArgsOrig = (Map)tmp;
                        args[lastArgPos] = AbstractVilTracer.cleanImplicitFromOptionalArgument(optionalArgsOrig);
                    }
                    if (null == args[lastArgPos]) {
                        --argsLength;
                    }
                }
                for (int i = 0; i < argsLength; ++i) {
                    if (i > 0) {
                        msg = msg + ", ";
                    }
                    msg = msg + TracerHelper.toString(args[i], true);
                }
                if (null != optionalArgsOrig) {
                    args[lastArgPos] = optionalArgsOrig;
                }
            }
            msg = msg + ")";
            this.write(msg);
        }
    }

    @Override
    public void visitRule(Rule rule, RuntimeEnvironment<?, ?> environment) {
        if (this.filter.isEnabled(ITraceFilter.LanguageElementKind.FUNCTION_EXECUTION)) {
            String msg = "execute " + rule.getSignature() + " with (";
            for (int p = 0; p < rule.getParameterCount(); ++p) {
                try {
                    if (p > 0) {
                        msg = msg + ", ";
                    }
                    msg = msg + TracerHelper.toString(environment.getValue(rule.getParameter(p)), true);
                    continue;
                }
                catch (VilException vilException) {
                    // empty catch block
                }
            }
            msg = msg + ")";
            this.write(msg);
            this.increaseIndentation();
        }
    }

    @Override
    public void visitedRule(Rule rule, RuntimeEnvironment<?, ?> environment, Object result) {
        if (this.filter.isEnabled(ITraceFilter.LanguageElementKind.FUNCTION_EXECUTION)) {
            this.decreaseIndentation();
        }
    }

    @Override
    public void visitLoop(IEnumeratingLoop map, RuntimeEnvironment<?, ?> environment) {
    }

    @Override
    public void visitIteratorAssignment(IEnumeratingLoop loop, net.ssehub.easy.instantiation.core.model.buildlangModel.VariableDeclaration var, Object value) {
    }

    @Override
    public void visitedLoop(IEnumeratingLoop loop, RuntimeEnvironment<?, ?> environment) {
    }

    @Override
    public Collection<?> adjustSequenceForMap(Collection<?> collection) {
        return collection;
    }

    @Override
    public Collection<Object> adjustSequenceForJoin(Collection<Object> collection) {
        return collection;
    }

    @Override
    public void visitSystemCall(String[] args) {
        if (this.filter.isEnabled(ITraceFilter.LanguageElementKind.SYSCALL_EXECUTION) && args.length > 0) {
            String msg = "syscall";
            for (int i = 0; i < args.length; ++i) {
                if (i > 0) {
                    msg = msg + " ";
                }
                msg = msg + TracerHelper.toString(args[i], false);
            }
            this.write(msg);
        }
    }

    @Override
    public void visitingInstantiator(String name) {
    }

    @Override
    public void visitedInstantiator(String name, Object result) {
    }

    @Override
    public void failedAt(Expression expression) {
        if (this.filter.isEnabled(ITraceFilter.LanguageElementKind.FAILURE)) {
            StringWriter out = new StringWriter();
            BuildlangWriter writer = new BuildlangWriter(out);
            try {
                expression.accept(writer);
            }
            catch (VilException vilException) {
                // empty catch block
            }
            this.write("failed expression: " + out);
        }
    }

    @Override
    public void failedAt(IBuildlangElement element) {
        if (this.filter.isEnabled(ITraceFilter.LanguageElementKind.FAILURE)) {
            StringWriter out = new StringWriter();
            BuildlangWriter writer = new BuildlangWriter(out);
            try {
                element.accept(writer);
            }
            catch (VilException vilException) {
                // empty catch block
            }
            this.write("failed at: " + out);
        }
    }

    @Override
    public void visitScript(Script script, RuntimeEnvironment<?, ?> environment) {
        if (this.filter.isEnabled(ITraceFilter.LanguageElementKind.LANGUAGE_UNIT)) {
            String ver = Version.toString(script.getVersion());
            if (null != ver && ver.length() > 0) {
                ver = " version " + ver;
            }
            String location = "";
            ModelInfo<Script> info = BuildModel.INSTANCE.availableModels().getModelInfo(script);
            if (null != info) {
                location = " @ " + info.getLocation();
            }
            this.write("executing script " + script.getName() + " (" + script.getLanguageName() + ") " + ver + location);
            this.increaseIndentation();
        }
    }

    @Override
    public void visitScriptBody(Script script, RuntimeEnvironment<?, ?> environment) {
        if (this.filter.isEnabled(ITraceFilter.LanguageElementKind.LANGUAGE_UNIT)) {
            this.decreaseIndentation();
        }
    }

    @Override
    public void visitedScript(Script script) {
    }

    @Override
    public void visitDef(Def def, RuntimeEnvironment<?, ?> environment) {
        Template template;
        if (this.filter.isEnabled(ITraceFilter.LanguageElementKind.FUNCTION_DEFINITION)) {
            String msg = "execute def " + def.getSignature() + " with (";
            for (int p = 0; p < def.getParameterCount(); ++p) {
                try {
                    if (p > 0) {
                        msg = msg + ", ";
                    }
                    msg = msg + TracerHelper.toString(environment.getValue(def.getParameter(p)), true);
                    continue;
                }
                catch (VilException vilException) {
                    // empty catch block
                }
            }
            msg = msg + ")";
            this.write(msg);
            this.increaseIndentation();
        } else if (!this.templateDefVisited && "main".equals(def.getName()) && def.getDeclaringType() instanceof Template && (template = (Template)def.getDeclaringType()).getParameterCount() >= 2) {
            VariableDeclaration var = template.getParameter(1);
            try {
                Object value = environment.getValue(var);
                if (value instanceof IFileSystemArtifact) {
                    this.write("  -> " + ((IFileSystemArtifact)value).getPath());
                }
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        this.templateDefVisited = true;
    }

    @Override
    public void visitedDef(Def def, RuntimeEnvironment<?, ?> environment, Object result) {
        if (this.filter.isEnabled(ITraceFilter.LanguageElementKind.FUNCTION_DEFINITION)) {
            this.decreaseIndentation();
        }
    }

    @Override
    public void visitedSwitch(Object select, int alternative, Object value) {
    }

    @Override
    public void visitLoop(net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var) {
    }

    @Override
    public void visitedLoop(net.ssehub.easy.instantiation.core.model.common.VariableDeclaration var) {
    }

    @Override
    public void visitAlternative(boolean takeIf) {
    }

    @Override
    public void failedAt(ITemplateLangElement element) {
        if (this.filter.isEnabled(ITraceFilter.LanguageElementKind.FAILURE)) {
            StringWriter out = new StringWriter();
            TemplateLangWriter writer = new TemplateLangWriter(out);
            try {
                element.accept(writer);
            }
            catch (VilException vilException) {
                // empty catch block
            }
            this.write("failed at: " + out.toString());
        }
    }

    @Override
    public void visitTemplate(Template template) {
        this.templateDefVisited = false;
        if (this.filter.isEnabled(ITraceFilter.LanguageElementKind.LANGUAGE_UNIT)) {
            String location = "";
            ModelInfo<Template> info = TemplateModel.INSTANCE.availableModels().getModelInfo(template);
            if (null != info) {
                location = " @ " + info.getLocation();
            }
            this.write(template.getName() + " " + Version.toString(template.getVersion()) + location);
            this.increaseIndentation();
        }
    }

    @Override
    public void visitedTemplate(Template template) {
        this.templateDefVisited = false;
        if (this.filter.isEnabled(ITraceFilter.LanguageElementKind.LANGUAGE_UNIT)) {
            this.decreaseIndentation();
        }
    }

    @Override
    public void reset() {
        this.indentation = "";
    }

    @Override
    public void traceMessage(String message) {
        this.write(message);
    }

    @Override
    public void traceError(String message) {
        this.write(message);
    }

    @Override
    public void traceWarning(String message) {
        if (this.filter.isWarningEnabled()) {
            this.write("Warning: " + message);
        }
    }

    @Override
    public void visitWhileBody() {
    }

    @Override
    public void visitedWhileBody() {
    }

    protected boolean isEnabled() {
        return this.enable;
    }

    @Override
    public void enable(boolean enable) {
        this.enable = enable;
    }

    @Override
    public void visitFlush() {
    }

    @Override
    public void visitedFlush() {
    }
}

