/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.tracing;

import java.util.HashSet;
import java.util.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

class TracerHelper {
    private static final Set<TypeDescriptor<?>> EXCLUDED_TYPES = new HashSet();

    private TracerHelper() {
    }

    static boolean trace(OperationDescriptor descriptor) {
        return !EXCLUDED_TYPES.contains(descriptor.getDeclaringType()) && descriptor.trace();
    }

    static String toString(Object object, boolean quote) {
        String result = StringValueHelper.getStringValue(object, null);
        if (quote && object instanceof String) {
            result = "\"" + result.replace("\r", "").replace("\n", "") + "\"";
        }
        return result;
    }

    static {
        EXCLUDED_TYPES.add(TypeRegistry.stringType());
        EXCLUDED_TYPES.add(TypeRegistry.integerType());
        EXCLUDED_TYPES.add(TypeRegistry.booleanType());
        EXCLUDED_TYPES.add(TypeRegistry.realType());
    }
}

