/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractCollectionWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.varModel.model.datatypes.OclKeyWords;

public abstract class AbstractArrayWrapper<T>
extends AbstractCollectionWrapper<T>
implements Collection<T> {
    private T[] array;
    private TypeDescriptor<?>[] params;
    private TypeDescriptor<?> type;

    public AbstractArrayWrapper(T[] array, TypeRegistry registry, boolean set, Class<?> param) {
        this.array = array;
        this.params = registry.convert(param);
        this.type = AbstractArrayWrapper.constructType(this.params, set);
    }

    public AbstractArrayWrapper(T[] array, boolean set, TypeDescriptor<?> ... params) {
        this.array = array;
        this.params = params;
        this.type = AbstractArrayWrapper.constructType(this.params, set);
    }

    protected T[] getArray() {
        return this.array;
    }

    protected TypeDescriptor<?>[] getGenericParameter() {
        return this.params;
    }

    protected static <T> T[] removeDuplicates(T[] elements) {
        Object[] result;
        if (null == elements) {
            result = null;
        } else {
            ArrayList<T> tmp = new ArrayList<T>();
            HashSet<T> known = new HashSet<T>();
            for (int e = 0; e < elements.length; ++e) {
                T element = elements[e];
                if (known.contains(element)) continue;
                tmp.add(element);
                known.add(element);
            }
            result = tmp.toArray();
        }
        return result;
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            private int pos = 0;

            @Override
            public boolean hasNext() {
                return null != AbstractArrayWrapper.this.array && this.pos < AbstractArrayWrapper.this.array.length;
            }

            @Override
            public T next() {
                return AbstractArrayWrapper.this.array[this.pos++];
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("remove");
            }
        };
    }

    @Override
    public int size() {
        return null == this.array ? 0 : this.array.length;
    }

    @Override
    public int getGenericParameterCount() {
        return null == this.params ? 0 : this.params.length;
    }

    @Override
    public TypeDescriptor<?> getGenericParameterType(int index) {
        if (null == this.params) {
            throw new IndexOutOfBoundsException();
        }
        return this.params[index];
    }

    @Override
    public TypeDescriptor<?> getType() {
        return this.type;
    }

    @Override
    public String getStringValue(IStringValueProvider.StringComparator comparator) {
        return StringValueHelper.getStringValue(this, comparator);
    }

    @Override
    public boolean allowSequenceAdjustment() {
        return true;
    }

    protected void extendCapacity(int increment) {
        if (increment > 0) {
            Object[] tmp = new Object[this.array.length + increment];
            System.arraycopy(this.array, 0, tmp, 0, this.array.length);
            this.array = tmp;
        }
    }

    protected void decreaseCapacity(int decrement) {
        if (decrement > 0 && this.array.length - decrement >= 0) {
            Object[] tmp = new Object[this.array.length - decrement];
            if (tmp.length > 0) {
                System.arraycopy(this.array, 0, tmp, 0, tmp.length);
            }
            this.array = tmp;
        }
    }

    public boolean equals(Object object) {
        return null == this.array ? object == null : this.array.equals(object);
    }

    public int hashCode() {
        return null == this.array ? super.hashCode() : this.array.hashCode();
    }

    @Invisible
    public List<T> toMappedList() {
        ArrayList<T> result;
        if (null != this.array) {
            result = new ArrayList<T>(this.array.length);
            for (int i = 0; i < this.array.length; ++i) {
                result.add(this.array[i]);
            }
        } else {
            result = null;
        }
        return result;
    }

    @Invisible
    public Set<T> toMappedSet() {
        HashSet<T> result;
        if (null != this.array) {
            result = new HashSet<T>(this.array.length);
            for (int i = 0; i < this.array.length; ++i) {
                result.add(this.array[i]);
            }
        } else {
            result = null;
        }
        return result;
    }

    public boolean remove(T element) {
        int shift = 0;
        if (null != element) {
            T[] array = this.getArray();
            for (int t = 0; t < array.length; ++t) {
                boolean found = false;
                if (0 == shift) {
                    if (null == element) {
                        found = array[t] == null;
                    } else if (element.equals(array[t])) {
                        found = true;
                    }
                    if (found) {
                        ++shift;
                    }
                }
                if (shift <= 0 || t - shift <= 0) continue;
                array[t - shift] = array[t];
            }
            if (shift > 0) {
                this.decreaseCapacity(1);
            }
        }
        return shift > 0;
    }

    public void removeAll(T element) {
        if (this.size() > 0) {
            T[] array = this.getArray();
            for (int i = array.length - 1; i >= 0; --i) {
                T elt = array[i];
                if (!element.equals(elt)) continue;
                this.removeAt(i);
            }
        }
    }

    public T removeAt(int index) {
        return this.removeAtImpl(OclKeyWords.toJavaIndex(index));
    }

    private T removeAtImpl(int index) {
        T result = null;
        int size = this.size();
        if (size > 0 && 0 <= index && index < size) {
            T[] array = this.getArray();
            result = array[index];
            for (int i = index + 1; i < array.length; ++i) {
                array[i - 1] = array[i];
            }
            this.decreaseCapacity(1);
        }
        return result;
    }

    public T removeFirst() {
        return this.removeAtImpl(0);
    }

    public T removeLast() {
        return this.removeAtImpl(this.size() - 1);
    }

    @Override
    public void clear() {
        this.array = new Object[0];
    }
}

