/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import net.ssehub.easy.basics.DefaultLocale;
import net.ssehub.easy.instantiation.core.model.common.ExecutionLocal;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.AbstractCallExpression;
import net.ssehub.easy.instantiation.core.model.expressions.CallArgument;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.StringValueHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.DecisionVariable;
import net.ssehub.easy.instantiation.core.model.vilTypes.configuration.IvmlTypes;

public abstract class AbstractCollectionWrapper<T>
implements Collection<T> {
    public static final Comparator<Number> NUMBER_COMPARATOR = new Comparator<Number>(){

        @Override
        public int compare(Number o1, Number o2) {
            return Double.compare(o1.doubleValue(), o2.doubleValue());
        }
    };

    public static boolean equals(Collection<?> c1, Collection<?> c2) {
        boolean equals;
        boolean bl = equals = c1.size() == c2.size();
        if (equals) {
            Iterator<?> thisIter = c1.iterator();
            Iterator<?> eltIter = c2.iterator();
            while (equals && thisIter.hasNext() && eltIter.hasNext()) {
                equals = thisIter.next().equals(eltIter.next());
            }
        }
        return equals;
    }

    public static boolean sameElements(Collection<?> c1, Collection<?> c2) {
        boolean same;
        boolean bl = same = c1.size() == c2.size();
        if (same) {
            HashSet known = new HashSet();
            Iterator<?> iter = c2.iterator();
            while (iter.hasNext()) {
                known.add(iter.next());
            }
            iter = c1.iterator();
            while (same && iter.hasNext()) {
                same = known.contains(iter.next());
            }
        }
        return same;
    }

    @OperationMeta(returnGenerics={IVilType.class})
    public static <T> List<T> union(Collection<T> c1, Collection<T> c2) {
        ArrayList<T> result = new ArrayList<T>();
        HashSet<T> s1 = new HashSet<T>();
        for (T elt : c1) {
            s1.add(elt);
            result.add(elt);
        }
        for (T elt : c2) {
            if (s1.contains(elt)) continue;
            result.add(elt);
        }
        return result;
    }

    @OperationMeta(returnGenerics={IVilType.class})
    public static <T> List<T> intersection(Collection<T> c1, Collection<T> c2) {
        ArrayList<T> result = new ArrayList<T>();
        HashSet<T> s1 = new HashSet<T>();
        Iterator<T> iter = c1.iterator();
        while (iter.hasNext()) {
            s1.add(iter.next());
        }
        for (T elt : c2) {
            if (!s1.contains(elt)) continue;
            result.add(elt);
        }
        return result;
    }

    public static <T> List<T> excluding(Collection<T> base, Collection<?> elements) {
        HashSet known = new HashSet();
        Iterator<?> iter = elements.iterator();
        while (iter.hasNext()) {
            known.add(iter.next());
        }
        ArrayList<T> result = new ArrayList<T>();
        for (T element : base) {
            if (known.contains(element)) continue;
            result.add(element);
        }
        return result;
    }

    public static <T> List<T> including(Collection<T> base, Collection<T> elements) {
        ArrayList<T> result = new ArrayList<T>();
        HashSet<T> known = new HashSet<T>();
        for (T elt : base) {
            known.add(elt);
            result.add(elt);
        }
        for (T elt : elements) {
            if (known.contains(elt)) continue;
            result.add(elt);
        }
        return result;
    }

    public static <T> List<T> append(Collection<T> base, Collection<T> elements) {
        ArrayList<T> result = new ArrayList<T>();
        Iterator<T> iter = base.iterator();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        iter = elements.iterator();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    public static <T> List<T> selectByType(Collection<T> collection, TypeDescriptor<?> type, boolean byKind, boolean negate) {
        ArrayList result = new ArrayList();
        AbstractCollectionWrapper.selectByType(collection, type, result, byKind, negate);
        return result;
    }

    protected static <T> void selectByType(Collection<T> collection, TypeDescriptor<?> type, java.util.Collection<T> result, boolean byKind, boolean negate) {
        for (T element : collection) {
            if (null != type && !AbstractCollectionWrapper.isSelectedByType(type, element, byKind, negate)) continue;
            result.add(element);
        }
    }

    private static boolean isSelectedByType(TypeDescriptor<?> type, Object element, boolean byKind, boolean negate) {
        boolean result;
        boolean bl = result = byKind && type.isInstance(element) || !byKind && type.isSameType(element);
        if (negate) {
            result = !result;
        }
        return result;
    }

    @Invisible
    public static <T> List<T> select(Collection<T> collection, ExpressionEvaluator evaluator, boolean select) throws VilException {
        ArrayList result = new ArrayList();
        AbstractCollectionWrapper.select(collection, evaluator, result, select);
        return result;
    }

    protected static <T> T select(Collection<T> collection, ExpressionEvaluator evaluator, java.util.Collection<T> result, boolean select) throws VilException {
        T res = null;
        boolean isDecVar = AbstractCollectionWrapper.assertBooleanIterator(evaluator);
        for (T value : collection) {
            Object eval = evaluator.evaluate(value);
            Boolean selectionCriterion = null;
            if (isDecVar) {
                if (eval instanceof DecisionVariable) {
                    selectionCriterion = ((DecisionVariable)eval).getBooleanValue();
                }
            } else if (eval instanceof Boolean) {
                selectionCriterion = (Boolean)eval;
            }
            if (null == selectionCriterion || !AbstractCollectionWrapper.isSelected(selectionCriterion, select)) continue;
            res = value;
            if (null == result) break;
            result.add(value);
        }
        return res;
    }

    private static boolean assertBooleanIterator(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?> type = evaluator.getExpression().inferType();
        boolean isDecVar = IvmlTypes.decisionVariableType().isAssignableFrom(type);
        if (!isDecVar && !TypeRegistry.booleanType().isAssignableFrom(type)) {
            throw new VilException("iterator must be of type boolean", 30011);
        }
        return isDecVar;
    }

    @Override
    public T any(ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.any(this, evaluator);
    }

    @Invisible
    public static <T> T any(Collection<T> collection, ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.select(collection, evaluator, null, true);
    }

    @Invisible
    public static <T> Boolean exists(Collection<T> collection, ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.select(collection, evaluator, null, true) != null;
    }

    @Invisible
    public static <T> Boolean forAll(Collection<T> collection, ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.select(collection, evaluator, true).size() == collection.size();
    }

    @Invisible
    public static <T> Boolean isUnique(Collection<T> collection, ExpressionEvaluator evaluator) throws VilException {
        List<Object> tmp = AbstractCollectionWrapper.collect(collection, evaluator, false);
        HashSet<Object> tmpSet = new HashSet<Object>();
        int nullCount = 0;
        boolean unique = true;
        for (int i = 0; unique && i < tmp.size(); ++i) {
            Object val = tmp.get(i);
            if (null == val) {
                if (0 == nullCount) {
                    ++nullCount;
                    continue;
                }
                unique = false;
                continue;
            }
            unique = tmpSet.add(val);
        }
        return unique;
    }

    @Override
    public Boolean exists(ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.exists(this, evaluator);
    }

    @Override
    public Boolean forAll(ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.forAll(this, evaluator);
    }

    @Override
    public Boolean isUnique(ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.isUnique(this, evaluator);
    }

    @Invisible
    public static <T> T one(Collection<T> collection, ExpressionEvaluator evaluator) throws VilException {
        List<T> tmp = AbstractCollectionWrapper.select(collection, evaluator, true);
        T result = tmp.size() != 1 ? null : (T)tmp.get(0);
        return result;
    }

    @Override
    public T one(ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.one(this, evaluator);
    }

    public TypeDescriptor<?>[] getFlattenedParams(Collection<?> collection) {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = collection.getType().flattenParam();
        return param;
    }

    protected static <T1, T2> void flatten(Collection<T1> collection, java.util.Collection<T2> result) throws VilException {
        Iterator<T1> iter = collection.iterator();
        while (iter.hasNext()) {
            AbstractCollectionWrapper.flatten(iter.next(), result);
        }
    }

    private static <T1, T2> void flatten(T1 value, java.util.Collection<T2> result) throws VilException {
        if (value instanceof Collection) {
            AbstractCollectionWrapper.flatten((Collection)value, result);
        } else if (value instanceof java.util.Collection) {
            java.util.Collection coll = (java.util.Collection)value;
            for (Object o : coll) {
                AbstractCollectionWrapper.flatten(o, result);
            }
        } else {
            try {
                result.add(value);
            }
            catch (ClassCastException e) {
                new VilException(e, 50008);
            }
        }
    }

    private static boolean isSelected(boolean selectionCriterion, boolean select) {
        return select && selectionCriterion || !select && !selectionCriterion;
    }

    public static <T> Object apply(Collection<T> collection, ExpressionEvaluator evaluator) throws VilException {
        Iterator<T> iter = collection.iterator();
        evaluator.initializeDeclarators();
        while (iter.hasNext()) {
            evaluator.evaluate(iter.next());
        }
        return evaluator.getResultValue();
    }

    public static java.util.Set<Object> closure(Collection<?> collection, ExpressionEvaluator evaluator) throws VilException {
        HashSet<Object> result = new HashSet<Object>();
        Iterator<?> iter = collection.iterator();
        while (iter.hasNext()) {
            AbstractCollectionWrapper.closureOnElement(iter.next(), result, evaluator, false);
        }
        return result;
    }

    @Override
    public boolean isAcyclic(ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.isAcyclic(this, evaluator);
    }

    public static boolean isAcyclic(Collection<?> collection, ExpressionEvaluator evaluator) throws VilException {
        boolean cyclic = false;
        HashSet<Object> tmp = new HashSet<Object>();
        Iterator<?> iter = collection.iterator();
        while (!cyclic && iter.hasNext()) {
            cyclic = AbstractCollectionWrapper.closureOnElement(iter.next(), tmp, evaluator, true);
        }
        return !cyclic;
    }

    private static boolean closureOnElement(Object value, java.util.Set<Object> result, ExpressionEvaluator evaluator, boolean stopOnCycle) throws VilException {
        boolean cyclic = false;
        if (null != value) {
            Object eval;
            boolean bl = cyclic = !result.add(value);
            if (!cyclic && null != (eval = evaluator.evaluate(value))) {
                Iterator<Object> iter = null;
                if (eval instanceof Collection) {
                    iter = ((Collection)eval).iterator();
                } else if (eval instanceof java.util.Collection) {
                    iter = ((java.util.Collection)eval).iterator();
                } else {
                    boolean bl2 = cyclic = !result.add(value);
                }
                while (!(null == iter || !iter.hasNext() || cyclic && stopOnCycle)) {
                    cyclic |= AbstractCollectionWrapper.closureOnElement(iter.next(), result, evaluator, stopOnCycle);
                }
            }
        }
        return cyclic;
    }

    public static List<Object> collect(Collection<?> collection, ExpressionEvaluator evaluator, boolean flatten) throws VilException {
        ArrayList<Object> result = new ArrayList<Object>();
        AbstractCollectionWrapper.collect(collection, evaluator, result, flatten);
        return result;
    }

    protected static void collect(Collection<?> collection, ExpressionEvaluator evaluator, java.util.Collection<Object> result, boolean flatten) throws VilException {
        Iterator<?> iter = collection.iterator();
        while (iter.hasNext()) {
            AbstractCollectionWrapper.collect(iter.next(), evaluator, result, flatten);
        }
    }

    private static void collect(Object value, ExpressionEvaluator evaluator, java.util.Collection<Object> result, boolean flatten) throws VilException {
        Iterable coll;
        java.util.Collection<Object> res = result;
        Iterator<Object> iter = null;
        if (value instanceof Collection) {
            coll = (Collection)value;
            iter = coll.iterator();
            res = AbstractCollectionWrapper.createSubCollection(result, coll, flatten);
        } else if (value instanceof java.util.Collection) {
            coll = (java.util.Collection)value;
            iter = coll.iterator();
            res = AbstractCollectionWrapper.createSubCollection(result, coll, flatten);
        } else {
            Object eval = evaluator.evaluate(value);
            if (null != eval) {
                res.add(eval);
            }
        }
        if (null != iter) {
            while (iter.hasNext()) {
                AbstractCollectionWrapper.collect(iter.next(), evaluator, res, flatten);
            }
        }
    }

    private static java.util.Collection<Object> createSubCollection(java.util.Collection<Object> parent, Object template, boolean flatten) {
        java.util.Collection<Object> result = parent;
        if (!flatten) {
            if (template instanceof java.util.Set || template instanceof Set) {
                result = new HashSet<Object>();
                parent.add(result);
            } else if (template instanceof java.util.Set || template instanceof Sequence) {
                result = new ArrayList<Object>();
                parent.add(result);
            }
        }
        return result;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    @OperationMeta(name={"notEmpty", "isNotEmpty"}, notOclCompliant={"isNotEmpty"})
    public boolean isNotEmpty() {
        return this.size() != 0;
    }

    @Override
    public boolean includes(T element) {
        boolean found = false;
        Iterator iter = this.iterator();
        while (iter.hasNext() && !found) {
            found = iter.next().equals(element);
        }
        return found;
    }

    @Override
    public boolean excludes(T element) {
        return !this.includes(element);
    }

    @Override
    public int count(T element) {
        int count = 0;
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            if (!iter.next().equals(element)) continue;
            ++count;
        }
        return count;
    }

    protected List<T> sortAlphaImpl() {
        TreeMap mapping = new TreeMap(ExecutionLocal.getCurrentCollator());
        for (Object elt : this) {
            AbstractCollectionWrapper.getList(mapping, StringValueHelper.getStringValue(elt, null)).add(elt);
        }
        return AbstractCollectionWrapper.toEntryList(mapping);
    }

    private static <K, V> List<V> getList(Map<K, List<V>> map, K key) {
        List<V> list = map.get(key);
        if (null == list) {
            list = new ArrayList<V>();
            map.put(key, list);
        }
        return list;
    }

    private static <K, V> List<V> toEntryList(Map<K, List<V>> map) {
        ArrayList<V> result = new ArrayList<V>();
        for (List<V> list : map.values()) {
            result.addAll(list);
        }
        return result;
    }

    protected List<T> sortImpl(ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.sortImpl(this.iterator(), evaluator);
    }

    public static <T> List<T> sortImpl(Iterator<T> iter, ExpressionEvaluator evaluator) throws VilException {
        TreeMap tempMap;
        TypeDescriptor<?> compareEltType = evaluator.getExpression().inferType();
        if (TypeRegistry.realType().isAssignableFrom(compareEltType) || TypeRegistry.integerType().isAssignableFrom(compareEltType)) {
            TreeMap mapping = new TreeMap(NUMBER_COMPARATOR);
            while (iter.hasNext()) {
                T value = iter.next();
                Object eval = evaluator.evaluate(value);
                Number key = eval instanceof Number ? (Number)((Number)eval) : (Number)0;
                AbstractCollectionWrapper.getList(mapping, key).add(value);
            }
            tempMap = mapping;
        } else {
            TreeMap mapping = new TreeMap(Collator.getInstance(DefaultLocale.getDefaultLocale()));
            while (iter.hasNext()) {
                T value = iter.next();
                Object eval = evaluator.evaluate(value);
                String key = null != eval ? StringValueHelper.getStringValue(eval, null) : "";
                AbstractCollectionWrapper.getList(mapping, key).add(value);
            }
            tempMap = mapping;
        }
        return AbstractCollectionWrapper.toEntryList(tempMap);
    }

    protected List<T> revertImpl() {
        LinkedList tmp = new LinkedList();
        Iterator iter = this.iterator();
        while (iter.hasNext()) {
            tmp.add(0, iter.next());
        }
        return tmp;
    }

    protected static TypeDescriptor<?> constructType(TypeDescriptor<?>[] param, boolean set) {
        TypeDescriptor<Collection<?>> result;
        try {
            result = set ? TypeRegistry.getSetType(param) : TypeRegistry.getSequenceType(param);
        }
        catch (VilException e) {
            Class cls = set ? Set.class : Sequence.class;
            result = TypeRegistry.DEFAULT.findType(cls);
        }
        return result;
    }

    @Override
    public T sum() {
        return AbstractCollectionWrapper.aggregate(this, "+");
    }

    @Override
    @OperationMeta(useAny=true)
    public Object avg() {
        Object res = AbstractCollectionWrapper.aggregate(this, "+");
        TypeDescriptor<?> elementType = AbstractCollectionWrapper.getElementType(this);
        IMetaOperation op = null;
        CallArgument resArg = new CallArgument(elementType);
        CallArgument eltArg = new CallArgument(TypeRegistry.integerType());
        try {
            op = AbstractCallExpression.resolveOperation(elementType, "/", resArg, eltArg);
        }
        catch (VilException e) {
            try {
                op = AbstractCallExpression.resolveOperation(elementType, "div", resArg, eltArg);
            }
            catch (VilException vilException) {
                // empty catch block
            }
        }
        if (null != op) {
            try {
                res = op.invoke(res, this.size());
            }
            catch (VilException e) {
                res = null;
            }
        }
        return res;
    }

    @Override
    public T product() {
        return AbstractCollectionWrapper.aggregate(this, "*");
    }

    @Override
    public T min() {
        return AbstractCollectionWrapper.aggregate(this, "min");
    }

    @Override
    public T max() {
        return AbstractCollectionWrapper.aggregate(this, "max");
    }

    private static TypeDescriptor<?> getElementType(Collection<?> collection) {
        TypeDescriptor<?> elementType = 1 == collection.getGenericParameterCount() ? collection.getGenericParameterType(0) : TypeRegistry.anyType();
        return elementType;
    }

    public static <T> T aggregate(Collection<T> collection, String opName) {
        Object result = null;
        TypeDescriptor<T> elementType = AbstractCollectionWrapper.getElementType(collection);
        IMetaOperation op = null;
        CallArgument resArg = new CallArgument(elementType);
        CallArgument eltArg = new CallArgument(elementType);
        try {
            op = AbstractCallExpression.resolveOperation(elementType, opName, resArg, eltArg);
        }
        catch (VilException vilException) {
            // empty catch block
        }
        if (null != op && elementType.isAssignableFrom(op.getReturnType())) {
            Iterator<T> iter = collection.iterator();
            boolean first = true;
            while (iter.hasNext()) {
                T element = iter.next();
                if (first) {
                    result = element;
                } else {
                    try {
                        result = op.invoke(result, element);
                    }
                    catch (VilException e) {
                        result = null;
                        break;
                    }
                }
                first = false;
            }
        }
        return (T)result;
    }

    @Override
    public boolean includesAll(Collection<?> elements) {
        return AbstractCollectionWrapper.containsAll(this, elements, false);
    }

    @Override
    public boolean excludesAll(Collection<?> elements) {
        return AbstractCollectionWrapper.containsAll(this, elements, true);
    }

    public static boolean containsAll(Collection<?> base, Collection<?> elements, boolean negate) {
        boolean all = true;
        HashSet tmp = new HashSet();
        Iterator<?> myIter = base.iterator();
        while (myIter.hasNext()) {
            tmp.add(myIter.next());
        }
        Iterator<?> iter = elements.iterator();
        while (all && iter.hasNext()) {
            boolean eTmp = tmp.contains(iter.next());
            if (negate) {
                eTmp = !eTmp;
            }
            all = eTmp;
        }
        return all;
    }
}

