/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

class AliasTypeDescriptor<T>
extends TypeDescriptor<T> {
    private TypeDescriptor<T> type;
    private TypeRegistry registry;

    AliasTypeDescriptor(TypeRegistry registry, String name, TypeDescriptor<T> type) throws VilException {
        super(type.getGenericParameter());
        this.setName(name);
        this.type = type;
        this.registry = registry;
        this.setConversions(AliasTypeDescriptor.toCollection(type.getConversions()));
        this.setFields(AliasTypeDescriptor.toCollection(type.getFields()));
        this.setOperations(AliasTypeDescriptor.toCollection(type.getOperations()));
    }

    private static <T> Collection<T> toCollection(Iterable<T> src) {
        ArrayList<T> result = new ArrayList<T>();
        Iterator<T> iter = src.iterator();
        while (iter.hasNext()) {
            result.add(iter.next());
        }
        return result;
    }

    TypeDescriptor<?> getAliasedType() {
        return this.type;
    }

    @Override
    public boolean isAssignableFrom(IMetaType type) {
        return this.type.isAssignableFrom(type);
    }

    @Override
    public boolean isBasicType() {
        return this.type.isBasicType();
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.registry;
    }

    @Override
    public boolean isPlaceholder() {
        return this.type.isPlaceholder();
    }

    @Override
    public boolean isActualTypeOf(IMetaType type) {
        return this.type.isActualTypeOf(type);
    }

    @Override
    public IMetaType getBaseType() {
        return this.type.getBaseType();
    }

    @Override
    public IMetaType getSuperType() {
        return this.type.getSuperType();
    }

    @Override
    public boolean isInternal() {
        return this.type.isInternal();
    }

    @Override
    public Class<T> getTypeClass() {
        return this.type.getTypeClass();
    }

    @Override
    public boolean canBeInstantiated() {
        return this.type.canBeInstantiated();
    }

    @Override
    public T create(Object ... params) throws VilException {
        return this.type.create(params);
    }

    @Override
    public boolean isAssignableFrom(TypeDescriptor<?> desc) {
        return this.type.isAssignableFrom(desc);
    }

    @Override
    public boolean isIterator() {
        return this.type.isIterator();
    }

    @Override
    public boolean isMap() {
        return this.type.isMap();
    }

    @Override
    public boolean isCollection() {
        return this.type.isCollection();
    }

    @Override
    public boolean isSet() {
        return this.type.isSet();
    }

    @Override
    public boolean isSequence() {
        return this.type.isSequence();
    }

    @Override
    public boolean isInstance(Object object) {
        return this.type.isInstance(object);
    }

    @Override
    public boolean isSameType(Object object) {
        return this.type.isSameType(object);
    }

    @Override
    public OperationDescriptor addPlaceholderOperation(String name, int parameterCount, boolean acceptsNamedParameters) {
        return this.type.addPlaceholderOperation(name, parameterCount, acceptsNamedParameters);
    }

    @Override
    public boolean isInstantiator() {
        return this.type.isInstantiator();
    }

    @Override
    public boolean checkConversion(IMetaType param, IMetaOperation conversion) {
        return true;
    }

    static IMetaType unalias(IMetaType type) {
        if (type instanceof AliasTypeDescriptor) {
            type = ((AliasTypeDescriptor)type).getAliasedType();
        }
        return type;
    }

    static TypeDescriptor<?> unalias(TypeDescriptor<?> type) {
        if (type instanceof AliasTypeDescriptor) {
            type = ((AliasTypeDescriptor)type).getAliasedType();
        }
        return type;
    }
}

