/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaField;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.ReflectionOperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeHelper;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class ClassWrapper
implements IMetaType {
    private Class<?> cls;
    private OperationDescriptor[] operations;
    private TypeRegistry registry;

    public ClassWrapper(Class<?> cls, TypeRegistry registry) {
        this.cls = cls;
        this.registry = registry;
        Method[] methods = cls.getDeclaredMethods();
        if (null != methods) {
            ArrayList<ReflectionOperationDescriptor> tmp = new ArrayList<ReflectionOperationDescriptor>();
            for (int m = 0; m < methods.length; ++m) {
                Method method = methods[m];
                int modifier = method.getModifiers();
                if (!Modifier.isPublic(modifier) || !Modifier.isStatic(modifier) || Modifier.isAbstract(modifier)) continue;
                tmp.add(new ReflectionOperationDescriptor(null, methods[m], OperationDescriptor.isConstructor(methods[m])));
            }
            this.operations = new OperationDescriptor[tmp.size()];
            tmp.toArray(this.operations);
        }
    }

    @Override
    public String getName() {
        return this.cls.getSimpleName();
    }

    @Override
    public String getQualifiedName() {
        return this.getName();
    }

    @Override
    public int getOperationsCount() {
        return null == this.operations ? 0 : this.operations.length;
    }

    @Override
    public IMetaOperation getOperation(int index) {
        return this.operations[index];
    }

    @Override
    public boolean isAssignableFrom(IMetaType type) {
        return false;
    }

    @Override
    public IMetaOperation findConversion(IMetaType sourceType, IMetaType targetType) {
        return null;
    }

    @Override
    public boolean isBasicType() {
        return TypeHelper.isBasicType(this.cls);
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.registry;
    }

    @Override
    public boolean enableDynamicDispatch() {
        return false;
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }

    @Override
    public IMetaOperation addPlaceholderOperation(String name, int parameterCount, boolean acceptsNamedParameters) {
        return null;
    }

    @Override
    public boolean isActualTypeOf(IMetaType type) {
        return false;
    }

    @Override
    public IMetaType getBaseType() {
        return null;
    }

    @Override
    public int getFieldCount() {
        return 0;
    }

    @Override
    public IMetaField getField(int index) {
        throw new IndexOutOfBoundsException();
    }

    @Override
    public boolean isInternal() {
        return true;
    }

    @Invisible
    public Class<?> getWrappedClass() {
        return this.cls;
    }

    @Override
    public IMetaType getSuperType() {
        return null;
    }

    @Override
    public int getGenericParameterCount() {
        return 0;
    }

    @Override
    public TypeDescriptor<?> getGenericParameterType(int index) {
        throw new IllegalArgumentException();
    }

    @Override
    public boolean checkConversion(IMetaType param, IMetaOperation conversion) {
        return true;
    }

    @Override
    public List<IMetaOperation> getCandidates(String name, int unnamedArgsCount) {
        return TypeDescriptor.getCandidates(this, name, unnamedArgsCount);
    }
}

