/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.Iterator;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.vilTypes.ClassMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.CollectionOperations;
import net.ssehub.easy.instantiation.core.model.vilTypes.IStringValueProvider;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilGenericType;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;

@ClassMeta(furtherOperations=CollectionOperations.class)
public interface Collection<T>
extends Iterable<T>,
IVilGenericType,
IStringValueProvider {
    @Invisible(inherit=true)
    public int getGenericParameterCount();

    @Invisible(inherit=true)
    public TypeDescriptor<?> getGenericParameterType(int var1);

    public int size();

    @Invisible(inherit=true)
    public boolean allowSequenceAdjustment();

    public boolean isEmpty();

    @OperationMeta(name={"notEmpty", "isNotEmpty"}, notOclCompliant={"isNotEmpty"})
    public boolean isNotEmpty();

    public boolean includes(T var1);

    public boolean excludes(T var1);

    public int count(T var1);

    @Override
    @Invisible
    public Iterator<T> iterator();

    @OperationMeta(name={"equals"})
    public boolean isEquals(Collection<?> var1);

    public void clear();

    @OperationMeta(useGenericParameter=0)
    public Collection<T> select(ExpressionEvaluator var1) throws VilException;

    @OperationMeta(useGenericParameter=0)
    public Collection<T> reject(ExpressionEvaluator var1) throws VilException;

    @OperationMeta(useParameter=0, flatten=true)
    public Collection<?> closure(ExpressionEvaluator var1) throws VilException;

    public boolean isAcyclic(ExpressionEvaluator var1) throws VilException;

    @OperationMeta(useParameter=0, flatten=true)
    public Collection<?> collect(ExpressionEvaluator var1) throws VilException;

    @OperationMeta(useParameter=0x7FFFFFFF)
    public Collection<?> collectNested(ExpressionEvaluator var1) throws VilException;

    public T any(ExpressionEvaluator var1) throws VilException;

    public T one(ExpressionEvaluator var1) throws VilException;

    public Boolean exists(ExpressionEvaluator var1) throws VilException;

    public Boolean forAll(ExpressionEvaluator var1) throws VilException;

    public Boolean isUnique(ExpressionEvaluator var1) throws VilException;

    @OperationMeta(returnGenerics={IVilType.class})
    public Collection<T> selectByType(TypeDescriptor<?> var1);

    @OperationMeta(name={"selectByKind", "typeSelect"}, returnGenerics={IVilType.class})
    public Collection<T> selectByKind(TypeDescriptor<?> var1);

    @OperationMeta(returnGenerics={IVilType.class})
    public Collection<T> typeReject(TypeDescriptor<?> var1);

    public T sum();

    @OperationMeta(useAny=true)
    public Object avg();

    public T product();

    public T min();

    public T max();

    public boolean includesAll(Collection<?> var1);

    public boolean excludesAll(Collection<?> var1);

    @OperationMeta(name={"asSequence", "toSequence"}, notOclCompliant={"asSequence"})
    public Sequence<T> asSequence();

    @OperationMeta(name={"asSet", "toSet"}, notOclCompliant={"asSet"})
    public Set<T> asSet();

    @OperationMeta(useGenericParameter=0, flatten=true)
    public Collection<?> flatten() throws VilException;

    @OperationMeta(name={"sortedBy", "sort"}, notOclCompliant={"sort"}, returnGenerics={IVilType.class})
    public Collection<T> sortedBy(ExpressionEvaluator var1) throws VilException;

    @OperationMeta(name={"apply", "iterate"}, notOclCompliant={"apply"}, allowsAggregation=true)
    public Object apply(ExpressionEvaluator var1) throws VilException;

    @OperationMeta(name={"clone"})
    public Collection<T> cloneCollection();
}

