/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.ssehub.easy.basics.logger.EASyLoggerFactory;
import net.ssehub.easy.instantiation.core.model.common.IModifier;
import net.ssehub.easy.instantiation.core.model.common.IModifierHolder;
import net.ssehub.easy.instantiation.core.model.common.VariableDeclaration;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.Expression;
import net.ssehub.easy.instantiation.core.model.vilTypes.CompoundInstance;
import net.ssehub.easy.instantiation.core.model.vilTypes.FieldDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaOperation;
import net.ssehub.easy.instantiation.core.model.vilTypes.IMetaType;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class CompoundTypeDescriptor
extends TypeDescriptor<CompoundInstance> {
    private boolean isAbstract;
    private CompoundTypeDescriptor refines;
    private TypeRegistry registry;

    public CompoundTypeDescriptor(String name, boolean isAbstract, CompoundTypeDescriptor refines, TypeRegistry registry) throws VilException {
        super(null);
        this.setName(name);
        this.refines = refines;
        this.isAbstract = isAbstract;
        this.registry = registry;
        ArrayList<OperationDescriptor> operations = new ArrayList<OperationDescriptor>();
        operations.add(new TypeOperationDescriptor(this, "getName"));
        operations.add(new TypeOperationDescriptor(this, "name"));
        operations.add(new ConstructorOperationDescriptor(this));
        TypeOperationDescriptor toString = new TypeOperationDescriptor(this, "toString");
        operations.add(toString);
        this.setOperations(operations);
        operations.clear();
        operations.add(toString);
        this.setConversions(operations);
        operations.clear();
    }

    @Override
    public boolean isAssignableFrom(IMetaType type) {
        boolean result = false;
        if (type instanceof CompoundTypeDescriptor) {
            result = this.isAssignableFrom((CompoundTypeDescriptor)type);
        }
        return result;
    }

    @Override
    public boolean isBasicType() {
        return false;
    }

    @Override
    public TypeRegistry getTypeRegistry() {
        return this.registry;
    }

    @Override
    public boolean isPlaceholder() {
        return false;
    }

    @Override
    public boolean isActualTypeOf(IMetaType type) {
        return false;
    }

    @Override
    public IMetaType getBaseType() {
        return null;
    }

    @Override
    public IMetaType getSuperType() {
        return this.refines;
    }

    public CompoundTypeDescriptor getRefines() {
        return this.refines;
    }

    @Override
    public boolean isInternal() {
        return false;
    }

    @Override
    public boolean checkConversion(IMetaType param, IMetaOperation conversion) {
        return true;
    }

    @Override
    public Class<CompoundInstance> getTypeClass() {
        return CompoundInstance.class;
    }

    @Override
    public boolean canBeInstantiated() {
        return !this.isAbstract;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    @Override
    public CompoundInstance create(Object ... params) throws VilException {
        CompoundInstance result = this.isAbstract ? null : new CompoundInstance(this);
        return result;
    }

    @Override
    public boolean isAssignableFrom(TypeDescriptor<?> desc) {
        boolean isAssignable = false;
        if (desc instanceof CompoundTypeDescriptor) {
            for (CompoundTypeDescriptor iter = (CompoundTypeDescriptor)desc; null != iter && !isAssignable; iter = iter.getRefines()) {
                isAssignable = this.isSameType(iter);
            }
        }
        return isAssignable;
    }

    @Override
    public boolean isMap() {
        return false;
    }

    @Override
    public boolean isIterator() {
        return false;
    }

    @Override
    public boolean isCollection() {
        return false;
    }

    @Override
    public boolean isSet() {
        return false;
    }

    @Override
    public boolean isSequence() {
        return false;
    }

    @Override
    public boolean isInstance(Object object) {
        boolean result = false;
        if (object instanceof CompoundInstance) {
            CompoundInstance tmp = (CompoundInstance)object;
            result = this.isAssignableFrom(tmp.getType());
        }
        return result;
    }

    @Override
    public boolean isSameType(Object object) {
        return object == this;
    }

    @Override
    public OperationDescriptor addPlaceholderOperation(String name, int parameterCount, boolean acceptsNamedParameters) {
        return null;
    }

    @Override
    public boolean isInstantiator() {
        return false;
    }

    public void setFields(SlotDescriptor[] slots) throws VilException {
        if (!this.isFieldsNull()) {
            throw new VilException("Fields are already defined", 70000);
        }
        super.setFields(slots);
    }

    public SlotDescriptor getSlot(int index) {
        return (SlotDescriptor)this.getField(index);
    }

    public int getSlotCount() {
        return this.getFieldCount();
    }

    public FieldDescriptor getDeclaredField(String name) {
        return super.getField(name);
    }

    @Override
    public FieldDescriptor getField(String name) {
        FieldDescriptor field = null;
        for (CompoundTypeDescriptor iter = this; null != iter && null == field; iter = iter.getRefines()) {
            field = iter.getDeclaredField(name);
        }
        return field;
    }

    public SlotDescriptor getSlot(String name) {
        return (SlotDescriptor)this.getField(name);
    }

    public SlotDescriptor getDeclaredSlot(String name) {
        return (SlotDescriptor)this.getDeclaredField(name);
    }

    private static class TypeOperationDescriptor
    extends OperationDescriptor {
        protected TypeOperationDescriptor(TypeDescriptor<?> declaringType, String name) {
            super(declaringType, name, false);
            ArrayList params = new ArrayList();
            params.add(declaringType);
            this.setParameters(params, false, false);
            this.setReturnType(TypeRegistry.stringType());
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public boolean isFirstParameterOperand() {
            return true;
        }

        @Override
        public boolean isPlaceholder() {
            return false;
        }

        @Override
        public IMetaOperation.CompatibilityResult isCompatible(Class<?> retType, Object ... params) {
            return IMetaOperation.CompatibilityResult.COMPATIBLE;
        }

        @Override
        public Object invoke(Object ... args) throws VilException {
            Object a0;
            String result = null;
            if (1 == args.length && (a0 = args[0]) instanceof CompoundTypeDescriptor) {
                result = ((CompoundTypeDescriptor)a0).getName();
            }
            return result;
        }

        @Override
        protected void initializeParameters() {
        }

        @Override
        protected void initializeReturnType() {
        }

        @Override
        protected String getDeclaringTypeNameFallback() {
            return null;
        }

        @Override
        public String getJavaSignature() {
            return this.getName() + "()";
        }

        @Override
        public int useGenericParameterAsReturn() {
            return 0;
        }

        @Override
        public int useParameterAsReturn() {
            return 0;
        }

        @Override
        public boolean storeArtifactsBeforeExecution() {
            return false;
        }
    }

    private static class ConstructorOperationDescriptor
    extends OperationDescriptor {
        protected ConstructorOperationDescriptor(TypeDescriptor<?> declaringType) {
            super(declaringType, "create", true);
            this.setParameters(new ArrayList(), true, false);
            this.setReturnType(declaringType);
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public boolean isFirstParameterOperand() {
            return false;
        }

        @Override
        public boolean isPlaceholder() {
            return false;
        }

        @Override
        public IMetaOperation.CompatibilityResult isCompatible(Class<?> retType, Object ... params) {
            return IMetaOperation.CompatibilityResult.COMPATIBLE;
        }

        @Override
        public Object invoke(Object ... args) throws VilException {
            CompoundInstance result = new CompoundInstance((CompoundTypeDescriptor)this.getDeclaringType());
            if (1 == args.length && args[0] instanceof Map) {
                Map a0 = (Map)args[0];
                for (Map.Entry e : a0.entrySet()) {
                    try {
                        result.setSlotValue(e.getKey().toString(), e.getValue());
                    }
                    catch (VilException ex) {
                        EASyLoggerFactory.INSTANCE.getLogger(this.getClass(), "net.ssehub.easy.instantiation.core").warn(ex.getMessage());
                    }
                }
            }
            return result;
        }

        @Override
        protected void initializeParameters() {
        }

        @Override
        protected void initializeReturnType() {
        }

        @Override
        protected String getDeclaringTypeNameFallback() {
            return null;
        }

        @Override
        public String getJavaSignature() {
            return this.getName() + "()";
        }

        @Override
        public int useGenericParameterAsReturn() {
            return 0;
        }

        @Override
        public int useParameterAsReturn() {
            return 0;
        }

        @Override
        public boolean storeArtifactsBeforeExecution() {
            return false;
        }
    }

    public static class SlotDescriptor
    extends FieldDescriptor
    implements IModifierHolder {
        private List<IModifier> modifiers;
        private Expression expression;
        private boolean isConstant;

        public SlotDescriptor(CompoundTypeDescriptor declaringType, VariableDeclaration var) {
            super(declaringType, var.getName(), var.getType());
            int modCount = var.getModifierCount();
            if (modCount > 0) {
                this.modifiers = new ArrayList<IModifier>(modCount);
                for (int i = 0; i < modCount; ++i) {
                    this.modifiers.add(var.getModifier(i));
                }
            }
            this.expression = var.getExpression();
            this.isConstant = var.isConstant();
        }

        @Override
        public String getJavaSignature() {
            return ((TypeDescriptor)this.getType()).getVilName() + " " + this.getName();
        }

        @Override
        public boolean isReadOnly() {
            return this.isConstant;
        }

        public boolean isConstant() {
            return this.isConstant;
        }

        @Override
        public boolean isStatic() {
            return false;
        }

        @Override
        public Object getValue(Object owner) throws VilException {
            Object result = null;
            if (owner instanceof CompoundInstance) {
                result = ((CompoundInstance)owner).getSlotValue(this.getName());
            }
            return result;
        }

        @Override
        public void setValue(Object owner, Object value) throws VilException {
            if (owner instanceof CompoundInstance) {
                ((CompoundInstance)owner).setSlotValue(this.getName(), value);
            }
        }

        @Override
        public int getModifierCount() {
            return null == this.modifiers ? 0 : this.modifiers.size();
        }

        @Override
        public IModifier getModifier(int index) {
            if (null == this.modifiers) {
                throw new IndexOutOfBoundsException();
            }
            return this.modifiers.get(index);
        }

        @Override
        public boolean hasModifier(IModifier modifier) {
            return null == this.modifiers ? false : this.modifiers.contains(modifier);
        }

        public Expression getExpression() {
            return this.expression;
        }
    }
}

