/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractCollectionWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractListWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.Map;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.SequenceOperations;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.SetSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;
import net.ssehub.easy.varModel.model.datatypes.OclKeyWords;

public class ListSequence<T>
extends AbstractListWrapper<T>
implements Sequence<T> {
    public ListSequence(List<T> list, Class<?> param) {
        super(list, TypeRegistry.DEFAULT, false, param);
    }

    public ListSequence(List<T> list, TypeRegistry registry, Class<?> param) {
        super(list, registry, false, param);
    }

    public ListSequence(List<T> list, TypeDescriptor<?> ... params) {
        super(list, false, params);
    }

    @Override
    public T at(int index) {
        List list = this.getList();
        int i = OclKeyWords.toJavaIndex(index);
        T result = null == list || i < 0 || i >= list.size() ? null : (T)list.get(index);
        return result;
    }

    @Override
    public T get(int index) {
        return this.at(OclKeyWords.toJavaIndex(index));
    }

    @Invisible
    public static final <T> Sequence<T> empty(TypeDescriptor<?> param) {
        TypeDescriptor<?>[] params = TypeDescriptor.createArray(1);
        params[0] = param;
        return new ListSequence<T>(null, params);
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> selectByType(TypeDescriptor<?> type) {
        return new ListSequence(ListSequence.selectByType(this, type, false, false), this.getGenericParameter());
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> selectByKind(TypeDescriptor<?> type) {
        return new ListSequence(ListSequence.selectByType(this, type, true, false), this.getGenericParameter());
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> typeReject(TypeDescriptor<?> type) {
        return new ListSequence(ListSequence.selectByType(this, type, true, true), this.getGenericParameter());
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> excluding(Collection<T> sequence) {
        return new ListSequence(ListSequence.excluding(this, sequence), this.getGenericParameter());
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> append(Collection<T> sequence) {
        return new ListSequence<T>(ListSequence.append(this, sequence), this.getGenericParameter());
    }

    @Override
    public Sequence<?> flatten() throws VilException {
        ArrayList result = new ArrayList();
        ListSequence.flatten(this, result);
        return new ListSequence(result, this.getFlattenedParams(this));
    }

    @Override
    public Sequence<T> select(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.getIteratorVariable().getType();
        return new ListSequence(ListSequence.select(this, evaluator, true), param);
    }

    @Override
    public Sequence<T> reject(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.getIteratorVariable().getType();
        return new ListSequence(ListSequence.select(this, evaluator, false), param);
    }

    @Override
    public Sequence<?> collect(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        return new ListSequence<Object>(ListSequence.collect(this, evaluator, true), param);
    }

    @Override
    public Sequence<?> collectNested(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        return new ListSequence<Object>(ListSequence.collect(this, evaluator, false), param);
    }

    @Override
    public Set<?> closure(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        return new SetSet<Object>(ListSequence.closure(this, evaluator), param);
    }

    @Override
    public Object apply(ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.apply(this, evaluator);
    }

    @Override
    @OperationMeta(name={"equals"})
    public boolean isEquals(Collection<?> elements) {
        return ListSequence.equals(this, elements);
    }

    @Override
    public Set<T> toSet() {
        return new ListSet(this.getList(), this.getGenericParameter());
    }

    @Override
    public Set<T> asSet() {
        return this.toSet();
    }

    @Override
    public Sequence<T> asSequence() {
        return this;
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> sortAlpha() {
        ListSequence result = null == this.getList() ? this : new ListSequence(this.sortAlphaImpl(), this.getGenericParameter());
        return result;
    }

    @Override
    @OperationMeta(name={"sortedBy", "sort"}, notOclCompliant={"sort"}, returnGenerics={IVilType.class})
    public Sequence<T> sortedBy(ExpressionEvaluator evaluator) throws VilException {
        ListSequence result = null == this.getList() ? this : new ListSequence(this.sortImpl(evaluator), this.getGenericParameter());
        return result;
    }

    @Override
    @OperationMeta(name={"reverse", "revert"}, notOclCompliant={"revert"}, returnGenerics={IVilType.class})
    public Sequence<T> revert() {
        ListSequence result = null == this.getList() ? this : new ListSequence(this.revertImpl(), this.getGenericParameter());
        return result;
    }

    @Override
    public T first() {
        List list = this.getList();
        T result = 0 == list.size() ? null : (T)list.get(0);
        return result;
    }

    @Override
    public T last() {
        List list = this.getList();
        T result = 0 == list.size() ? null : (T)list.get(this.size() - 1);
        return result;
    }

    @Override
    public int indexOf(T element) {
        return OclKeyWords.toIvmlIndex(this.getList().indexOf(element));
    }

    @Override
    @OperationMeta(genericArgument={0})
    public T add(T element) {
        this.getList().add(element);
        return element;
    }

    @Override
    public boolean remove(T element) {
        return this.getList().remove(element);
    }

    @Override
    public Map<T, T> mapSequence(Sequence<T> other) {
        return SequenceOperations.mapSequence(this, other);
    }

    @Override
    public Map<T, T> mapAny(Sequence<T> other) {
        return SequenceOperations.mapAny(this, other);
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> union(Sequence<T> seq) {
        return new ListSequence<T>(SequenceOperations.union(this, seq), this.getGenericParameter());
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> append(T object) {
        return new ListSequence<T>(SequenceOperations.append(this, object), this.getGenericParameter());
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> prepend(T object) {
        return new ListSequence<T>(SequenceOperations.prepend(this, object), this.getGenericParameter());
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> insertAt(int index, T object) {
        return new ListSequence<T>(SequenceOperations.insertAt(this, index, object), this.getGenericParameter());
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Sequence<T> subSequence(int lower, int upper) {
        return new ListSequence(SequenceOperations.subSequence(this, lower, upper), this.getGenericParameter());
    }

    @Override
    public boolean allowSequenceAdjustment() {
        return false;
    }

    @Override
    public boolean hasDuplicates() {
        return SequenceOperations.hasDuplicates(this);
    }

    @Override
    public boolean overlaps(Sequence<T> other) {
        return SequenceOperations.overlaps(this, other);
    }

    @Override
    public boolean isSubsequenceOf(Sequence<T> other) {
        return SequenceOperations.isSubsequenceOf(this, other);
    }

    @Override
    public String joinfields(String separator, String begin, String end) {
        return SequenceOperations.joinfields(this, separator, begin, end);
    }

    @Override
    public void removeAll(T element) {
        List lst = this.getList();
        for (int i = lst.size() - 1; i >= 0; --i) {
            Object elt = lst.get(i);
            if (!element.equals(elt)) continue;
            lst.remove(i);
        }
    }

    @Override
    public T removeAt(int index) {
        return this.getList().remove(OclKeyWords.toJavaIndex(index));
    }

    @Override
    public T removeFirst() {
        return this.size() > 0 ? (T)this.getList().remove(0) : null;
    }

    @Override
    public T removeLast() {
        int size = this.size();
        return size > 0 ? (T)this.getList().remove(size - 1) : null;
    }

    @Override
    public Sequence<T> cloneCollection() {
        return new ListSequence(this.getList(), this.getGenericParameter());
    }
}

