/*
 * Decompiled with CFR 0.152.
 */
package net.ssehub.easy.instantiation.core.model.vilTypes;

import java.util.ArrayList;
import java.util.List;
import net.ssehub.easy.instantiation.core.model.common.VilException;
import net.ssehub.easy.instantiation.core.model.expressions.ExpressionEvaluator;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractCollectionWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.AbstractListWrapper;
import net.ssehub.easy.instantiation.core.model.vilTypes.Collection;
import net.ssehub.easy.instantiation.core.model.vilTypes.IVilType;
import net.ssehub.easy.instantiation.core.model.vilTypes.Invisible;
import net.ssehub.easy.instantiation.core.model.vilTypes.ListSequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.OperationMeta;
import net.ssehub.easy.instantiation.core.model.vilTypes.Sequence;
import net.ssehub.easy.instantiation.core.model.vilTypes.Set;
import net.ssehub.easy.instantiation.core.model.vilTypes.SetOperations;
import net.ssehub.easy.instantiation.core.model.vilTypes.SetSet;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeDescriptor;
import net.ssehub.easy.instantiation.core.model.vilTypes.TypeRegistry;

public class ListSet<T>
extends AbstractListWrapper<T>
implements Set<T> {
    public ListSet(List<T> list, TypeRegistry registry, Class<?> param) {
        super(ListSet.removeDuplicates(list), registry, true, param);
    }

    public ListSet(List<T> list, Class<?> param) {
        super(ListSet.removeDuplicates(list), true, TypeRegistry.DEFAULT.convert(param));
    }

    public ListSet(List<T> list, TypeDescriptor<?> ... params) {
        super(ListSet.removeDuplicates(list), true, params);
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Set<T> selectByType(TypeDescriptor<?> type) {
        return new ListSet(ListSet.selectByType(this, type, false, false), this.getGenericParameter());
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Set<T> selectByKind(TypeDescriptor<?> type) {
        return new ListSet(ListSet.selectByType(this, type, true, false), this.getGenericParameter());
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Set<T> typeReject(TypeDescriptor<?> type) {
        return new ListSet(ListSet.selectByType(this, type, true, true), this.getGenericParameter());
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Set<T> excluding(Collection<T> set) {
        return new ListSet(ListSet.excluding(this, set), this.getGenericParameter());
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Set<T> including(Collection<T> set) {
        return new ListSet<T>(ListSet.including(this, set), this.getGenericParameter());
    }

    @Override
    public Set<?> flatten() throws VilException {
        ArrayList result = new ArrayList();
        ListSet.flatten(this, result);
        return new ListSet(result, this.getFlattenedParams(this));
    }

    @Override
    public Set<T> select(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.getIteratorVariable().getType();
        return new ListSet(ListSet.select(this, evaluator, true), param);
    }

    @Override
    public Set<T> reject(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.getIteratorVariable().getType();
        return new ListSet(ListSet.select(this, evaluator, false), param);
    }

    @Override
    public Set<?> collect(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        return new ListSet<Object>(ListSet.collect(this, evaluator, true), param);
    }

    @Override
    public Set<?> collectNested(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        return new ListSet<Object>(ListSet.collect(this, evaluator, false), param);
    }

    @Override
    public Set<?> closure(ExpressionEvaluator evaluator) throws VilException {
        TypeDescriptor<?>[] param = TypeDescriptor.createArray(1);
        param[0] = evaluator.inferType();
        return new SetSet<Object>(ListSet.closure(this, evaluator), param);
    }

    @Override
    public Object apply(ExpressionEvaluator evaluator) throws VilException {
        return AbstractCollectionWrapper.apply(this, evaluator);
    }

    @Override
    @OperationMeta(name={"equals"})
    public boolean isEquals(Collection<?> elements) {
        return ListSet.sameElements(this, elements);
    }

    @Override
    public Sequence<T> toSequence() {
        return new ListSequence(this.getList(), this.getGenericParameter());
    }

    @Override
    public Sequence<T> asSequence() {
        return this.toSequence();
    }

    @Override
    public Set<T> asSet() {
        return this;
    }

    @Override
    public T projectSingle() {
        return 1 == this.size() ? (T)this.getList().get(0) : null;
    }

    @Invisible
    public static final <T> Set<T> empty(TypeDescriptor<?> param) {
        TypeDescriptor<?>[] params = TypeDescriptor.createArray(1);
        params[0] = param;
        return new ListSet<T>(null, params);
    }

    @Override
    @OperationMeta(genericArgument={0})
    public T add(T element) {
        if (!this.getList().contains(element)) {
            this.getList().add(element);
        }
        return element;
    }

    @Override
    public boolean remove(T element) {
        return this.getList().remove(element);
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Set<T> union(Set<T> set) {
        return new ListSet<T>(ListSet.union(this, set), this.getGenericParameter());
    }

    @Override
    @OperationMeta(returnGenerics={IVilType.class})
    public Set<T> intersection(Set<T> set) {
        return new ListSet<T>(ListSet.intersection(this, set), this.getGenericParameter());
    }

    @Override
    @OperationMeta(name={"sortedBy", "sort"}, notOclCompliant={"sort"}, returnGenerics={IVilType.class})
    public Collection<T> sortedBy(ExpressionEvaluator evaluator) throws VilException {
        AbstractListWrapper result = null == this.getList() ? this : new ListSequence(this.sortImpl(evaluator), this.getGenericParameter());
        return result;
    }

    @Override
    public Set<T> difference(Set<T> set) {
        return new SetSet<T>(SetOperations.difference(this, set), this.getGenericParameter());
    }

    @Override
    public Set<T> symmetricDifference(Set<T> set) {
        return new SetSet<T>(SetOperations.symmetricDifference(this, set), this.getGenericParameter());
    }

    @Override
    public Set<T> cloneCollection() {
        return new ListSet(new ArrayList(this.getList()), this.getGenericParameter());
    }
}

